/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import com.google.common.annotations.VisibleForTesting;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.crypto.SecretKey;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationSubmissionContextPBImpl;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.resourcemanager.RMFatalEvent;
import org.apache.hadoop.yarn.server.resourcemanager.RMFatalEventType;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreAMRMTokenEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreEventType;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreRMDTEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreRMDTMasterKeyEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreRemoveAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreRemoveAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateUpdateAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateUpdateAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateVersionIncompatibleException;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.AMRMTokenSecretManagerState;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationAttemptStateData;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationStateData;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.AggregateAppResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.state.InvalidStateTransitonException;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class RMStateStore
extends AbstractService {
    protected static final String RM_APP_ROOT = "RMAppRoot";
    protected static final String RM_DT_SECRET_MANAGER_ROOT = "RMDTSecretManagerRoot";
    protected static final String DELEGATION_KEY_PREFIX = "DelegationKey_";
    protected static final String DELEGATION_TOKEN_PREFIX = "RMDelegationToken_";
    protected static final String DELEGATION_TOKEN_SEQUENCE_NUMBER_PREFIX = "RMDTSequenceNumber_";
    protected static final String AMRMTOKEN_SECRET_MANAGER_ROOT = "AMRMTokenSecretManagerRoot";
    protected static final String VERSION_NODE = "RMVersionNode";
    protected static final String EPOCH_NODE = "EpochNode";
    private ResourceManager resourceManager;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    public static final Logger LOG = LoggerFactory.getLogger(RMStateStore.class);
    private static final Marker FATAL = MarkerFactory.getMarker((String)"FATAL");
    private static final StateMachineFactory<RMStateStore, RMStateStoreState, RMStateStoreEventType, RMStateStoreEvent> stateMachineFactory = new StateMachineFactory((Enum)RMStateStoreState.ACTIVE).addTransition((Enum)RMStateStoreState.ACTIVE, (Enum)RMStateStoreState.ACTIVE, (Enum)RMStateStoreEventType.STORE_APP, (SingleArcTransition)new StoreAppTransition()).addTransition((Enum)RMStateStoreState.ACTIVE, (Enum)RMStateStoreState.ACTIVE, (Enum)RMStateStoreEventType.UPDATE_APP, (SingleArcTransition)new UpdateAppTransition()).addTransition((Enum)RMStateStoreState.ACTIVE, (Enum)RMStateStoreState.ACTIVE, (Enum)RMStateStoreEventType.REMOVE_APP, (SingleArcTransition)new RemoveAppTransition()).addTransition((Enum)RMStateStoreState.ACTIVE, (Enum)RMStateStoreState.ACTIVE, (Enum)RMStateStoreEventType.STORE_APP_ATTEMPT, (SingleArcTransition)new StoreAppAttemptTransition()).addTransition((Enum)RMStateStoreState.ACTIVE, (Enum)RMStateStoreState.ACTIVE, (Enum)RMStateStoreEventType.UPDATE_APP_ATTEMPT, (SingleArcTransition)new UpdateAppAttemptTransition()).addTransition((Enum)RMStateStoreState.ACTIVE, (Enum)RMStateStoreState.ACTIVE, (Enum)RMStateStoreEventType.REMOVE_APP_ATTEMPT, (SingleArcTransition)new RemoveAppAttemptTransition()).addTransition((Enum)RMStateStoreState.ACTIVE, (Enum)RMStateStoreState.ACTIVE, (Enum)RMStateStoreEventType.STORE_MASTERKEY, (SingleArcTransition)new StoreRMDTMasterKeyTransition()).addTransition((Enum)RMStateStoreState.ACTIVE, (Enum)RMStateStoreState.ACTIVE, (Enum)RMStateStoreEventType.REMOVE_MASTERKEY, (SingleArcTransition)new RemoveRMDTMasterKeyTransition()).addTransition((Enum)RMStateStoreState.ACTIVE, (Enum)RMStateStoreState.ACTIVE, (Enum)RMStateStoreEventType.STORE_DELEGATION_TOKEN, (SingleArcTransition)new StoreRMDTTransition()).addTransition((Enum)RMStateStoreState.ACTIVE, (Enum)RMStateStoreState.ACTIVE, (Enum)RMStateStoreEventType.REMOVE_DELEGATION_TOKEN, (SingleArcTransition)new RemoveRMDTTransition()).addTransition((Enum)RMStateStoreState.ACTIVE, (Enum)RMStateStoreState.ACTIVE, (Enum)RMStateStoreEventType.UPDATE_DELEGATION_TOKEN, (SingleArcTransition)new UpdateRMDTTransition()).addTransition((Enum)RMStateStoreState.ACTIVE, (Enum)RMStateStoreState.ACTIVE, (Enum)RMStateStoreEventType.UPDATE_AMRM_TOKEN, (SingleArcTransition)new StoreOrUpdateAMRMTokenTransition()).addTransition((Enum)RMStateStoreState.ACTIVE, (Enum)RMStateStoreState.FENCED, (Enum)RMStateStoreEventType.FENCED).addTransition((Enum)RMStateStoreState.FENCED, (Enum)RMStateStoreState.FENCED, EnumSet.of(RMStateStoreEventType.STORE_APP, new RMStateStoreEventType[]{RMStateStoreEventType.UPDATE_APP, RMStateStoreEventType.REMOVE_APP, RMStateStoreEventType.STORE_APP_ATTEMPT, RMStateStoreEventType.UPDATE_APP_ATTEMPT, RMStateStoreEventType.FENCED, RMStateStoreEventType.STORE_MASTERKEY, RMStateStoreEventType.REMOVE_MASTERKEY, RMStateStoreEventType.STORE_DELEGATION_TOKEN, RMStateStoreEventType.REMOVE_DELEGATION_TOKEN, RMStateStoreEventType.UPDATE_DELEGATION_TOKEN, RMStateStoreEventType.UPDATE_AMRM_TOKEN}));
    private final StateMachine<RMStateStoreState, RMStateStoreEventType, RMStateStoreEvent> stateMachine;
    private Dispatcher rmDispatcher;
    AsyncDispatcher dispatcher;
    public static final Text AM_RM_TOKEN_SERVICE = new Text("AM_RM_TOKEN_SERVICE");
    public static final Text AM_CLIENT_TOKEN_MASTER_KEY_NAME = new Text("YARN_CLIENT_TOKEN_MASTER_KEY");

    public RMStateStore() {
        super(RMStateStore.class.getName());
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.stateMachine = stateMachineFactory.make((Object)this);
    }

    public void setRMDispatcher(Dispatcher dispatcher) {
        this.rmDispatcher = dispatcher;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.dispatcher = new AsyncDispatcher();
        this.dispatcher.init(conf);
        this.dispatcher.register(RMStateStoreEventType.class, (EventHandler)new ForwardingEventHandler());
        this.dispatcher.setDrainEventsOnStop();
        this.initInternal(conf);
    }

    protected void serviceStart() throws Exception {
        this.dispatcher.start();
        this.startInternal();
    }

    protected abstract void initInternal(Configuration var1) throws Exception;

    protected abstract void startInternal() throws Exception;

    protected void serviceStop() throws Exception {
        this.dispatcher.stop();
        this.closeInternal();
    }

    protected abstract void closeInternal() throws Exception;

    public void checkVersion() throws Exception {
        Version loadedVersion = this.loadVersion();
        LOG.info("Loaded RM state version info " + loadedVersion);
        if (loadedVersion != null && loadedVersion.equals((Object)this.getCurrentVersion())) {
            return;
        }
        if (loadedVersion == null) {
            loadedVersion = this.getCurrentVersion();
        }
        if (!loadedVersion.isCompatibleTo(this.getCurrentVersion())) {
            throw new RMStateVersionIncompatibleException("Expecting RM state version " + this.getCurrentVersion() + ", but loading version " + loadedVersion);
        }
        LOG.info("Storing RM state version info " + this.getCurrentVersion());
        this.storeVersion();
    }

    protected abstract Version loadVersion() throws Exception;

    protected abstract void storeVersion() throws Exception;

    protected abstract Version getCurrentVersion();

    public abstract long getAndIncrementEpoch() throws Exception;

    public abstract RMState loadState() throws Exception;

    public void storeNewApplication(RMApp app) {
        ApplicationSubmissionContext context = app.getApplicationSubmissionContext();
        assert (context instanceof ApplicationSubmissionContextPBImpl);
        ApplicationStateData appState = ApplicationStateData.newInstance(app.getSubmitTime(), app.getStartTime(), context, app.getUser());
        this.dispatcher.getEventHandler().handle((Event)new RMStateStoreAppEvent(appState));
    }

    public void updateApplicationState(ApplicationStateData appState) {
        this.dispatcher.getEventHandler().handle((Event)new RMStateUpdateAppEvent(appState));
    }

    public void updateFencedState() {
        this.handleStoreEvent(new RMStateStoreEvent(RMStateStoreEventType.FENCED));
    }

    protected abstract void storeApplicationStateInternal(ApplicationId var1, ApplicationStateData var2) throws Exception;

    protected abstract void updateApplicationStateInternal(ApplicationId var1, ApplicationStateData var2) throws Exception;

    public void storeNewApplicationAttempt(RMAppAttempt appAttempt) {
        Credentials credentials = this.getCredentialsFromAppAttempt(appAttempt);
        AggregateAppResourceUsage resUsage = appAttempt.getRMAppAttemptMetrics().getAggregateAppResourceUsage();
        ApplicationAttemptStateData attemptState = ApplicationAttemptStateData.newInstance(appAttempt.getAppAttemptId(), appAttempt.getMasterContainer(), credentials, appAttempt.getStartTime(), resUsage.getMemorySeconds(), resUsage.getVcoreSeconds());
        this.dispatcher.getEventHandler().handle((Event)new RMStateStoreAppAttemptEvent(attemptState));
    }

    public void updateApplicationAttemptState(ApplicationAttemptStateData attemptState) {
        this.dispatcher.getEventHandler().handle((Event)new RMStateUpdateAppAttemptEvent(attemptState));
    }

    protected abstract void storeApplicationAttemptStateInternal(ApplicationAttemptId var1, ApplicationAttemptStateData var2) throws Exception;

    protected abstract void updateApplicationAttemptStateInternal(ApplicationAttemptId var1, ApplicationAttemptStateData var2) throws Exception;

    public void storeRMDelegationToken(RMDelegationTokenIdentifier rmDTIdentifier, Long renewDate) {
        this.handleStoreEvent(new RMStateStoreRMDTEvent(rmDTIdentifier, renewDate, RMStateStoreEventType.STORE_DELEGATION_TOKEN));
    }

    protected abstract void storeRMDelegationTokenState(RMDelegationTokenIdentifier var1, Long var2) throws Exception;

    public void removeRMDelegationToken(RMDelegationTokenIdentifier rmDTIdentifier) {
        this.handleStoreEvent(new RMStateStoreRMDTEvent(rmDTIdentifier, null, RMStateStoreEventType.REMOVE_DELEGATION_TOKEN));
    }

    protected abstract void removeRMDelegationTokenState(RMDelegationTokenIdentifier var1) throws Exception;

    public void updateRMDelegationToken(RMDelegationTokenIdentifier rmDTIdentifier, Long renewDate) {
        this.handleStoreEvent(new RMStateStoreRMDTEvent(rmDTIdentifier, renewDate, RMStateStoreEventType.UPDATE_DELEGATION_TOKEN));
    }

    protected abstract void updateRMDelegationTokenState(RMDelegationTokenIdentifier var1, Long var2) throws Exception;

    public void storeRMDTMasterKey(DelegationKey delegationKey) {
        this.handleStoreEvent(new RMStateStoreRMDTMasterKeyEvent(delegationKey, RMStateStoreEventType.STORE_MASTERKEY));
    }

    protected abstract void storeRMDTMasterKeyState(DelegationKey var1) throws Exception;

    public void removeRMDTMasterKey(DelegationKey delegationKey) {
        this.handleStoreEvent(new RMStateStoreRMDTMasterKeyEvent(delegationKey, RMStateStoreEventType.REMOVE_MASTERKEY));
    }

    protected abstract void removeRMDTMasterKeyState(DelegationKey var1) throws Exception;

    protected abstract void storeOrUpdateAMRMTokenSecretManagerState(AMRMTokenSecretManagerState var1, boolean var2) throws Exception;

    public void storeOrUpdateAMRMTokenSecretManager(AMRMTokenSecretManagerState amrmTokenSecretManagerState, boolean isUpdate) {
        this.handleStoreEvent(new RMStateStoreAMRMTokenEvent(amrmTokenSecretManagerState, isUpdate, RMStateStoreEventType.UPDATE_AMRM_TOKEN));
    }

    public void removeApplication(RMApp app) {
        ApplicationStateData appState = ApplicationStateData.newInstance(app.getSubmitTime(), app.getStartTime(), app.getApplicationSubmissionContext(), app.getUser());
        for (RMAppAttempt appAttempt : app.getAppAttempts().values()) {
            appState.attempts.put(appAttempt.getAppAttemptId(), null);
        }
        this.dispatcher.getEventHandler().handle((Event)new RMStateStoreRemoveAppEvent(appState));
    }

    protected abstract void removeApplicationStateInternal(ApplicationStateData var1) throws Exception;

    public synchronized void removeApplicationAttempt(ApplicationAttemptId applicationAttemptId) {
        this.dispatcher.getEventHandler().handle((Event)new RMStateStoreRemoveAppAttemptEvent(applicationAttemptId));
    }

    protected abstract void removeApplicationAttemptInternal(ApplicationAttemptId var1) throws Exception;

    public Credentials getCredentialsFromAppAttempt(RMAppAttempt appAttempt) {
        Credentials credentials = new Credentials();
        SecretKey clientTokenMasterKey = appAttempt.getClientTokenMasterKey();
        if (clientTokenMasterKey != null) {
            credentials.addSecretKey(AM_CLIENT_TOKEN_MASTER_KEY_NAME, clientTokenMasterKey.getEncoded());
        }
        return credentials;
    }

    @VisibleForTesting
    protected boolean isFencedState() {
        return RMStateStoreState.FENCED == this.getRMStateStoreState();
    }

    protected void handleStoreEvent(RMStateStoreEvent event) {
        this.writeLock.lock();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing event of type " + event.getType());
            }
            RMStateStoreState oldState = this.getRMStateStoreState();
            this.stateMachine.doTransition((Enum)((RMStateStoreEventType)event.getType()), (Object)event);
            if (oldState != this.getRMStateStoreState()) {
                LOG.info("RMStateStore state change from " + oldState + " to " + this.getRMStateStoreState());
            }
        }
        catch (InvalidStateTransitonException e) {
            LOG.error("Can't handle this event at current state", (Throwable)e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void notifyStoreOperationFailed(Exception failureCause) {
        LOG.error("State store operation failed ", (Throwable)failureCause);
        if (HAUtil.isHAEnabled((Configuration)this.getConfig())) {
            LOG.warn("State-store fenced ! Transitioning RM to standby");
            this.updateFencedState();
            Thread standByTransitionThread = new Thread(new StandByTransitionThread());
            standByTransitionThread.setName("StandByTransitionThread Handler");
            standByTransitionThread.start();
        } else if (YarnConfiguration.shouldRMFailFast((Configuration)this.getConfig())) {
            LOG.error(FATAL, "Fail RM now due to state-store error!");
            this.rmDispatcher.getEventHandler().handle((Event)new RMFatalEvent(RMFatalEventType.STATE_STORE_OP_FAILED, failureCause));
        } else {
            LOG.warn("Skip the state-store error.");
        }
    }

    private void notifyApplication(RMAppEvent event) {
        this.rmDispatcher.getEventHandler().handle((Event)event);
    }

    private void notifyApplicationAttempt(RMAppAttemptEvent event) {
        this.rmDispatcher.getEventHandler().handle((Event)event);
    }

    public abstract void deleteStore() throws Exception;

    public void setResourceManager(ResourceManager rm) {
        this.resourceManager = rm;
    }

    public RMStateStoreState getRMStateStoreState() {
        this.readLock.lock();
        try {
            RMStateStoreState rMStateStoreState = (RMStateStoreState)this.stateMachine.getCurrentState();
            return rMStateStoreState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private class StandByTransitionThread
    implements Runnable {
        private StandByTransitionThread() {
        }

        @Override
        public void run() {
            LOG.info("RMStateStore has been fenced");
            RMStateStore.this.resourceManager.handleTransitionToStandBy();
        }
    }

    private final class ForwardingEventHandler
    implements EventHandler<RMStateStoreEvent> {
        private ForwardingEventHandler() {
        }

        public void handle(RMStateStoreEvent event) {
            RMStateStore.this.handleStoreEvent(event);
        }
    }

    public static class RMState {
        Map<ApplicationId, ApplicationStateData> appState = new TreeMap<ApplicationId, ApplicationStateData>();
        RMDTSecretManagerState rmSecretManagerState = new RMDTSecretManagerState();
        AMRMTokenSecretManagerState amrmTokenSecretManagerState = null;

        public Map<ApplicationId, ApplicationStateData> getApplicationState() {
            return this.appState;
        }

        public RMDTSecretManagerState getRMDTSecretManagerState() {
            return this.rmSecretManagerState;
        }

        public AMRMTokenSecretManagerState getAMRMTokenSecretManagerState() {
            return this.amrmTokenSecretManagerState;
        }
    }

    public static class RMDTSecretManagerState {
        Map<RMDelegationTokenIdentifier, Long> delegationTokenState = new HashMap<RMDelegationTokenIdentifier, Long>();
        Set<DelegationKey> masterKeyState = new HashSet<DelegationKey>();
        int dtSequenceNumber = 0;

        public Map<RMDelegationTokenIdentifier, Long> getTokenState() {
            return this.delegationTokenState;
        }

        public Set<DelegationKey> getMasterKeyState() {
            return this.masterKeyState;
        }

        public int getDTSequenceNumber() {
            return this.dtSequenceNumber;
        }
    }

    private static class RemoveAppAttemptTransition
    implements SingleArcTransition<RMStateStore, RMStateStoreEvent> {
        private RemoveAppAttemptTransition() {
        }

        public void transition(RMStateStore store, RMStateStoreEvent event) {
            if (!(event instanceof RMStateStoreRemoveAppAttemptEvent)) {
                LOG.error("Illegal event type: " + ((Object)((Object)event)).getClass());
                return;
            }
            ApplicationAttemptId attemptId = ((RMStateStoreRemoveAppAttemptEvent)event).getApplicationAttemptId();
            ApplicationId appId = attemptId.getApplicationId();
            LOG.info("Removing attempt " + attemptId + " from app: " + appId);
            try {
                store.removeApplicationAttemptInternal(attemptId);
            }
            catch (Exception e) {
                LOG.error("Error removing attempt: " + attemptId, (Throwable)e);
                store.notifyStoreOperationFailed(e);
            }
        }
    }

    private static class StoreOrUpdateAMRMTokenTransition
    implements SingleArcTransition<RMStateStore, RMStateStoreEvent> {
        private StoreOrUpdateAMRMTokenTransition() {
        }

        public void transition(RMStateStore store, RMStateStoreEvent event) {
            if (!(event instanceof RMStateStoreAMRMTokenEvent)) {
                LOG.error("Illegal event type: " + ((Object)((Object)event)).getClass());
                return;
            }
            RMStateStoreAMRMTokenEvent amrmEvent = (RMStateStoreAMRMTokenEvent)event;
            try {
                LOG.info("Updating AMRMToken");
                store.storeOrUpdateAMRMTokenSecretManagerState(amrmEvent.getAmrmTokenSecretManagerState(), amrmEvent.isUpdate());
            }
            catch (Exception e) {
                LOG.error("Error storing info for AMRMTokenSecretManager", (Throwable)e);
                store.notifyStoreOperationFailed(e);
            }
        }
    }

    private static class RemoveRMDTMasterKeyTransition
    implements SingleArcTransition<RMStateStore, RMStateStoreEvent> {
        private RemoveRMDTMasterKeyTransition() {
        }

        public void transition(RMStateStore store, RMStateStoreEvent event) {
            if (!(event instanceof RMStateStoreRMDTMasterKeyEvent)) {
                LOG.error("Illegal event type: " + ((Object)((Object)event)).getClass());
                return;
            }
            RMStateStoreRMDTMasterKeyEvent dtEvent = (RMStateStoreRMDTMasterKeyEvent)event;
            try {
                LOG.info("Removing RMDTMasterKey.");
                store.removeRMDTMasterKeyState(dtEvent.getDelegationKey());
            }
            catch (Exception e) {
                LOG.error("Error While Removing RMDTMasterKey.", (Throwable)e);
                store.notifyStoreOperationFailed(e);
            }
        }
    }

    private static class StoreRMDTMasterKeyTransition
    implements SingleArcTransition<RMStateStore, RMStateStoreEvent> {
        private StoreRMDTMasterKeyTransition() {
        }

        public void transition(RMStateStore store, RMStateStoreEvent event) {
            if (!(event instanceof RMStateStoreRMDTMasterKeyEvent)) {
                LOG.error("Illegal event type: " + ((Object)((Object)event)).getClass());
                return;
            }
            RMStateStoreRMDTMasterKeyEvent dtEvent = (RMStateStoreRMDTMasterKeyEvent)event;
            try {
                LOG.info("Storing RMDTMasterKey.");
                store.storeRMDTMasterKeyState(dtEvent.getDelegationKey());
            }
            catch (Exception e) {
                LOG.error("Error While Storing RMDTMasterKey.", (Throwable)e);
                store.notifyStoreOperationFailed(e);
            }
        }
    }

    private static class UpdateRMDTTransition
    implements SingleArcTransition<RMStateStore, RMStateStoreEvent> {
        private UpdateRMDTTransition() {
        }

        public void transition(RMStateStore store, RMStateStoreEvent event) {
            if (!(event instanceof RMStateStoreRMDTEvent)) {
                LOG.error("Illegal event type: " + ((Object)((Object)event)).getClass());
                return;
            }
            RMStateStoreRMDTEvent dtEvent = (RMStateStoreRMDTEvent)event;
            try {
                LOG.info("Updating RMDelegationToken and SequenceNumber");
                store.updateRMDelegationTokenState(dtEvent.getRmDTIdentifier(), dtEvent.getRenewDate());
            }
            catch (Exception e) {
                LOG.error("Error While Updating RMDelegationToken and SequenceNumber ", (Throwable)e);
                store.notifyStoreOperationFailed(e);
            }
        }
    }

    private static class RemoveRMDTTransition
    implements SingleArcTransition<RMStateStore, RMStateStoreEvent> {
        private RemoveRMDTTransition() {
        }

        public void transition(RMStateStore store, RMStateStoreEvent event) {
            if (!(event instanceof RMStateStoreRMDTEvent)) {
                LOG.error("Illegal event type: " + ((Object)((Object)event)).getClass());
                return;
            }
            RMStateStoreRMDTEvent dtEvent = (RMStateStoreRMDTEvent)event;
            try {
                LOG.info("Removing RMDelegationToken and SequenceNumber");
                store.removeRMDelegationTokenState(dtEvent.getRmDTIdentifier());
            }
            catch (Exception e) {
                LOG.error("Error While Removing RMDelegationToken and SequenceNumber ", (Throwable)e);
                store.notifyStoreOperationFailed(e);
            }
        }
    }

    private static class StoreRMDTTransition
    implements SingleArcTransition<RMStateStore, RMStateStoreEvent> {
        private StoreRMDTTransition() {
        }

        public void transition(RMStateStore store, RMStateStoreEvent event) {
            if (!(event instanceof RMStateStoreRMDTEvent)) {
                LOG.error("Illegal event type: " + ((Object)((Object)event)).getClass());
                return;
            }
            RMStateStoreRMDTEvent dtEvent = (RMStateStoreRMDTEvent)event;
            try {
                LOG.info("Storing RMDelegationToken and SequenceNumber");
                store.storeRMDelegationTokenState(dtEvent.getRmDTIdentifier(), dtEvent.getRenewDate());
            }
            catch (Exception e) {
                LOG.error("Error While Storing RMDelegationToken and SequenceNumber ", (Throwable)e);
                store.notifyStoreOperationFailed(e);
            }
        }
    }

    private static class UpdateAppAttemptTransition
    implements SingleArcTransition<RMStateStore, RMStateStoreEvent> {
        private UpdateAppAttemptTransition() {
        }

        public void transition(RMStateStore store, RMStateStoreEvent event) {
            if (!(event instanceof RMStateUpdateAppAttemptEvent)) {
                LOG.error("Illegal event type: " + ((Object)((Object)event)).getClass());
                return;
            }
            ApplicationAttemptStateData attemptState = ((RMStateUpdateAppAttemptEvent)event).getAppAttemptState();
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Updating info for attempt: " + attemptState.getAttemptId());
                }
                store.updateApplicationAttemptStateInternal(attemptState.getAttemptId(), attemptState);
                store.notifyApplicationAttempt(new RMAppAttemptEvent(attemptState.getAttemptId(), RMAppAttemptEventType.ATTEMPT_UPDATE_SAVED));
            }
            catch (Exception e) {
                LOG.error("Error updating appAttempt: " + attemptState.getAttemptId(), (Throwable)e);
                store.notifyStoreOperationFailed(e);
            }
        }
    }

    private static class StoreAppAttemptTransition
    implements SingleArcTransition<RMStateStore, RMStateStoreEvent> {
        private StoreAppAttemptTransition() {
        }

        public void transition(RMStateStore store, RMStateStoreEvent event) {
            if (!(event instanceof RMStateStoreAppAttemptEvent)) {
                LOG.error("Illegal event type: " + ((Object)((Object)event)).getClass());
                return;
            }
            ApplicationAttemptStateData attemptState = ((RMStateStoreAppAttemptEvent)event).getAppAttemptState();
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Storing info for attempt: " + attemptState.getAttemptId());
                }
                store.storeApplicationAttemptStateInternal(attemptState.getAttemptId(), attemptState);
                store.notifyApplicationAttempt(new RMAppAttemptEvent(attemptState.getAttemptId(), RMAppAttemptEventType.ATTEMPT_NEW_SAVED));
            }
            catch (Exception e) {
                LOG.error("Error storing appAttempt: " + attemptState.getAttemptId(), (Throwable)e);
                store.notifyStoreOperationFailed(e);
            }
        }
    }

    private static class RemoveAppTransition
    implements SingleArcTransition<RMStateStore, RMStateStoreEvent> {
        private RemoveAppTransition() {
        }

        public void transition(RMStateStore store, RMStateStoreEvent event) {
            if (!(event instanceof RMStateStoreRemoveAppEvent)) {
                LOG.error("Illegal event type: " + ((Object)((Object)event)).getClass());
                return;
            }
            ApplicationStateData appState = ((RMStateStoreRemoveAppEvent)event).getAppState();
            ApplicationId appId = appState.getApplicationSubmissionContext().getApplicationId();
            LOG.info("Removing info for app: " + appId);
            try {
                store.removeApplicationStateInternal(appState);
            }
            catch (Exception e) {
                LOG.error("Error removing app: " + appId, (Throwable)e);
                store.notifyStoreOperationFailed(e);
            }
        }
    }

    private static class UpdateAppTransition
    implements SingleArcTransition<RMStateStore, RMStateStoreEvent> {
        private UpdateAppTransition() {
        }

        public void transition(RMStateStore store, RMStateStoreEvent event) {
            if (!(event instanceof RMStateUpdateAppEvent)) {
                LOG.error("Illegal event type: " + ((Object)((Object)event)).getClass());
                return;
            }
            ApplicationStateData appState = ((RMStateUpdateAppEvent)event).getAppState();
            ApplicationId appId = appState.getApplicationSubmissionContext().getApplicationId();
            LOG.info("Updating info for app: " + appId);
            try {
                store.updateApplicationStateInternal(appId, appState);
                store.notifyApplication(new RMAppEvent(appId, RMAppEventType.APP_UPDATE_SAVED));
            }
            catch (Exception e) {
                LOG.error("Error updating app: " + appId, (Throwable)e);
                store.notifyStoreOperationFailed(e);
            }
        }
    }

    private static class StoreAppTransition
    implements SingleArcTransition<RMStateStore, RMStateStoreEvent> {
        private StoreAppTransition() {
        }

        public void transition(RMStateStore store, RMStateStoreEvent event) {
            if (!(event instanceof RMStateStoreAppEvent)) {
                LOG.error("Illegal event type: " + ((Object)((Object)event)).getClass());
                return;
            }
            ApplicationStateData appState = ((RMStateStoreAppEvent)event).getAppState();
            ApplicationId appId = appState.getApplicationSubmissionContext().getApplicationId();
            LOG.info("Storing info for app: " + appId);
            try {
                store.storeApplicationStateInternal(appId, appState);
                store.notifyApplication(new RMAppEvent(appId, RMAppEventType.APP_NEW_SAVED));
            }
            catch (Exception e) {
                LOG.error("Error storing app: " + appId, (Throwable)e);
                store.notifyStoreOperationFailed(e);
            }
        }
    }

    private static enum RMStateStoreState {
        ACTIVE,
        FENCED;

    }
}

