/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.exceptions.InvalidApplicationStateException;
import org.apache.hadoop.yarn.proto.YarnServerCommonProtos;
import org.apache.hadoop.yarn.proto.YarnServerResourceManagerRecoveryProtos;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.security.client.YARNDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.records.impl.pb.VersionPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.AMRMTokenSecretManagerState;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationAttemptStateData;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationStateData;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.Epoch;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.RMDelegationTokenIdentifierData;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.AMRMTokenSecretManagerStatePBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.ApplicationAttemptStateDataPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.ApplicationStateDataPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.EpochPBImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FileSystemRMStateStore
extends RMStateStore {
    public static final Logger LOG = LoggerFactory.getLogger(FileSystemRMStateStore.class);
    protected static final String ROOT_DIR_NAME = "FSRMStateRoot";
    protected static final Version CURRENT_VERSION_INFO = Version.newInstance((int)1, (int)2);
    protected static final String AMRMTOKEN_SECRET_MANAGER_NODE = "AMRMTokenSecretManagerNode";
    protected FileSystem fs;
    private Path rootDirPath;
    @InterfaceAudience.Private
    @VisibleForTesting
    Path rmDTSecretManagerRoot;
    private Path rmAppRoot;
    private Path dtSequenceNumberPath = null;
    private int fsNumRetries;
    private long fsRetryInterval;
    @VisibleForTesting
    Path fsWorkingPath;
    Path amrmTokenSecretManagerRoot;

    @Override
    public synchronized void initInternal(Configuration conf) throws Exception {
        this.fsWorkingPath = new Path(conf.get("yarn.resourcemanager.fs.state-store.uri"));
        this.rootDirPath = new Path(this.fsWorkingPath, ROOT_DIR_NAME);
        this.rmDTSecretManagerRoot = new Path(this.rootDirPath, "RMDTSecretManagerRoot");
        this.rmAppRoot = new Path(this.rootDirPath, "RMAppRoot");
        this.amrmTokenSecretManagerRoot = new Path(this.rootDirPath, "AMRMTokenSecretManagerRoot");
        this.fsNumRetries = conf.getInt("yarn.resourcemanager.fs.state-store.num-retries", 0);
        this.fsRetryInterval = conf.getLong("yarn.resourcemanager.fs.state-store.retry-interval-ms", 1000L);
    }

    @Override
    protected synchronized void startInternal() throws Exception {
        Configuration conf = new Configuration(this.getConfig());
        conf.setBoolean("dfs.client.retry.policy.enabled", true);
        String retryPolicy = conf.get("yarn.resourcemanager.fs.state-store.retry-policy-spec", "2000, 500");
        conf.set("dfs.client.retry.policy.spec", retryPolicy);
        this.fs = this.fsWorkingPath.getFileSystem(conf);
        this.mkdirsWithRetries(this.rmDTSecretManagerRoot);
        this.mkdirsWithRetries(this.rmAppRoot);
        this.mkdirsWithRetries(this.amrmTokenSecretManagerRoot);
    }

    @Override
    protected synchronized void closeInternal() throws Exception {
        this.closeWithRetries();
    }

    @Override
    protected Version getCurrentVersion() {
        return CURRENT_VERSION_INFO;
    }

    @Override
    protected synchronized Version loadVersion() throws Exception {
        Path versionNodePath = this.getNodePath(this.rootDirPath, "RMVersionNode");
        FileStatus status = this.getFileStatusWithRetries(versionNodePath);
        if (status != null) {
            byte[] data = this.readFileWithRetries(versionNodePath, status.getLen());
            VersionPBImpl version = new VersionPBImpl(YarnServerCommonProtos.VersionProto.parseFrom((byte[])data));
            return version;
        }
        return null;
    }

    @Override
    protected synchronized void storeVersion() throws Exception {
        Path versionNodePath = this.getNodePath(this.rootDirPath, "RMVersionNode");
        byte[] data = ((VersionPBImpl)CURRENT_VERSION_INFO).getProto().toByteArray();
        if (this.existsWithRetries(versionNodePath)) {
            this.updateFile(versionNodePath, data);
        } else {
            this.writeFileWithRetries(versionNodePath, data);
        }
    }

    @Override
    public synchronized long getAndIncrementEpoch() throws Exception {
        Path epochNodePath = this.getNodePath(this.rootDirPath, "EpochNode");
        long currentEpoch = 0L;
        FileStatus status = this.getFileStatusWithRetries(epochNodePath);
        if (status != null) {
            byte[] data = this.readFileWithRetries(epochNodePath, status.getLen());
            EpochPBImpl epoch = new EpochPBImpl(YarnServerResourceManagerRecoveryProtos.EpochProto.parseFrom(data));
            currentEpoch = ((Epoch)epoch).getEpoch();
            byte[] storeData = Epoch.newInstance(currentEpoch + 1L).getProto().toByteArray();
            this.updateFile(epochNodePath, storeData);
        } else {
            byte[] storeData = Epoch.newInstance(currentEpoch + 1L).getProto().toByteArray();
            this.writeFileWithRetries(epochNodePath, storeData);
        }
        return currentEpoch;
    }

    @Override
    public synchronized RMStateStore.RMState loadState() throws Exception {
        RMStateStore.RMState rmState = new RMStateStore.RMState();
        this.loadRMDTSecretManagerState(rmState);
        this.loadRMAppState(rmState);
        this.loadAMRMTokenSecretManagerState(rmState);
        return rmState;
    }

    private void loadAMRMTokenSecretManagerState(RMStateStore.RMState rmState) throws Exception {
        this.checkAndResumeUpdateOperation(this.amrmTokenSecretManagerRoot);
        Path amrmTokenSecretManagerStateDataDir = new Path(this.amrmTokenSecretManagerRoot, AMRMTOKEN_SECRET_MANAGER_NODE);
        FileStatus status = this.getFileStatusWithRetries(amrmTokenSecretManagerStateDataDir);
        if (status == null) {
            return;
        }
        assert (status.isFile());
        byte[] data = this.readFileWithRetries(amrmTokenSecretManagerStateDataDir, status.getLen());
        AMRMTokenSecretManagerStatePBImpl stateData = new AMRMTokenSecretManagerStatePBImpl(YarnServerResourceManagerRecoveryProtos.AMRMTokenSecretManagerStateProto.parseFrom(data));
        rmState.amrmTokenSecretManagerState = AMRMTokenSecretManagerState.newInstance(stateData.getCurrentMasterKey(), stateData.getNextMasterKey());
    }

    private void loadRMAppState(RMStateStore.RMState rmState) throws Exception {
        try {
            ArrayList<ApplicationAttemptStateDataPBImpl> attempts = new ArrayList<ApplicationAttemptStateDataPBImpl>();
            block4: for (FileStatus appDir : this.listStatusWithRetries(this.rmAppRoot)) {
                this.checkAndResumeUpdateOperation(appDir.getPath());
                for (FileStatus childNodeStatus : this.listStatusWithRetries(appDir.getPath())) {
                    assert (childNodeStatus.isFile());
                    String childNodeName = childNodeStatus.getPath().getName();
                    if (this.checkAndRemovePartialRecordWithRetries(childNodeStatus.getPath())) continue;
                    byte[] childData = this.readFileWithRetries(childNodeStatus.getPath(), childNodeStatus.getLen());
                    try {
                        if (childNodeName.startsWith("application_")) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Loading application from node: " + childNodeName);
                            }
                            ApplicationStateDataPBImpl appState = new ApplicationStateDataPBImpl(YarnServerResourceManagerRecoveryProtos.ApplicationStateDataProto.parseFrom(childData));
                            ApplicationId appId = appState.getApplicationSubmissionContext().getApplicationId();
                            rmState.appState.put(appId, appState);
                            continue;
                        }
                        if (childNodeName.startsWith("appattempt_")) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Loading application attempt from node: " + childNodeName);
                            }
                            ApplicationAttemptStateDataPBImpl attemptState = new ApplicationAttemptStateDataPBImpl(YarnServerResourceManagerRecoveryProtos.ApplicationAttemptStateDataProto.parseFrom(childData));
                            attempts.add(attemptState);
                            continue;
                        }
                        LOG.info("Unknown child node with name: " + childNodeName);
                    }
                    catch (InvalidProtocolBufferException ex) {
                        boolean brokenDataShouldBeRemoved = this.getConfig().getBoolean("yarn.resourcemanager.fs.state-store.remove-corrupted-data", false);
                        if (brokenDataShouldBeRemoved) {
                            LOG.warn("Removing broken " + appDir.getPath() + " app directory as its data is corrupted and can cause RM restart failure after failover.", (Throwable)ex);
                            this.checkAndRemovePathWithRetries(appDir.getPath());
                            continue block4;
                        }
                        String errorMessage = "Application's state file " + childNodeStatus.getPath() + " contains corrupted data which leads to RM crash. Remove the directory with corrupted data to start RM successfully without recovering broken application.";
                        throw new InvalidApplicationStateException(errorMessage, (Throwable)ex);
                    }
                }
            }
            for (ApplicationAttemptStateData applicationAttemptStateData : attempts) {
                ApplicationId appId = applicationAttemptStateData.getAttemptId().getApplicationId();
                ApplicationStateData appState = rmState.appState.get(appId);
                assert (appState != null);
                if (appState == null) {
                    LOG.warn("Removing " + appId + " directory as info there is incomplete and can cause RM restart failure after failover.");
                    this.checkAndRemovePathWithRetries(this.getAppDir(this.rmAppRoot, appId));
                    rmState.appState.remove(appId);
                    continue;
                }
                appState.attempts.put(applicationAttemptStateData.getAttemptId(), applicationAttemptStateData);
            }
            LOG.info("Done loading applications from FS state store");
        }
        catch (Exception e) {
            LOG.error("Failed to load state.", (Throwable)e);
            throw e;
        }
    }

    private boolean checkAndRemovePartialRecord(Path record) throws IOException {
        if (record.getName().endsWith(".tmp")) {
            LOG.error("incomplete rm state store entry found :" + record);
            this.fs.delete(record, false);
            return true;
        }
        return false;
    }

    private void checkAndResumeUpdateOperation(Path path) throws Exception {
        FileStatus[] newChildNodes;
        for (FileStatus newChildNodeStatus : newChildNodes = this.listStatusWithRetries(path, new PathFilter(){

            public boolean accept(Path path) {
                return path.getName().endsWith(".new");
            }
        })) {
            assert (newChildNodeStatus.isFile());
            String newChildNodeName = newChildNodeStatus.getPath().getName();
            String childNodeName = newChildNodeName.substring(0, newChildNodeName.length() - ".new".length());
            Path childNodePath = new Path(newChildNodeStatus.getPath().getParent(), childNodeName);
            this.replaceFile(newChildNodeStatus.getPath(), childNodePath);
        }
    }

    private void loadRMDTSecretManagerState(RMStateStore.RMState rmState) throws Exception {
        FileStatus[] childNodes;
        this.checkAndResumeUpdateOperation(this.rmDTSecretManagerRoot);
        for (FileStatus childNodeStatus : childNodes = this.listStatusWithRetries(this.rmDTSecretManagerRoot)) {
            assert (childNodeStatus.isFile());
            String childNodeName = childNodeStatus.getPath().getName();
            if (this.checkAndRemovePartialRecordWithRetries(childNodeStatus.getPath())) continue;
            if (childNodeName.startsWith("RMDTSequenceNumber_")) {
                rmState.rmSecretManagerState.dtSequenceNumber = Integer.parseInt(childNodeName.split("_")[1]);
                continue;
            }
            Path childNodePath = this.getNodePath(this.rmDTSecretManagerRoot, childNodeName);
            byte[] childData = this.readFileWithRetries(childNodePath, childNodeStatus.getLen());
            ByteArrayInputStream is = new ByteArrayInputStream(childData);
            try (DataInputStream fsIn = new DataInputStream(is);){
                if (childNodeName.startsWith("DelegationKey_")) {
                    if (fsIn.available() == 0) {
                        LOG.warn("Can't read delegation key from empty file " + childNodeName);
                        continue;
                    }
                    DelegationKey key = new DelegationKey();
                    key.readFields((DataInput)fsIn);
                    rmState.rmSecretManagerState.masterKeyState.add(key);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Loaded delegation key: keyId=" + key.getKeyId() + ", expirationDate=" + key.getExpiryDate());
                    continue;
                }
                if (childNodeName.startsWith("RMDelegationToken_")) {
                    long renewDate;
                    RMDelegationTokenIdentifier identifier = null;
                    try {
                        RMDelegationTokenIdentifierData identifierData = new RMDelegationTokenIdentifierData();
                        identifierData.readFields(fsIn);
                        identifier = identifierData.getTokenIdentifier();
                        renewDate = identifierData.getRenewDate();
                    }
                    catch (InvalidProtocolBufferException e) {
                        LOG.warn("Recovering old formatted data");
                        identifier = new RMDelegationTokenIdentifier();
                        fsIn.reset();
                        identifier.readOldFormatFields((DataInput)fsIn);
                        renewDate = fsIn.readLong();
                    }
                    rmState.rmSecretManagerState.delegationTokenState.put(identifier, renewDate);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Loaded RMDelegationTokenIdentifier: " + identifier + " renewDate=" + renewDate);
                    continue;
                }
                LOG.warn("Unknown file for recovering RMDelegationTokenSecretManager");
            }
        }
    }

    @Override
    public synchronized void storeApplicationStateInternal(ApplicationId appId, ApplicationStateData appStateDataPB) throws Exception {
        Path appDirPath = this.getAppDir(this.rmAppRoot, appId);
        this.mkdirsWithRetries(appDirPath);
        Path nodeCreatePath = this.getNodePath(appDirPath, appId.toString());
        LOG.info("Storing info for app: " + appId + " at: " + nodeCreatePath);
        byte[] appStateData = appStateDataPB.getProto().toByteArray();
        try {
            this.writeFileWithRetries(nodeCreatePath, appStateData);
        }
        catch (Exception e) {
            LOG.info("Error storing info for app: " + appId, (Throwable)e);
            throw e;
        }
    }

    @Override
    public synchronized void updateApplicationStateInternal(ApplicationId appId, ApplicationStateData appStateDataPB) throws Exception {
        Path appDirPath = this.getAppDir(this.rmAppRoot, appId);
        Path nodeCreatePath = this.getNodePath(appDirPath, appId.toString());
        LOG.info("Updating info for app: " + appId + " at: " + nodeCreatePath);
        byte[] appStateData = appStateDataPB.getProto().toByteArray();
        try {
            this.updateFile(nodeCreatePath, appStateData);
        }
        catch (Exception e) {
            LOG.info("Error updating info for app: " + appId, (Throwable)e);
            throw e;
        }
    }

    @Override
    public synchronized void storeApplicationAttemptStateInternal(ApplicationAttemptId appAttemptId, ApplicationAttemptStateData attemptStateDataPB) throws Exception {
        Path appDirPath = this.getAppDir(this.rmAppRoot, appAttemptId.getApplicationId());
        Path nodeCreatePath = this.getNodePath(appDirPath, appAttemptId.toString());
        LOG.info("Storing info for attempt: " + appAttemptId + " at: " + nodeCreatePath);
        byte[] attemptStateData = attemptStateDataPB.getProto().toByteArray();
        try {
            this.writeFileWithRetries(nodeCreatePath, attemptStateData);
        }
        catch (Exception e) {
            LOG.info("Error storing info for attempt: " + appAttemptId, (Throwable)e);
            throw e;
        }
    }

    @Override
    public synchronized void updateApplicationAttemptStateInternal(ApplicationAttemptId appAttemptId, ApplicationAttemptStateData attemptStateDataPB) throws Exception {
        Path appDirPath = this.getAppDir(this.rmAppRoot, appAttemptId.getApplicationId());
        Path nodeCreatePath = this.getNodePath(appDirPath, appAttemptId.toString());
        LOG.info("Updating info for attempt: " + appAttemptId + " at: " + nodeCreatePath);
        byte[] attemptStateData = attemptStateDataPB.getProto().toByteArray();
        try {
            this.updateFile(nodeCreatePath, attemptStateData);
        }
        catch (Exception e) {
            LOG.info("Error updating info for attempt: " + appAttemptId, (Throwable)e);
            throw e;
        }
    }

    @Override
    public synchronized void removeApplicationAttemptInternal(ApplicationAttemptId appAttemptId) throws Exception {
        Path appDirPath = this.getAppDir(this.rmAppRoot, appAttemptId.getApplicationId());
        Path nodeRemovePath = this.getNodePath(appDirPath, appAttemptId.toString());
        LOG.info("Removing info for attempt: " + appAttemptId + " at: " + nodeRemovePath);
        this.deleteFileWithRetries(nodeRemovePath);
    }

    @Override
    public synchronized void removeApplicationStateInternal(ApplicationStateData appState) throws Exception {
        ApplicationId appId = appState.getApplicationSubmissionContext().getApplicationId();
        Path nodeRemovePath = this.getAppDir(this.rmAppRoot, appId);
        LOG.info("Removing info for app: " + appId + " at: " + nodeRemovePath);
        this.checkAndRemovePathWithRetries(nodeRemovePath);
    }

    @Override
    public synchronized void storeRMDelegationTokenState(RMDelegationTokenIdentifier identifier, Long renewDate) throws Exception {
        this.storeOrUpdateRMDelegationTokenState(identifier, renewDate, false);
    }

    @Override
    public synchronized void removeRMDelegationTokenState(RMDelegationTokenIdentifier identifier) throws Exception {
        Path nodeCreatePath = this.getNodePath(this.rmDTSecretManagerRoot, "RMDelegationToken_" + identifier.getSequenceNumber());
        LOG.info("Removing RMDelegationToken_" + identifier.getSequenceNumber());
        this.checkAndRemovePathWithRetries(nodeCreatePath);
    }

    @Override
    protected synchronized void updateRMDelegationTokenState(RMDelegationTokenIdentifier rmDTIdentifier, Long renewDate) throws Exception {
        this.storeOrUpdateRMDelegationTokenState(rmDTIdentifier, renewDate, true);
    }

    private void storeOrUpdateRMDelegationTokenState(RMDelegationTokenIdentifier identifier, Long renewDate, boolean isUpdate) throws Exception {
        Path nodeCreatePath = this.getNodePath(this.rmDTSecretManagerRoot, "RMDelegationToken_" + identifier.getSequenceNumber());
        RMDelegationTokenIdentifierData identifierData = new RMDelegationTokenIdentifierData((YARNDelegationTokenIdentifier)identifier, renewDate);
        if (isUpdate) {
            LOG.info("Updating RMDelegationToken_" + identifier.getSequenceNumber());
            this.updateFile(nodeCreatePath, identifierData.toByteArray());
        } else {
            LOG.info("Storing RMDelegationToken_" + identifier.getSequenceNumber());
            this.writeFileWithRetries(nodeCreatePath, identifierData.toByteArray());
            Path latestSequenceNumberPath = this.getNodePath(this.rmDTSecretManagerRoot, "RMDTSequenceNumber_" + identifier.getSequenceNumber());
            LOG.info("Storing RMDTSequenceNumber_" + identifier.getSequenceNumber());
            if (this.dtSequenceNumberPath == null) {
                if (!this.createFileWithRetries(latestSequenceNumberPath)) {
                    throw new Exception("Failed to create " + latestSequenceNumberPath);
                }
            } else if (!this.renameFileWithRetries(this.dtSequenceNumberPath, latestSequenceNumberPath)) {
                throw new Exception("Failed to rename " + this.dtSequenceNumberPath);
            }
            this.dtSequenceNumberPath = latestSequenceNumberPath;
        }
    }

    @Override
    public synchronized void storeRMDTMasterKeyState(DelegationKey masterKey) throws Exception {
        Path nodeCreatePath = this.getNodePath(this.rmDTSecretManagerRoot, "DelegationKey_" + masterKey.getKeyId());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (DataOutputStream fsOut = new DataOutputStream(os);){
            LOG.info("Storing RMDelegationKey_" + masterKey.getKeyId());
            masterKey.write((DataOutput)fsOut);
            this.writeFileWithRetries(nodeCreatePath, os.toByteArray());
        }
    }

    @Override
    public synchronized void removeRMDTMasterKeyState(DelegationKey masterKey) throws Exception {
        Path nodeCreatePath = this.getNodePath(this.rmDTSecretManagerRoot, "DelegationKey_" + masterKey.getKeyId());
        LOG.info("Removing RMDelegationKey_" + masterKey.getKeyId());
        this.checkAndRemovePathWithRetries(nodeCreatePath);
    }

    @Override
    public synchronized void deleteStore() throws Exception {
        this.checkAndRemovePathWithRetries(this.rootDirPath);
    }

    private Path getAppDir(Path root, ApplicationId appId) {
        return this.getNodePath(root, appId.toString());
    }

    private void checkAndRemovePathWithRetries(Path deletePath) throws Exception {
        if (!this.existsWithRetries(deletePath) || !this.deleteFileWithRetries(deletePath)) {
            LOG.info("File doesn't exist. Skip deleting the file " + deletePath);
        }
    }

    private boolean checkAndRemovePartialRecordWithRetries(final Path record) throws Exception {
        return (Boolean)new FSAction<Boolean>(){

            @Override
            public Boolean run() throws Exception {
                return FileSystemRMStateStore.this.checkAndRemovePartialRecord(record);
            }
        }.runWithRetries();
    }

    private void mkdirsWithRetries(final Path appDirPath) throws Exception {
        new FSAction<Void>(){

            @Override
            public Void run() throws Exception {
                FileSystemRMStateStore.this.fs.mkdirs(appDirPath);
                return null;
            }
        }.runWithRetries();
    }

    private void writeFileWithRetries(final Path outputPath, final byte[] data) throws Exception {
        new FSAction<Void>(){

            @Override
            public Void run() throws Exception {
                FileSystemRMStateStore.this.writeFile(outputPath, data);
                return null;
            }
        }.runWithRetries();
    }

    private boolean deleteFileWithRetries(final Path deletePath) throws Exception {
        return (Boolean)new FSAction<Boolean>(){

            @Override
            public Boolean run() throws Exception {
                return FileSystemRMStateStore.this.deleteFile(deletePath);
            }
        }.runWithRetries();
    }

    private boolean renameFileWithRetries(final Path src, final Path dst) throws Exception {
        return (Boolean)new FSAction<Boolean>(){

            @Override
            public Boolean run() throws Exception {
                return FileSystemRMStateStore.this.renameFile(src, dst);
            }
        }.runWithRetries();
    }

    private boolean createFileWithRetries(final Path newFile) throws Exception {
        return (Boolean)new FSAction<Boolean>(){

            @Override
            public Boolean run() throws Exception {
                return FileSystemRMStateStore.this.createFile(newFile);
            }
        }.runWithRetries();
    }

    private FileStatus getFileStatusWithRetries(final Path path) throws Exception {
        return (FileStatus)new FSAction<FileStatus>(){

            @Override
            public FileStatus run() throws Exception {
                return FileSystemRMStateStore.this.getFileStatus(path);
            }
        }.runWithRetries();
    }

    private boolean existsWithRetries(final Path path) throws Exception {
        return (Boolean)new FSAction<Boolean>(){

            @Override
            public Boolean run() throws Exception {
                return FileSystemRMStateStore.this.fs.exists(path);
            }
        }.runWithRetries();
    }

    private byte[] readFileWithRetries(final Path inputPath, final long len) throws Exception {
        return (byte[])new FSAction<byte[]>(){

            @Override
            public byte[] run() throws Exception {
                return FileSystemRMStateStore.this.readFile(inputPath, len);
            }
        }.runWithRetries();
    }

    private FileStatus[] listStatusWithRetries(final Path path) throws Exception {
        return (FileStatus[])new FSAction<FileStatus[]>(){

            @Override
            public FileStatus[] run() throws Exception {
                return FileSystemRMStateStore.this.fs.listStatus(path);
            }
        }.runWithRetries();
    }

    private FileStatus[] listStatusWithRetries(final Path path, final PathFilter filter) throws Exception {
        return (FileStatus[])new FSAction<FileStatus[]>(){

            @Override
            public FileStatus[] run() throws Exception {
                return FileSystemRMStateStore.this.fs.listStatus(path, filter);
            }
        }.runWithRetries();
    }

    private void closeWithRetries() throws Exception {
        new FSAction<Void>(){

            @Override
            public Void run() throws Exception {
                FileSystemRMStateStore.this.fs.close();
                return null;
            }
        }.runWithRetries();
    }

    private Boolean deleteFile(Path deletePath) throws Exception {
        return this.fs.delete(deletePath, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFile(Path inputPath, long len) throws Exception {
        byte[] byArray;
        FSDataInputStream fsIn = null;
        try {
            fsIn = this.fs.open(inputPath);
            byte[] data = new byte[(int)len];
            fsIn.readFully(data);
            byArray = data;
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{fsIn});
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{fsIn});
        return byArray;
    }

    private FileStatus getFileStatus(Path path) throws Exception {
        try {
            return this.fs.getFileStatus(path);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(Path outputPath, byte[] data) throws Exception {
        Path tempPath = new Path(outputPath.getParent(), outputPath.getName() + ".tmp");
        FSDataOutputStream fsOut = null;
        try {
            fsOut = this.fs.create(tempPath, true);
            fsOut.write(data);
            fsOut.close();
            fsOut = null;
            this.fs.rename(tempPath, outputPath);
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{fsOut});
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{fsOut});
    }

    protected void updateFile(Path outputPath, byte[] data) throws Exception {
        Path newPath = new Path(outputPath.getParent(), outputPath.getName() + ".new");
        this.writeFileWithRetries(newPath, data);
        this.replaceFile(newPath, outputPath);
    }

    protected void replaceFile(Path srcPath, Path dstPath) throws Exception {
        if (this.existsWithRetries(dstPath)) {
            this.deleteFileWithRetries(dstPath);
        } else {
            LOG.info("File doesn't exist. Skip deleting the file " + dstPath);
        }
        this.renameFileWithRetries(srcPath, dstPath);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    boolean renameFile(Path src, Path dst) throws Exception {
        return this.fs.rename(src, dst);
    }

    private boolean createFile(Path newFile) throws Exception {
        return this.fs.createNewFile(newFile);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    Path getNodePath(Path root, String nodeName) {
        return new Path(root, nodeName);
    }

    @Override
    public synchronized void storeOrUpdateAMRMTokenSecretManagerState(AMRMTokenSecretManagerState amrmTokenSecretManagerState, boolean isUpdate) throws Exception {
        Path nodeCreatePath = this.getNodePath(this.amrmTokenSecretManagerRoot, AMRMTOKEN_SECRET_MANAGER_NODE);
        AMRMTokenSecretManagerState data = AMRMTokenSecretManagerState.newInstance(amrmTokenSecretManagerState);
        byte[] stateData = data.getProto().toByteArray();
        if (isUpdate) {
            this.updateFile(nodeCreatePath, stateData);
        } else {
            this.writeFileWithRetries(nodeCreatePath, stateData);
        }
    }

    @VisibleForTesting
    public int getNumRetries() {
        return this.fsNumRetries;
    }

    @VisibleForTesting
    public long getRetryInterval() {
        return this.fsRetryInterval;
    }

    private abstract class FSAction<T> {
        private FSAction() {
        }

        abstract T run() throws Exception;

        T runWithRetries() throws Exception {
            int retry = 0;
            while (true) {
                try {
                    return this.run();
                }
                catch (IOException e) {
                    LOG.info("Exception while executing a FS operation.", (Throwable)e);
                    if (++retry > FileSystemRMStateStore.this.fsNumRetries) {
                        LOG.info("Maxed out FS retries. Giving up!");
                        throw e;
                    }
                    LOG.info("Retrying operation on FS. Retry no. " + retry);
                    Thread.sleep(FileSystemRMStateStore.this.fsRetryInterval);
                    continue;
                }
                break;
            }
        }
    }
}

