/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.labelmanagement;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.java.dev.eval.Expression;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.NodeToLabelsList;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.labelmanagement.LabelExpressionHandlingHelper;
import org.apache.hadoop.yarn.server.resourcemanager.labelmanagement.LabelManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class LabelStorage {
    private static final Logger LOG = LoggerFactory.getLogger(LabelStorage.class);
    public static final Pattern regex = Pattern.compile("[^\\s,\"']+|\"([^\"]*)\"|'([^']*)'");
    public static final Pattern alpha_num = Pattern.compile("^[^0-9][A-Za-z0-9-_ ]+$");
    public static final Pattern keywords = Pattern.compile("^int$|^abs$|^pow$");
    private FileSystem fs;
    private Path labelFile = null;
    private static LabelStorage s_instance = new LabelStorage();
    private Map<String, List<String>> nodeExpressionLabels = new HashMap<String, List<String>>();
    private Map<String, List<String>> nodeNoGlobExpressionLabels = new HashMap<String, List<String>>();
    private Map<String, Set<String>> nodeToLabelsMap = new ConcurrentHashMap<String, Set<String>>();
    private Set<String> nodeNoMatchers = Collections.newSetFromMap(new ConcurrentHashMap());
    private Map<String, BigDecimal> labelEvalFillers = new HashMap<String, BigDecimal>();
    private final Set<Expression> labels = new HashSet<Expression>();

    private LabelStorage() {
    }

    public static LabelStorage getInstance() {
        return s_instance;
    }

    void storageInit(FileSystem fs, Path labelFile) {
        this.fs = fs;
        this.labelFile = labelFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    void loadAndApplyLabels(Configuration conf) throws IOException {
        String labelFilePath = conf.get("node.labels.file", null);
        Path path = this.labelFile = labelFilePath == null ? null : new Path(labelFilePath);
        if (this.labelFile == null || !this.fs.exists(this.labelFile) || this.fs.getContentSummary(this.labelFile).getLength() == 0L) {
            Object object = this.nodeExpressionLabels;
            synchronized (object) {
                Map<String, List<String>> map = this.nodeNoGlobExpressionLabels;
                synchronized (map) {
                    this.nodeExpressionLabels.clear();
                    this.nodeNoGlobExpressionLabels.clear();
                }
            }
            object = this.labels;
            synchronized (object) {
                this.labels.clear();
            }
            this.nodeToLabelsMap.clear();
            LOG.info("Labels file is empty or does not exist: " + this.labelFile + ". Labels are cleaned up.");
            return;
        }
        FSDataInputStream input = this.fs.open(this.labelFile);
        try (BufferedReader sin = new BufferedReader(new InputStreamReader((InputStream)input));){
            String str = null;
            HashMap nodeNotifierLabelsTmp = new HashMap();
            HashMap nodeNoGlobNotifierLabelsTmp = new HashMap();
            HashMap<String, BigDecimal> labelEvalFillersTmp = new HashMap<String, BigDecimal>();
            int lineno = 0;
            while ((str = sin.readLine()) != null) {
                String noGlobNodeIdentifier;
                String nodeIdentifier;
                ++lineno;
                String[] tokens = str.split("\\s+", 2);
                if (tokens.length != 2) {
                    LOG.warn("Wrong format in node label file -> " + lineno + ":" + str);
                    continue;
                }
                if (tokens[0].startsWith("/") && tokens[0].endsWith("/")) {
                    nodeIdentifier = tokens[0].replaceAll("^\\/|\\/$", "");
                    noGlobNodeIdentifier = tokens[0].replaceAll("^\\/|\\/$", "");
                } else {
                    nodeIdentifier = this.globSupport(tokens[0]);
                    noGlobNodeIdentifier = tokens[0];
                }
                ArrayList<String> nodeLabels = new ArrayList<String>();
                Matcher regexMatcher = regex.matcher(tokens[1]);
                while (regexMatcher.find()) {
                    String term = regexMatcher.group(1) != null ? regexMatcher.group(1) : (regexMatcher.group(2) != null ? regexMatcher.group(2) : regexMatcher.group());
                    if (term != null && alpha_num.matcher(term).matches() && !keywords.matcher(term).matches()) {
                        nodeLabels.add(term);
                        labelEvalFillersTmp.put(term, BigDecimal.ZERO);
                        continue;
                    }
                    LOG.warn("Invalid node label: '" + term + "'");
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("nodeIdentifier :" + nodeIdentifier + " labels :" + nodeLabels);
                }
                nodeNoGlobNotifierLabelsTmp.put(noGlobNodeIdentifier, nodeLabels);
                nodeNotifierLabelsTmp.put(nodeIdentifier, nodeLabels);
            }
            Map<String, List<String>> map = this.nodeExpressionLabels;
            synchronized (map) {
                Map<String, BigDecimal> map2 = this.labelEvalFillers;
                synchronized (map2) {
                    Map<String, List<String>> map3 = this.nodeNoGlobExpressionLabels;
                    synchronized (map3) {
                        this.nodeExpressionLabels.clear();
                        this.nodeNoGlobExpressionLabels.clear();
                        this.nodeExpressionLabels.putAll(nodeNotifierLabelsTmp);
                        this.nodeNoGlobExpressionLabels.putAll(nodeNoGlobNotifierLabelsTmp);
                        this.labelEvalFillers.clear();
                        this.labelEvalFillers.putAll(labelEvalFillersTmp);
                        this.nodeToLabelsMap.clear();
                        this.nodeNoMatchers.clear();
                    }
                }
            }
            this.updateClusterLabels();
            nodeNoGlobNotifierLabelsTmp.clear();
            nodeNotifierLabelsTmp.clear();
            labelEvalFillersTmp.clear();
            nodeNotifierLabelsTmp = null;
            nodeNoGlobNotifierLabelsTmp = null;
            labelEvalFillersTmp = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<String> getLabelsForNode(String node) {
        Set<String> labelsForNode = this.nodeToLabelsMap.get(node.toLowerCase());
        if (labelsForNode != null) {
            return labelsForNode;
        }
        if (this.nodeNoMatchers.contains(node.toLowerCase())) {
            return null;
        }
        HashMap<String, List<String>> nodeNotifierLabelsTmp = new HashMap<String, List<String>>();
        Map<String, List<String>> map = this.nodeExpressionLabels;
        synchronized (map) {
            nodeNotifierLabelsTmp.putAll(this.nodeExpressionLabels);
        }
        HashSet<String> nodeLabels = new HashSet<String>();
        for (Map.Entry entry : nodeNotifierLabelsTmp.entrySet()) {
            String nodeIdentifier = (String)entry.getKey();
            if (node.matches(nodeIdentifier)) {
                nodeLabels.addAll((Collection)entry.getValue());
                Set<String> listFromMap = this.nodeToLabelsMap.get(node.toLowerCase());
                if (listFromMap == null) {
                    this.nodeToLabelsMap.put(node.toLowerCase(), new HashSet((Collection)entry.getValue()));
                } else {
                    listFromMap.addAll((Collection)entry.getValue());
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Adding labels for node: " + node + ", labels: " + nodeLabels);
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Identifier not matching setLabel node: '" + node + "' identifier: '" + nodeIdentifier + "'");
        }
        nodeNotifierLabelsTmp.clear();
        nodeNotifierLabelsTmp = null;
        if (nodeLabels.isEmpty()) {
            this.nodeNoMatchers.add(node.toLowerCase());
            return null;
        }
        return nodeLabels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<NodeToLabelsList> getLabelsForAllNodes(boolean globSupport) {
        Map<String, List<String>> map;
        HashMap<String, List<String>> nodeNotifierLabelsTmp = new HashMap<String, List<String>>();
        if (globSupport) {
            map = this.nodeExpressionLabels;
            synchronized (map) {
                nodeNotifierLabelsTmp.putAll(this.nodeExpressionLabels);
            }
        }
        map = this.nodeNoGlobExpressionLabels;
        synchronized (map) {
            nodeNotifierLabelsTmp.putAll(this.nodeNoGlobExpressionLabels);
        }
        ArrayList<NodeToLabelsList> nodeToLabelsList = new ArrayList<NodeToLabelsList>();
        for (Map.Entry entry : nodeNotifierLabelsTmp.entrySet()) {
            NodeToLabelsList singleNodeToLabelsList = (NodeToLabelsList)RecordFactoryProvider.getRecordFactory(null).newRecordInstance(NodeToLabelsList.class);
            singleNodeToLabelsList.setNode((String)entry.getKey());
            singleNodeToLabelsList.setNodeLabel((List)entry.getValue());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding labels for node: " + (String)entry.getKey() + ", labels: " + entry.getValue());
            }
            nodeToLabelsList.add(singleNodeToLabelsList);
        }
        nodeNotifierLabelsTmp.clear();
        nodeNotifierLabelsTmp = null;
        return nodeToLabelsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, BigDecimal> getFillers() {
        HashMap<String, BigDecimal> labelEvalFillersTmp = new HashMap<String, BigDecimal>();
        Map<String, BigDecimal> map = this.labelEvalFillers;
        synchronized (map) {
            labelEvalFillersTmp.putAll(this.labelEvalFillers);
        }
        return labelEvalFillersTmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateClusterLabels() {
        HashSet<Expression> allLabels = new HashSet<Expression>();
        Expression labelExpression = null;
        List<NodeToLabelsList> labelsForAllNodes = this.getLabelsForAllNodes(true);
        for (NodeToLabelsList nodeToLabelsList : labelsForAllNodes) {
            for (String label : nodeToLabelsList.getNodeLabel()) {
                try {
                    labelExpression = LabelManager.getInstance().getEffectiveLabelExpr(label);
                }
                catch (IOException e) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Exception while trying to evaluate label expression " + labelExpression, (Throwable)e);
                    continue;
                }
                allLabels.add(labelExpression);
            }
        }
        Set<Expression> set = this.labels;
        synchronized (set) {
            this.labels.clear();
            this.labels.addAll(allLabels);
        }
    }

    public Set<Expression> getLabels() {
        return new HashSet<Expression>(this.labels);
    }

    public void addNodeLabels(Map<String, List<String>> newLabels) throws IOException, YarnException {
        if (null == this.labelFile) {
            LOG.error("Label-based scheduling is not enabled. Specify the path to the node.labels file");
            return;
        }
        HashMap<String, List<String>> modifiedLabels = new HashMap<String, List<String>>(this.nodeNoGlobExpressionLabels);
        HashSet<String> hostnames = new HashSet<String>(newLabels.keySet());
        for (String hostname : hostnames) {
            if (!modifiedLabels.containsKey(hostname)) continue;
            if (newLabels.get(hostname).equals(modifiedLabels.get(hostname))) {
                LOG.warn("Labels for node [" + hostname + "] already defined! Ignoring.");
            } else {
                ((List)modifiedLabels.get(hostname)).addAll((Collection)newLabels.get(hostname));
                modifiedLabels.replace(hostname, ((List)modifiedLabels.get(hostname)).stream().distinct().collect(Collectors.toList()));
            }
            newLabels.remove(hostname);
        }
        modifiedLabels.putAll(newLabels);
        if (!modifiedLabels.isEmpty()) {
            List<String> newLabelsList = this.packNodeLabelsToList(modifiedLabels);
            this.writeToFile(newLabelsList);
        }
    }

    private void writeToFile(List<String> nodeLabels) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)this.fs.create(this.labelFile, true)));
        for (String label : nodeLabels) {
            writer.write(label);
            writer.newLine();
        }
        writer.flush();
        writer.close();
    }

    public void replaceLabelsOnNode(Map<String, Map<String, String>> labelsForReplace) throws IOException {
        HashMap<String, List<String>> modifiedLabels = new HashMap<String, List<String>>(this.nodeNoGlobExpressionLabels);
        this.fs.delete(this.labelFile, false);
        this.nodeExpressionLabels.clear();
        try {
            for (String nodeName : labelsForReplace.keySet()) {
                if (!nodeName.equals("*") && !modifiedLabels.containsKey(nodeName)) {
                    LOG.error("Hostname [" + nodeName + "] does not exists in current configuration!");
                    continue;
                }
                if (nodeName.equals("*")) {
                    modifiedLabels.forEach((hostname, labels) -> labels.replaceAll(label -> ((Map)labelsForReplace.get("*")).getOrDefault(label, label)));
                    continue;
                }
                List currentLabels = (List)modifiedLabels.get(nodeName);
                currentLabels.replaceAll(label -> ((Map)labelsForReplace.get(nodeName)).getOrDefault(label, label));
            }
            modifiedLabels.forEach((node, labels) -> modifiedLabels.replace((String)node, labels.stream().distinct().collect(Collectors.toList())));
            this.writeToFile(this.packNodeLabelsToList(modifiedLabels));
        }
        catch (Exception e) {
            this.writeToFile(this.packNodeLabelsToList(this.nodeNoGlobExpressionLabels));
            throw e;
        }
    }

    public void removeNodeLabels(Map<String, List<String>> oldLabels) throws IOException {
        HashMap<String, List<String>> modifiedLabels = new HashMap<String, List<String>>(this.nodeNoGlobExpressionLabels);
        this.fs.delete(this.labelFile, false);
        this.nodeExpressionLabels.clear();
        try {
            if (oldLabels.keySet().size() == 1 && oldLabels.containsKey("*") && (oldLabels.get("*") == null || oldLabels.get("*").isEmpty())) {
                this.fs.create(this.labelFile, true);
                return;
            }
            if (oldLabels.keySet().size() == 1 && oldLabels.containsKey("*")) {
                modifiedLabels.values().forEach(list -> list.removeAll((Collection)oldLabels.get("*")));
                this.clearEmptyNodes(modifiedLabels);
            } else {
                HashSet<String> hostnames = new HashSet<String>(oldLabels.keySet());
                for (String hostname : hostnames) {
                    if (!modifiedLabels.containsKey(hostname)) continue;
                    if (oldLabels.get(hostname).size() == 1 && oldLabels.get(hostname).contains("*")) {
                        modifiedLabels.remove(hostname);
                        continue;
                    }
                    ((List)modifiedLabels.get(hostname)).removeAll((Collection)oldLabels.get(hostname));
                }
                this.clearEmptyNodes(modifiedLabels);
            }
            if (!modifiedLabels.isEmpty()) {
                this.writeToFile(this.packNodeLabelsToList(modifiedLabels));
            }
        }
        catch (IOException e) {
            this.writeToFile(this.packNodeLabelsToList(this.nodeNoGlobExpressionLabels));
            throw e;
        }
    }

    private Map<String, List<String>> clearEmptyNodes(Map<String, List<String>> labels) {
        HashSet<String> hostnames = new HashSet<String>(labels.keySet());
        for (String hostname : hostnames) {
            if (!labels.get(hostname).isEmpty()) continue;
            labels.remove(hostname);
        }
        return labels;
    }

    private List<String> packNodeLabelsToList(Map<String, List<String>> map) {
        ArrayList<String> nodeLabels = new ArrayList<String>();
        map.forEach((hostname, labels) -> {
            StringBuilder line = new StringBuilder((String)hostname);
            for (String label : labels) {
                line.append(" ").append(LabelExpressionHandlingHelper.wrapIfNeeded(label));
            }
            nodeLabels.add(line.toString());
        });
        return nodeLabels;
    }

    private String globSupport(String str) {
        return str.replaceAll("\\*", ".*").replaceAll("\\?", ".");
    }
}

