/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.labelmanagement;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.java.dev.eval.Expression;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeToLabelsList;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.labelmanagement.LabelExpressionHandlingHelper;
import org.apache.hadoop.yarn.server.resourcemanager.labelmanagement.LabelStorage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelManager {
    private static final Logger LOG = LoggerFactory.getLogger(LabelManager.class);
    private long lastModified = 0L;
    public static final String NODE_LABELS_FILE = "node.labels.file";
    public static final String NODE_LABELS_MONITOR_INTERVAL = "node.labels.monitor.interval";
    public static final long DEFAULT_RELOAD_INTERVAL = 120000L;
    private static final Pattern LABEL_PATTERN = Pattern.compile("^[^0-9][0-9a-zA-Z-_ ]+[']?$");
    private static final int MAX_LABEL_LENGTH = 255;
    private FileSystem fs;
    private Configuration config;
    private Path labelFile = null;
    private long labelManagerMonitorInterval = 120000L;
    private static LabelManager s_instance = new LabelManager();
    private Timer timer;
    private FileMonitor ttask;
    private volatile boolean isServiceEnabled;
    private LabelStorage storage = LabelStorage.getInstance();

    private LabelManager() {
    }

    public static LabelManager getInstance() {
        return s_instance;
    }

    void serviceInit(Configuration conf) throws Exception {
        this.setConfig(conf);
        this.fs = FileSystem.get((Configuration)conf);
        String labelFilePath = conf.get(NODE_LABELS_FILE, null);
        if (labelFilePath != null) {
            this.labelFile = new Path(labelFilePath);
            if (!this.fs.exists(this.labelFile)) {
                LOG.warn("Could not find node label file " + this.fs.makeQualified(this.labelFile) + ". Node labels will not be set.");
            }
            this.labelManagerMonitorInterval = conf.getLong(NODE_LABELS_MONITOR_INTERVAL, 120000L);
        }
        this.storage.storageInit(this.fs, this.labelFile);
    }

    void serviceStart() throws Exception {
        if (this.labelFile != null) {
            this.timer = new Timer();
            this.ttask = new FileMonitor();
            this.timer.scheduleAtFixedRate((TimerTask)this.ttask, 0L, this.labelManagerMonitorInterval);
            this.isServiceEnabled = true;
        }
    }

    void serviceStop() throws Exception {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    public void setConfig(Configuration conf) {
        this.config = conf;
    }

    public boolean isServiceEnabled() {
        return this.isServiceEnabled;
    }

    private boolean fileChanged() throws IOException {
        FileStatus labelFileStatus = null;
        if (!this.fs.exists(this.labelFile)) {
            return false;
        }
        labelFileStatus = this.fs.getFileStatus(this.labelFile);
        if (labelFileStatus != null && (this.lastModified == 0L || this.lastModified < labelFileStatus.getModificationTime())) {
            this.lastModified = labelFileStatus.getModificationTime();
            return true;
        }
        return false;
    }

    public void addToClusterNodeLabels(String args) throws IOException, YarnException {
        Map<String, List<String>> labels = this.buildNodeLabelsMapFromStr(args);
        for (List<String> labelsList : labels.values()) {
            this.checkLabels(labelsList);
        }
        this.storage.addNodeLabels(labels);
        this.refreshLabels(this.config);
    }

    private Map<String, List<String>> buildNodeLabelsMapFromStr(String args) {
        String[] lines;
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (String line : lines = args.split(";")) {
            String[] pair = line.split("=");
            String hostname = pair[0].trim();
            List labelsList = null;
            if (pair.length > 1) {
                String[] labels = pair[1].split(",");
                labelsList = Arrays.stream(labels).map(String::trim).map(LabelManager::deleteQuotes).collect(Collectors.toList());
            }
            map.put(hostname, labelsList);
        }
        return map;
    }

    public void removeFromClusterNodeLabels(String args) throws IOException {
        Map<String, List<String>> nodeLabels = this.buildNodeLabelsMapFromStr(args);
        this.storage.removeNodeLabels(nodeLabels);
        this.refreshLabels(this.config);
    }

    public void replaceLabelsOnNode(String args) throws IOException {
        this.storage.replaceLabelsOnNode(this.buildMapForReplace(args));
        this.refreshLabels(this.config);
    }

    private void checkLabels(Collection<String> labels) throws IOException {
        for (String label : labels) {
            if (label == null || label.isEmpty() || label.length() > 255) {
                throw new IOException("label added is empty or exceeds 255 character(s)");
            }
            if (LABEL_PATTERN.matcher(label).matches()) continue;
            throw new IOException("label name should only contains {0-9, a-z, A-Z, -, _} and should not started with a digit, now it is = " + label);
        }
    }

    private Map<String, Map<String, String>> buildMapForReplace(String args) throws IOException {
        HashMap<String, Map<String, String>> labelsForReplace = new HashMap<String, Map<String, String>>();
        try {
            String[] lines;
            for (String line : lines = args.split(";")) {
                String[] pair = line.split("=");
                String[] labelPairs = pair[1].split(",");
                HashMap<String, String> labels = new HashMap<String, String>();
                for (String labelPair : labelPairs) {
                    String[] split = labelPair.split("\\|");
                    labels.put(LabelManager.deleteQuotes(split[0].trim()), LabelManager.deleteQuotes(split[1].trim()));
                }
                this.checkLabels(labels.values());
                labelsForReplace.put(pair[0].trim(), labels);
            }
        }
        catch (RuntimeException e) {
            throw new IOException("Wrong syntax of arguments. Abort.");
        }
        return labelsForReplace;
    }

    public static String deleteQuotes(String label) {
        String SINGLE_QUOTATION_MARK = "'";
        if (StringUtils.startsWith((String)label, (String)"'")) {
            label = label.substring(1);
        }
        if (StringUtils.endsWith((String)label, (String)"'")) {
            label = label.substring(0, label.length() - 1);
        }
        return label;
    }

    @InterfaceAudience.Private
    public void refreshLabels(Configuration conf) throws IOException {
        this.storage.loadAndApplyLabels(conf);
    }

    public Set<String> getLabelsForNode(String node) {
        return this.storage.getLabelsForNode(node);
    }

    public List<NodeToLabelsList> getLabelsForAllNodes(boolean globSupport) {
        return this.storage.getLabelsForAllNodes(globSupport);
    }

    public Set<Expression> getLabels() {
        return this.storage.getLabels();
    }

    public Map<String, Set<NodeId>> getLabelsToNodes(Set<String> labelsToAdd) {
        HashMap<String, Set<NodeId>> labelsToNodes = new HashMap<String, Set<NodeId>>();
        for (NodeToLabelsList n : this.storage.getLabelsForAllNodes(true)) {
            NodeId nodeId = NodeId.newInstance((String)n.getNode(), (int)0);
            List nodeLabels = n.getNodeLabel();
            for (String label : nodeLabels) {
                if (labelsToAdd != null && !labelsToAdd.isEmpty() && (labelsToAdd == null || !labelsToAdd.contains(label))) continue;
                HashSet<NodeId> nodeIds = (HashSet<NodeId>)labelsToNodes.get(label);
                if (nodeIds == null) {
                    nodeIds = new HashSet<NodeId>();
                    nodeIds.add(nodeId);
                    labelsToNodes.put(label, nodeIds);
                    continue;
                }
                nodeIds.add(nodeId);
                labelsToNodes.remove(label);
                labelsToNodes.put(label, nodeIds);
            }
        }
        return labelsToNodes;
    }

    public Map<NodeId, Set<String>> getNodeToLabels() {
        HashMap<NodeId, Set<String>> nodeToLabels = new HashMap<NodeId, Set<String>>();
        for (NodeToLabelsList n : this.storage.getLabelsForAllNodes(true)) {
            NodeId nodeId = NodeId.newInstance((String)n.getNode(), (int)0);
            HashSet nodeLabels = new HashSet(n.getNodeLabel());
            nodeToLabels.put(nodeId, nodeLabels);
        }
        return nodeToLabels;
    }

    public Expression getEffectiveLabelExpr(String labelStr) throws IOException {
        return LabelExpressionHandlingHelper.getEffectiveLabelExpr(labelStr);
    }

    public Expression constructAppLabel(Queue.QueueLabelPolicy policy, Expression appLabelExpression, Expression queueLabelExpression) {
        return LabelExpressionHandlingHelper.constructAppLabel(policy, appLabelExpression, queueLabelExpression);
    }

    public LabelApplicabilityStatus isNodeApplicableForApp(String node, Expression finalAppLabelExp) throws IOException {
        return LabelExpressionHandlingHelper.isNodeApplicableForApp(node, finalAppLabelExp);
    }

    public List<String> getNodesForLabel(Expression label) throws IOException {
        return LabelExpressionHandlingHelper.getNodesForLabel(label);
    }

    public Path getLabelFile() {
        return this.labelFile;
    }

    public static enum LabelApplicabilityStatus {
        NOT_APPLICABLE,
        NODE_HAS_LABEL,
        NODE_DOES_NOT_HAVE_LABEL;

    }

    private class FileMonitor
    extends TimerTask {
        private FileMonitor() {
        }

        @Override
        public void run() {
            try {
                if (LabelManager.this.fileChanged()) {
                    LabelManager.this.storage.loadAndApplyLabels(LabelManager.this.config);
                }
            }
            catch (Exception e) {
                LOG.error("LabelManager Thread got exception: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e) + ". Ignoring...");
            }
        }
    }
}

