/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.IOException;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.BaseMapRUtil;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.server.api.ConfigurableAuxiliaryService;
import org.apache.hadoop.yarn.util.YarnAppUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMVolumeManager
extends ConfigurableAuxiliaryService {
    private static final Logger LOG = LoggerFactory.getLogger(RMVolumeManager.class);
    private static final String RM_VOLUME_SCRIPT_PATH = "/server/createJTVolume.sh";
    private static final String RM_VOLUME_LOGFILE_PATH = "/logs/createRMVolume.log";

    RMVolumeManager() {
        super("RMVolumeManager");
    }

    public void serviceInit(Configuration conf) throws Exception {
        this.createVolume(conf);
        FileSystem fs = FileSystem.get((Configuration)conf);
        this.createDir(fs, conf.get("yarn.resourcemanager.system"), YarnAppUtil.RM_SYSTEM_DIR_PERMISSION);
        this.createDir(fs, conf.get("yarn.resourcemanager.staging"), YarnAppUtil.RM_STAGING_DIR_PERMISSION);
    }

    private void createVolume(Configuration conf) throws Exception {
        String maprInstallDir = BaseMapRUtil.getPathToMaprHome();
        String clusterPath = conf.get("cluster.name.prefix");
        String mountPath = conf.get("yarn.resourcemanager.dir");
        if (clusterPath != null) {
            mountPath = mountPath.substring(0, mountPath.length() - "/rm".length());
        }
        String[] args = new String[]{maprInstallDir + RM_VOLUME_SCRIPT_PATH, BaseMapRUtil.getMapRHostName(), mountPath, conf.get("yarn.resourcemanager.dir"), "yarn"};
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("MAPR_MAPREDUCE_MODE", "yarn");
        Shell.ShellCommandExecutor shexec = new Shell.ShellCommandExecutor(args, null, env);
        if (LOG.isInfoEnabled()) {
            LOG.info("Checking for ResourceManager volume. If volume not present command will create and mount it. Command invoked is : " + shexec.toString());
        }
        int numAttempts = 3;
        for (int i = 0; i < numAttempts; ++i) {
            try {
                shexec.execute();
                break;
            }
            catch (IOException ioe) {
                if (i == numAttempts - 1) {
                    int exitCode = shexec.getExitCode();
                    if (exitCode != 0) {
                        LOG.error("Failed to create and mount ResourceManager volume at " + args[2] + ". Please see logs at " + maprInstallDir + RM_VOLUME_LOGFILE_PATH);
                        LOG.error("Command ran " + shexec.toString());
                        LOG.error("Command output " + shexec.getOutput());
                    }
                    throw ioe;
                }
                Thread.sleep(100L);
                if (!LOG.isInfoEnabled()) continue;
                LOG.info("Retrying check for ResourceManager volume ... ");
                continue;
            }
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Sucessfully created ResourceManager volume and mounted at " + args[2]);
        }
    }

    private void createDir(FileSystem fs, String pathName, FsPermission perm) throws IOException {
        if (LOG.isInfoEnabled()) {
            LOG.info("Creating RM dir: " + pathName + " with permission: " + perm);
        }
        FileSystem.mkdirs((FileSystem)fs, (Path)new Path(pathName), (FsPermission)perm);
    }
}

