/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.JsonArray;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.util.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaprShellCommandExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(MaprShellCommandExecutor.class);
    private static final String DATA_FIELD = "data";
    private final JsonParser parser = new JsonParser();
    private Shell.ShellCommandExecutor executor;

    public JsonArray execute(String[] command, Map<String, String> params) throws IOException {
        if (this.executor == null) {
            this.executor = new Shell.ShellCommandExecutor(this.createArgs(command, params));
        }
        LOG.info("Trying to execute maprcli command: " + this.executor.toString());
        try {
            this.executor.execute();
            String output = this.executor.getOutput();
            if (output == null || output.isEmpty()) {
                LOG.error("Output is empty");
                throw new IOException("Empty output");
            }
            JsonArray jsonArray = this.parser.parse(this.executor.getOutput()).getAsJsonObject().getAsJsonArray(DATA_FIELD);
            return jsonArray;
        }
        catch (IOException e) {
            int exitCode = this.executor.getExitCode();
            if (exitCode != 0) {
                LOG.error("Failed to execute command. Command output " + this.executor.getOutput());
            }
            throw e;
        }
        finally {
            this.executor = null;
        }
    }

    @VisibleForTesting
    protected void setCommandExecutor(Shell.ShellCommandExecutor executor) {
        this.executor = executor;
    }

    @VisibleForTesting
    protected String[] createArgs(String[] command, Map<String, String> params) {
        if (command == null) {
            throw new IllegalArgumentException("Empty command");
        }
        if (params == null) {
            params = new HashMap<String, String>();
        }
        int size = command.length + params.size() * 2 + 2;
        String[] args = new String[size];
        int counter = 0;
        args[counter++] = "maprcli";
        for (String c : command) {
            args[counter++] = c;
        }
        for (Map.Entry entry : params.entrySet()) {
            String paramName = this.validateAndGetParamName((String)entry.getKey());
            args[counter++] = paramName;
            args[counter++] = (String)entry.getValue();
        }
        args[counter] = "-json";
        return args;
    }

    private String validateAndGetParamName(String value) {
        if (value.startsWith("-")) {
            return value;
        }
        return "-" + value;
    }
}

