/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tracing;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.tracing.SpanReceiverInfo;
import org.apache.htrace.core.HTraceConfiguration;

@InterfaceAudience.Private
public class TraceUtils {
    public static final String HTRACE_CONF_PREFIX = "hadoop.htrace.";
    private static List<SpanReceiverInfo.ConfigurationPair> EMPTY = Collections.emptyList();
    static final String DEFAULT_HADOOP_PREFIX = "hadoop.htrace.";

    public static HTraceConfiguration wrapHadoopConf(String prefix, Configuration conf) {
        return TraceUtils.wrapHadoopConf(prefix, conf, EMPTY);
    }

    public static HTraceConfiguration wrapHadoopConf(final String prefix, final Configuration conf, List<SpanReceiverInfo.ConfigurationPair> extraConfig) {
        final HashMap<String, String> extraMap = new HashMap<String, String>();
        for (SpanReceiverInfo.ConfigurationPair pair : extraConfig) {
            extraMap.put(pair.getKey(), pair.getValue());
        }
        return new HTraceConfiguration(){

            public String get(String key) {
                String ret = this.getInternal(prefix + key);
                if (ret != null) {
                    return ret;
                }
                return this.getInternal("hadoop.htrace." + key);
            }

            public String get(String key, String defaultValue) {
                String ret = this.get(key);
                if (ret != null) {
                    return ret;
                }
                return defaultValue;
            }

            private String getInternal(String key) {
                if (extraMap.containsKey(key)) {
                    return (String)extraMap.get(key);
                }
                return conf.get(key);
            }
        };
    }
}

