/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.net.InetAddresses;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.HadoopKerberosName;
import org.apache.hadoop.security.KerberosInfo;
import org.apache.hadoop.security.SecurityInfo;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.rpcauth.RpcAuthMethod;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenInfo;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.xbill.DNS.Name;
import org.xbill.DNS.ResolverConfig;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class SecurityUtil {
    public static final Logger LOG = LoggerFactory.getLogger(SecurityUtil.class);
    private static final Marker FATAL = MarkerFactory.getMarker((String)"FATAL");
    public static final String HOSTNAME_PATTERN = "_HOST";
    public static final String FAILED_TO_GET_UGI_MSG_HEADER = "Failed to obtain user group information:";
    @VisibleForTesting
    static boolean useIpForTokenService;
    @VisibleForTesting
    static HostResolver hostResolver;
    private static ServiceLoader<SecurityInfo> securityInfoProviders;
    private static SecurityInfo[] testProviders;

    @InterfaceAudience.Private
    @VisibleForTesting
    public static void setTokenServiceUseIp(boolean flag) {
        useIpForTokenService = flag;
        hostResolver = !useIpForTokenService ? new QualifiedHostResolver() : new StandardHostResolver();
    }

    static boolean isTGSPrincipal(KerberosPrincipal principal) {
        if (principal == null) {
            return false;
        }
        return principal.getName().equals("krbtgt/" + principal.getRealm() + "@" + principal.getRealm());
    }

    protected static boolean isOriginalTGT(KerberosTicket ticket) {
        return SecurityUtil.isTGSPrincipal(ticket.getServer());
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static String getServerPrincipal(String principalConfig, String hostname) throws IOException {
        String[] components = SecurityUtil.getComponents(principalConfig);
        if (components == null || components.length != 3 || !components[1].equals(HOSTNAME_PATTERN)) {
            return principalConfig;
        }
        return SecurityUtil.replacePattern(components, hostname);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static String getServerPrincipal(String principalConfig, InetAddress addr) throws IOException {
        String[] components = SecurityUtil.getComponents(principalConfig);
        if (components == null || components.length != 3 || !components[1].equals(HOSTNAME_PATTERN)) {
            return principalConfig;
        }
        if (addr == null) {
            throw new IOException("Can't replace _HOST pattern since client address is null");
        }
        return SecurityUtil.replacePattern(components, addr.getCanonicalHostName());
    }

    private static String[] getComponents(String principalConfig) {
        if (principalConfig == null) {
            return null;
        }
        return principalConfig.split("[/@]");
    }

    private static String replacePattern(String[] components, String hostname) throws IOException {
        String fqdn = hostname;
        if (fqdn == null || fqdn.isEmpty() || fqdn.equals("0.0.0.0")) {
            fqdn = SecurityUtil.getLocalHostName();
        }
        return components[0] + "/" + StringUtils.toLowerCase(fqdn) + "@" + components[2];
    }

    static String getLocalHostName() throws UnknownHostException {
        return InetAddress.getLocalHost().getCanonicalHostName();
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static void login(Configuration conf, String keytabFileKey, String userNameKey) throws IOException {
        SecurityUtil.login(conf, keytabFileKey, userNameKey, SecurityUtil.getLocalHostName());
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static void login(Configuration conf, String keytabFileKey, String userNameKey, String hostname) throws IOException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        String keytabFilename = conf.get(keytabFileKey);
        String principalName = SecurityUtil.getServerPrincipal(conf.get(userNameKey, System.getProperty("user.name")), hostname);
        UserGroupInformation.loginUserFromKeytab(principalName, keytabFilename);
    }

    public static String buildDTServiceName(URI uri, int defPort) {
        String authority = uri.getAuthority();
        if (authority == null) {
            return null;
        }
        InetSocketAddress addr = NetUtils.createSocketAddr(authority, defPort);
        return SecurityUtil.buildTokenService(addr).toString();
    }

    public static String getHostFromPrincipal(String principalName) {
        return new HadoopKerberosName(principalName).getHostName();
    }

    @InterfaceAudience.Private
    public static void setSecurityInfoProviders(SecurityInfo ... providers) {
        testProviders = providers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KerberosInfo getKerberosInfo(Class<?> protocol, Configuration conf) {
        for (SecurityInfo provider : testProviders) {
            KerberosInfo result = provider.getKerberosInfo(protocol, conf);
            if (result == null) continue;
            return result;
        }
        ServiceLoader<SecurityInfo> serviceLoader = securityInfoProviders;
        synchronized (serviceLoader) {
            for (SecurityInfo provider : securityInfoProviders) {
                KerberosInfo result = provider.getKerberosInfo(protocol, conf);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TokenInfo getTokenInfo(Class<?> protocol, Configuration conf) {
        for (SecurityInfo provider : testProviders) {
            TokenInfo result = provider.getTokenInfo(protocol, conf);
            if (result == null) continue;
            return result;
        }
        ServiceLoader<SecurityInfo> serviceLoader = securityInfoProviders;
        synchronized (serviceLoader) {
            for (SecurityInfo provider : securityInfoProviders) {
                TokenInfo result = provider.getTokenInfo(protocol, conf);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public static InetSocketAddress getTokenServiceAddr(Token<?> token) {
        return NetUtils.createSocketAddr(token.getService().toString());
    }

    public static void setTokenService(Token<?> token, InetSocketAddress addr) {
        Text service = SecurityUtil.buildTokenService(addr);
        if (token != null) {
            token.setService(service);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Acquired token " + token);
            }
        } else {
            LOG.warn("Failed to get token for service " + service);
        }
    }

    public static Text buildTokenService(InetSocketAddress addr) {
        String host = null;
        if (useIpForTokenService) {
            if (addr.isUnresolved()) {
                throw new IllegalArgumentException(new UnknownHostException(addr.getHostName()));
            }
            host = addr.getAddress().getHostAddress();
        } else {
            host = StringUtils.toLowerCase(addr.getHostName());
        }
        return new Text(host + ":" + addr.getPort());
    }

    public static Text buildTokenService(URI uri) {
        return SecurityUtil.buildTokenService(NetUtils.createSocketAddr(uri.getAuthority()));
    }

    public static <T> T doAsLoginUserOrFatal(PrivilegedAction<T> action) {
        if (UserGroupInformation.isSecurityEnabled()) {
            UserGroupInformation ugi = null;
            try {
                ugi = UserGroupInformation.getLoginUser();
            }
            catch (IOException e) {
                LOG.error(FATAL, "Exception while getting login user", (Throwable)e);
                e.printStackTrace();
                Runtime.getRuntime().exit(-1);
            }
            return ugi.doAs(action);
        }
        return action.run();
    }

    public static <T> T doAsLoginUser(PrivilegedExceptionAction<T> action) throws IOException {
        return SecurityUtil.doAsUser(UserGroupInformation.getLoginUser(), action);
    }

    public static <T> T doAsCurrentUser(PrivilegedExceptionAction<T> action) throws IOException {
        return SecurityUtil.doAsUser(UserGroupInformation.getCurrentUser(), action);
    }

    private static <T> T doAsUser(UserGroupInformation ugi, PrivilegedExceptionAction<T> action) throws IOException {
        try {
            return ugi.doAs(action);
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    @InterfaceAudience.Private
    public static InetAddress getByName(String hostname) throws UnknownHostException {
        return hostResolver.getByName(hostname);
    }

    public static UserGroupInformation.AuthenticationMethod getAuthenticationMethod(Configuration conf) {
        return UserGroupInformation.getUGIAuthenticationMethod();
    }

    public static void setAuthenticationMethod(UserGroupInformation.AuthenticationMethod authenticationMethod, Configuration conf) {
        if (authenticationMethod == null) {
            authenticationMethod = UserGroupInformation.AuthenticationMethod.SIMPLE;
        }
        conf.set("hadoop.security.authentication", StringUtils.toLowerCase(authenticationMethod.toString()));
    }

    public static boolean isPrivilegedPort(int port) {
        return port < 1024;
    }

    public static Class<? extends Principal> getCustomAuthPrincipal(Configuration conf) {
        String principalClassName = conf.get("hadoop.security.custom.auth.principal.class");
        try {
            Class<?> principalClass = conf.getClassByName(principalClassName);
            return principalClass.asSubclass(Principal.class);
        }
        catch (ClassNotFoundException cnfe) {
            LOG.error("The value '" + principalClassName + "' provided for hadoop.security.custom.auth.principal.class is not a valid class name.", (Throwable)cnfe);
        }
        catch (ClassCastException cce) {
            LOG.error("The value provided for hadoop.security.custom.auth.principal.class does not extend " + Principal.class.getName(), (Throwable)cce);
        }
        return null;
    }

    public static Class<? extends RpcAuthMethod> getCustomRpcAuthMethod(Configuration conf) {
        String rpcAuthMethodClassName = conf.get("hadoop.security.custom.rpc.auth.method.class");
        try {
            Class<?> rpcAuthMethodClass = conf.getClassByName(rpcAuthMethodClassName);
            return rpcAuthMethodClass.asSubclass(RpcAuthMethod.class);
        }
        catch (ClassNotFoundException cnfe) {
            LOG.error("The value '" + rpcAuthMethodClassName + "' provided for hadoop.security.custom.rpc.auth.method.class is not a valid class name.", (Throwable)cnfe);
        }
        catch (ClassCastException cce) {
            LOG.error("The value provided for hadoop.security.custom.rpc.auth.method.class does not extend " + Principal.class.getName(), (Throwable)cce);
        }
        return null;
    }

    static {
        Configuration conf = new Configuration();
        boolean useIp = conf.getBoolean("hadoop.security.token.service.use_ip", true);
        SecurityUtil.setTokenServiceUseIp(useIp);
        securityInfoProviders = ServiceLoader.load(SecurityInfo.class);
        testProviders = new SecurityInfo[0];
    }

    protected static class QualifiedHostResolver
    implements HostResolver {
        private List<String> searchDomains = new ArrayList<String>();

        protected QualifiedHostResolver() {
            ResolverConfig resolverConfig = ResolverConfig.getCurrentConfig();
            Name[] names = resolverConfig.searchPath();
            if (names != null) {
                for (Name name : names) {
                    this.searchDomains.add(name.toString());
                }
            }
        }

        @Override
        public InetAddress getByName(String host) throws UnknownHostException {
            InetAddress addr = null;
            if (InetAddresses.isInetAddress((String)host)) {
                addr = InetAddresses.forString((String)host);
                addr = InetAddress.getByAddress(host, addr.getAddress());
            } else if (host.endsWith(".")) {
                addr = this.getByExactName(host);
            } else if (host.contains(".")) {
                addr = this.getByExactName(host);
                if (addr == null) {
                    addr = this.getByNameWithSearch(host);
                }
            } else {
                InetAddress loopback = InetAddress.getByName(null);
                if (host.equalsIgnoreCase(loopback.getHostName())) {
                    addr = InetAddress.getByAddress(host, loopback.getAddress());
                } else {
                    addr = this.getByNameWithSearch(host);
                    if (addr == null) {
                        addr = this.getByExactName(host);
                    }
                }
            }
            if (addr == null) {
                throw new UnknownHostException(host);
            }
            return addr;
        }

        InetAddress getByExactName(String host) {
            InetAddress addr = null;
            Object fqHost = host;
            if (!((String)fqHost).endsWith(".")) {
                fqHost = (String)fqHost + ".";
            }
            try {
                addr = this.getInetAddressByName((String)fqHost);
                addr = InetAddress.getByAddress(host, addr.getAddress());
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            return addr;
        }

        InetAddress getByNameWithSearch(String host) {
            InetAddress addr = null;
            if (host.endsWith(".")) {
                addr = this.getByExactName(host);
            } else {
                String domain;
                String dot;
                Iterator<String> iterator = this.searchDomains.iterator();
                while (iterator.hasNext() && (addr = this.getByExactName(host + (dot = !(domain = iterator.next()).startsWith(".") ? "." : "") + domain)) == null) {
                }
            }
            return addr;
        }

        InetAddress getInetAddressByName(String host) throws UnknownHostException {
            return InetAddress.getByName(host);
        }

        void setSearchDomains(String ... domains) {
            this.searchDomains = Arrays.asList(domains);
        }
    }

    static class StandardHostResolver
    implements HostResolver {
        StandardHostResolver() {
        }

        @Override
        public InetAddress getByName(String host) throws UnknownHostException {
            return InetAddress.getByName(host);
        }
    }

    static interface HostResolver {
        public InetAddress getByName(String var1) throws UnknownHostException;
    }
}

