/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.security.Security;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.security.SaslPlainServer;
import org.apache.hadoop.security.rpcauth.DigestAuthMethod;
import org.apache.hadoop.security.rpcauth.KerberosAuthMethod;
import org.apache.hadoop.security.rpcauth.RpcAuthMethod;
import org.apache.hadoop.security.rpcauth.RpcAuthRegistry;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class SaslRpcServer {
    public static final Logger LOG = LoggerFactory.getLogger(SaslRpcServer.class);
    public static final String SASL_DEFAULT_REALM = "default";
    public static final String SASL_AUTH_SECRET_MANAGER = "org.apache.hadoop.auth.secret.manager";
    public static final String SASL_KERBEROS_PRINCIPAL = "org.apache.hadoop.auth.kerberos.principal";
    public static final String SASL_AUTH_TOKEN = "org.apache.hadoop.auth.token";
    public RpcAuthMethod authMethod;
    public String mechanism;
    public String protocol;
    public String serverId;

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public SaslRpcServer(RpcAuthMethod authMethod) throws IOException {
        this.authMethod = authMethod;
        this.mechanism = authMethod.getMechanismName();
        if (authMethod.equals(RpcAuthRegistry.SIMPLE)) {
            return;
        }
        this.protocol = authMethod.getProtocol();
        this.serverId = authMethod.getServerId();
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public SaslServer create(Server.Connection connection, Map<String, Object> saslProperties, SecretManager<TokenIdentifier> secretManager) throws IOException, InterruptedException {
        if (secretManager != null) {
            saslProperties.put(SASL_AUTH_SECRET_MANAGER, secretManager);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("creating SaslServer for authMethod: " + this.authMethod);
        }
        return this.authMethod.createSaslServer(connection, saslProperties);
    }

    public static void init(Configuration conf) {
        Security.addProvider(new SaslPlainServer.SecurityProvider());
    }

    static String encodeIdentifier(byte[] identifier) {
        return DigestAuthMethod.encodeIdentifier(identifier);
    }

    static byte[] decodeIdentifier(String identifier) {
        return DigestAuthMethod.decodeIdentifier(identifier);
    }

    public static <T extends TokenIdentifier> T getIdentifier(String id, SecretManager<T> secretManager) throws SecretManager.InvalidToken {
        return DigestAuthMethod.getIdentifier(id, secretManager);
    }

    static char[] encodePassword(byte[] password) {
        return DigestAuthMethod.encodePassword(password);
    }

    public static String[] splitKerberosName(String fullName) {
        return KerberosAuthMethod.splitKerberosName(fullName);
    }

    private static class FastSaslServerFactory
    implements SaslServerFactory {
        private final Map<String, List<SaslServerFactory>> factoryCache = new HashMap<String, List<SaslServerFactory>>();

        FastSaslServerFactory(Map<String, ?> props) {
            Enumeration<SaslServerFactory> factories = Sasl.getSaslServerFactories();
            while (factories.hasMoreElements()) {
                SaslServerFactory factory = factories.nextElement();
                for (String mech : factory.getMechanismNames(props)) {
                    if (!this.factoryCache.containsKey(mech)) {
                        this.factoryCache.put(mech, new ArrayList());
                    }
                    this.factoryCache.get(mech).add(factory);
                }
            }
        }

        @Override
        public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
            SaslServer saslServer;
            block1: {
                SaslServerFactory factory;
                saslServer = null;
                List<SaslServerFactory> factories = this.factoryCache.get(mechanism);
                if (factories == null) break block1;
                Iterator<SaslServerFactory> iterator = factories.iterator();
                while (iterator.hasNext() && (saslServer = (factory = iterator.next()).createSaslServer(mechanism, protocol, serverName, props, cbh)) == null) {
                }
            }
            return saslServer;
        }

        @Override
        public String[] getMechanismNames(Map<String, ?> props) {
            return this.factoryCache.keySet().toArray(new String[0]);
        }
    }

    @InterfaceStability.Evolving
    public static class SaslGssCallbackHandler
    extends KerberosAuthMethod.SaslGssCallbackHandler {
    }

    @InterfaceStability.Evolving
    public static class SaslDigestCallbackHandler
    extends DigestAuthMethod.SaslDigestCallbackHandler {
        public SaslDigestCallbackHandler(SecretManager<TokenIdentifier> secretManager, Server.Connection connection) {
            super(secretManager, connection);
        }
    }

    @InterfaceStability.Evolving
    public static enum AuthMethod {
        SIMPLE(80, ""),
        KERBEROS(81, "GSSAPI"),
        DIGEST(82, "DIGEST-MD5"),
        TOKEN(82, "DIGEST-MD5"),
        PLAIN(83, "PLAIN");

        public final byte code;
        public final String mechanismName;
        private static final int FIRST_CODE;

        private AuthMethod(byte code, String mechanismName) {
            this.code = code;
            this.mechanismName = mechanismName;
        }

        private static AuthMethod valueOf(byte code) {
            int i = (code & 0xFF) - FIRST_CODE;
            return i < 0 || i >= AuthMethod.values().length ? null : AuthMethod.values()[i];
        }

        public String getMechanismName() {
            return this.mechanismName;
        }

        public static AuthMethod read(DataInput in) throws IOException {
            return AuthMethod.valueOf(in.readByte());
        }

        public void write(DataOutput out) throws IOException {
            out.write(this.code);
        }

        static {
            FIRST_CODE = AuthMethod.values()[0].code;
        }
    }

    public static enum QualityOfProtection {
        AUTHENTICATION("auth"),
        INTEGRITY("auth-int"),
        PRIVACY("auth-conf");

        public final String saslQop;

        private QualityOfProtection(String saslQop) {
            this.saslQop = saslQop;
        }

        public String getSaslQop() {
            return this.saslQop;
        }
    }
}

