/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.naming.CommunicationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.spi.InitialContextFactory;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.io.Charsets;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.GroupMappingServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class LdapGroupsMapping
implements GroupMappingServiceProvider,
Configurable {
    public static final String LDAP_CONFIG_PREFIX = "hadoop.security.group.mapping.ldap";
    public static final String LDAP_URL_KEY = "hadoop.security.group.mapping.ldap.url";
    public static final String LDAP_URL_DEFAULT = "";
    public static final String LDAP_USE_SSL_KEY = "hadoop.security.group.mapping.ldap.ssl";
    public static final Boolean LDAP_USE_SSL_DEFAULT = false;
    public static final String LDAP_KEYSTORE_KEY = "hadoop.security.group.mapping.ldap.ssl.keystore";
    public static final String LDAP_KEYSTORE_DEFAULT = "";
    public static final String LDAP_KEYSTORE_PASSWORD_KEY = "hadoop.security.group.mapping.ldap.ssl.keystore.password";
    public static final String LDAP_KEYSTORE_PASSWORD_DEFAULT = "";
    public static final String LDAP_KEYSTORE_PASSWORD_FILE_KEY = "hadoop.security.group.mapping.ldap.ssl.keystore.password.file";
    public static final String LDAP_KEYSTORE_PASSWORD_FILE_DEFAULT = "";
    public static final String LDAP_TRUSTSTORE_KEY = "hadoop.security.group.mapping.ldap.ssl.truststore";
    public static final String LDAP_TRUSTSTORE_PASSWORD_KEY = "hadoop.security.group.mapping.ldap.ssl.truststore.password";
    public static final String LDAP_TRUSTSTORE_PASSWORD_FILE_KEY = "hadoop.security.group.mapping.ldap.ssl.truststore.password.file";
    public static final String BIND_USER_KEY = "hadoop.security.group.mapping.ldap.bind.user";
    public static final String BIND_USER_DEFAULT = "";
    public static final String BIND_PASSWORD_KEY = "hadoop.security.group.mapping.ldap.bind.password";
    public static final String BIND_PASSWORD_DEFAULT = "";
    public static final String BIND_PASSWORD_FILE_KEY = "hadoop.security.group.mapping.ldap.bind.password.file";
    public static final String BIND_PASSWORD_FILE_DEFAULT = "";
    public static final String BASE_DN_KEY = "hadoop.security.group.mapping.ldap.base";
    public static final String BASE_DN_DEFAULT = "";
    public static final String USER_SEARCH_FILTER_KEY = "hadoop.security.group.mapping.ldap.search.filter.user";
    public static final String USER_SEARCH_FILTER_DEFAULT = "(&(objectClass=user)(sAMAccountName={0}))";
    public static final String GROUP_SEARCH_FILTER_KEY = "hadoop.security.group.mapping.ldap.search.filter.group";
    public static final String GROUP_SEARCH_FILTER_DEFAULT = "(objectClass=group)";
    public static final String GROUP_MEMBERSHIP_ATTR_KEY = "hadoop.security.group.mapping.ldap.search.attr.member";
    public static final String GROUP_MEMBERSHIP_ATTR_DEFAULT = "member";
    public static final String GROUP_NAME_ATTR_KEY = "hadoop.security.group.mapping.ldap.search.attr.group.name";
    public static final String GROUP_NAME_ATTR_DEFAULT = "cn";
    public static final String POSIX_UID_ATTR_KEY = "hadoop.security.group.mapping.ldap.posix.attr.uid.name";
    public static final String POSIX_UID_ATTR_DEFAULT = "uidNumber";
    public static final String POSIX_GID_ATTR_KEY = "hadoop.security.group.mapping.ldap.posix.attr.gid.name";
    public static final String POSIX_GID_ATTR_DEFAULT = "gidNumber";
    public static final String POSIX_GROUP = "posixGroup";
    public static final String POSIX_ACCOUNT = "posixAccount";
    public static final String DIRECTORY_SEARCH_TIMEOUT = "hadoop.security.group.mapping.ldap.directory.search.timeout";
    public static final int DIRECTORY_SEARCH_TIMEOUT_DEFAULT = 10000;
    public static final String CONNECTION_TIMEOUT = "hadoop.security.group.mapping.ldap.connection.timeout.ms";
    public static final int CONNECTION_TIMEOUT_DEFAULT = 60000;
    public static final String READ_TIMEOUT = "hadoop.security.group.mapping.ldap.read.timeout.ms";
    public static final int READ_TIMEOUT_DEFAULT = 60000;
    private static final Logger LOG = LoggerFactory.getLogger(LdapGroupsMapping.class);
    private static final String LDAP_SOCKET_FACTORY_ENV_KEY = "java.naming.ldap.factory.socket";
    public static final String LDAP_CTX_FACTORY_CLASS_KEY = "hadoop.security.group.mapping.ldap.ctx.factory.class";
    public static final String LDAP_CTX_FACTORY_CLASS_DEFAULT = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final SearchControls SEARCH_CONTROLS = new SearchControls();
    private DirContext ctx;
    private Configuration conf;
    private String ldapUrl;
    private boolean useSsl;
    private String keystore;
    private String keystorePass;
    private String truststore;
    private String truststorePass;
    private String bindUser;
    private String bindPassword;
    private String baseDN;
    private String groupSearchFilter;
    private String userSearchFilter;
    private String groupMemberAttr;
    private String groupNameAttr;
    private String ldapCtxFactoryClassName;
    private String posixUidAttr;
    private String posixGidAttr;
    private boolean isPosix;
    public static int RECONNECT_RETRY_COUNT;

    @Override
    public synchronized List<String> getGroups(String user) throws IOException {
        ArrayList<String> emptyResults = new ArrayList<String>();
        try {
            return this.doGetGroups(user);
        }
        catch (CommunicationException e) {
            LOG.warn("Connection is closed, will try to reconnect");
        }
        catch (NamingException e) {
            LOG.warn("Exception trying to get groups for user " + user + ": " + e.getMessage());
            return emptyResults;
        }
        int retryCount = 0;
        while (retryCount++ < RECONNECT_RETRY_COUNT) {
            this.ctx = null;
            try {
                return this.doGetGroups(user);
            }
            catch (CommunicationException e) {
                LOG.warn("Connection being closed, reconnecting failed, retryCount = " + retryCount);
            }
            catch (NamingException e) {
                LOG.warn("Exception trying to get groups for user " + user + ":" + e.getMessage());
                return emptyResults;
            }
        }
        return emptyResults;
    }

    List<String> doGetGroups(String user) throws NamingException {
        ArrayList<String> groups = new ArrayList<String>();
        DirContext ctx = this.getDirContext();
        NamingEnumeration<SearchResult> results = ctx.search(this.baseDN, this.userSearchFilter, new Object[]{user}, SEARCH_CONTROLS);
        if (results.hasMoreElements()) {
            SearchResult result = (SearchResult)results.nextElement();
            String userDn = result.getNameInNamespace();
            NamingEnumeration<SearchResult> groupResults = null;
            if (this.isPosix) {
                String gidNumber = null;
                String uidNumber = null;
                Attribute gidAttribute = result.getAttributes().get(this.posixGidAttr);
                Attribute uidAttribute = result.getAttributes().get(this.posixUidAttr);
                if (gidAttribute != null) {
                    gidNumber = gidAttribute.get().toString();
                }
                if (uidAttribute != null) {
                    uidNumber = uidAttribute.get().toString();
                }
                if (uidNumber != null && gidNumber != null) {
                    groupResults = ctx.search(this.baseDN, "(&" + this.groupSearchFilter + "(|(" + this.posixGidAttr + "={0})(" + this.groupMemberAttr + "={1})))", new Object[]{gidNumber, uidNumber}, SEARCH_CONTROLS);
                }
            } else {
                groupResults = ctx.search(this.baseDN, "(&" + this.groupSearchFilter + "(" + this.groupMemberAttr + "={0}))", new Object[]{userDn}, SEARCH_CONTROLS);
            }
            if (groupResults != null) {
                while (groupResults.hasMoreElements()) {
                    SearchResult groupResult = (SearchResult)groupResults.nextElement();
                    Attribute groupName = groupResult.getAttributes().get(this.groupNameAttr);
                    groups.add(groupName.get().toString());
                }
            }
        }
        return groups;
    }

    DirContext getDirContext() throws NamingException {
        if (this.ctx == null) {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", this.ldapCtxFactoryClassName);
            env.put("java.naming.provider.url", this.ldapUrl);
            env.put("java.naming.security.authentication", "simple");
            if (this.useSsl) {
                env.put("java.naming.security.protocol", "ssl");
                LdapSslSocketFactory.setConfigurations(this.keystore, this.keystorePass, this.truststore, this.truststorePass);
                env.put(LDAP_SOCKET_FACTORY_ENV_KEY, LdapSslSocketFactory.class.getName());
            }
            env.put("java.naming.security.principal", this.bindUser);
            env.put("java.naming.security.credentials", this.bindPassword);
            env.put("com.sun.jndi.ldap.connect.timeout", this.conf.get(CONNECTION_TIMEOUT, String.valueOf(60000)));
            env.put("com.sun.jndi.ldap.read.timeout", this.conf.get(READ_TIMEOUT, String.valueOf(60000)));
            this.ctx = new InitialDirContext(env);
        }
        return this.ctx;
    }

    @Override
    public void cacheGroupsRefresh() throws IOException {
    }

    @Override
    public void cacheGroupsAdd(List<String> groups) throws IOException {
    }

    @Override
    public synchronized Configuration getConf() {
        return this.conf;
    }

    @Override
    public synchronized void setConf(Configuration conf) {
        this.ldapUrl = conf.get(LDAP_URL_KEY, "");
        if (this.ldapUrl == null || this.ldapUrl.isEmpty()) {
            throw new RuntimeException("LDAP URL is not configured");
        }
        this.useSsl = conf.getBoolean(LDAP_USE_SSL_KEY, LDAP_USE_SSL_DEFAULT);
        if (this.useSsl) {
            this.loadSslConf(conf);
        }
        this.bindUser = conf.get(BIND_USER_KEY, "");
        this.bindPassword = this.getPassword(conf, BIND_PASSWORD_KEY, "");
        if (this.bindPassword.isEmpty()) {
            this.bindPassword = this.extractPassword(conf.get(BIND_PASSWORD_FILE_KEY, ""));
        }
        this.baseDN = conf.get(BASE_DN_KEY, "");
        this.groupSearchFilter = conf.get(GROUP_SEARCH_FILTER_KEY, GROUP_SEARCH_FILTER_DEFAULT);
        this.userSearchFilter = conf.get(USER_SEARCH_FILTER_KEY, USER_SEARCH_FILTER_DEFAULT);
        this.isPosix = this.groupSearchFilter.contains(POSIX_GROUP) && this.userSearchFilter.contains(POSIX_ACCOUNT);
        this.groupMemberAttr = conf.get(GROUP_MEMBERSHIP_ATTR_KEY, GROUP_MEMBERSHIP_ATTR_DEFAULT);
        this.groupNameAttr = conf.get(GROUP_NAME_ATTR_KEY, GROUP_NAME_ATTR_DEFAULT);
        this.posixUidAttr = conf.get(POSIX_UID_ATTR_KEY, POSIX_UID_ATTR_DEFAULT);
        this.posixGidAttr = conf.get(POSIX_GID_ATTR_KEY, POSIX_GID_ATTR_DEFAULT);
        int dirSearchTimeout = conf.getInt(DIRECTORY_SEARCH_TIMEOUT, 10000);
        SEARCH_CONTROLS.setTimeLimit(dirSearchTimeout);
        SEARCH_CONTROLS.setReturningAttributes(new String[]{this.groupNameAttr, this.posixUidAttr, this.posixGidAttr});
        Class<InitialContextFactory> ldapCtxFactoryClass = conf.getClass(LDAP_CTX_FACTORY_CLASS_KEY, null, InitialContextFactory.class);
        this.ldapCtxFactoryClassName = ldapCtxFactoryClass != null ? ldapCtxFactoryClass.getName() : LDAP_CTX_FACTORY_CLASS_DEFAULT;
        this.conf = conf;
    }

    private void loadSslConf(Configuration sslConf) {
        this.keystore = sslConf.get(LDAP_KEYSTORE_KEY, "");
        this.keystorePass = this.getPassword(sslConf, LDAP_KEYSTORE_PASSWORD_KEY, "");
        if (this.keystorePass.isEmpty()) {
            this.keystorePass = this.extractPassword(sslConf.get(LDAP_KEYSTORE_PASSWORD_FILE_KEY, ""));
        }
        this.truststore = sslConf.get(LDAP_TRUSTSTORE_KEY, "");
        this.truststorePass = this.getPasswordFromCredentialProviders(sslConf, LDAP_TRUSTSTORE_PASSWORD_KEY, "");
        if (this.truststorePass.isEmpty()) {
            this.truststorePass = this.extractPassword(sslConf.get(LDAP_TRUSTSTORE_PASSWORD_FILE_KEY, ""));
        }
    }

    String getPasswordFromCredentialProviders(Configuration conf, String alias, String defaultPass) {
        String password = defaultPass;
        try {
            char[] passchars = conf.getPasswordFromCredentialProviders(alias);
            if (passchars != null) {
                password = new String(passchars);
            }
        }
        catch (IOException ioe) {
            LOG.warn("Exception while trying to get password for alias " + alias + ": ", (Throwable)ioe);
        }
        return password;
    }

    @Deprecated
    String getPassword(Configuration conf, String alias, String defaultPass) {
        String password = null;
        try {
            char[] passchars = conf.getPassword(alias);
            password = passchars != null ? new String(passchars) : defaultPass;
        }
        catch (IOException ioe) {
            LOG.warn("Exception while trying to password for alias " + alias + ": " + ioe.getMessage());
        }
        return password;
    }

    String extractPassword(String pwFile) {
        String string;
        if (pwFile.isEmpty()) {
            return "";
        }
        StringBuilder password = new StringBuilder();
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(pwFile), Charsets.UTF_8);
        try {
            int c = ((Reader)reader).read();
            while (c > -1) {
                password.append((char)c);
                c = ((Reader)reader).read();
            }
            string = password.toString().trim();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                throw new RuntimeException("Could not read password file: " + pwFile, ioe);
            }
        }
        ((Reader)reader).close();
        return string;
    }

    static {
        SEARCH_CONTROLS.setSearchScope(2);
        RECONNECT_RETRY_COUNT = 3;
    }

    @InterfaceAudience.Private
    public static class LdapSslSocketFactory
    extends SocketFactory {
        private static LdapSslSocketFactory defaultSslFactory;
        private static String keyStoreLocation;
        private static String keyStorePassword;
        private static String trustStoreLocation;
        private static String trustStorePassword;
        private final SSLSocketFactory socketFactory;

        LdapSslSocketFactory(SSLSocketFactory wrappedSocketFactory) {
            this.socketFactory = wrappedSocketFactory;
        }

        public static synchronized SocketFactory getDefault() {
            if (defaultSslFactory == null) {
                try {
                    SSLContext context = SSLContext.getInstance("TLS");
                    context.init(LdapSslSocketFactory.createKeyManagers(), LdapSslSocketFactory.createTrustManagers(), null);
                    defaultSslFactory = new LdapSslSocketFactory(context.getSocketFactory());
                    LOG.info("Successfully instantiated LdapSslSocketFactory with keyStoreLocation = {} and trustStoreLocation = {}", (Object)keyStoreLocation, (Object)trustStoreLocation);
                }
                catch (IOException | GeneralSecurityException e) {
                    throw new RuntimeException("Unable to create SSLSocketFactory", e);
                }
            }
            return defaultSslFactory;
        }

        static synchronized void setConfigurations(String newKeyStoreLocation, String newKeyStorePassword, String newTrustStoreLocation, String newTrustStorePassword) {
            keyStoreLocation = newKeyStoreLocation;
            keyStorePassword = newKeyStorePassword;
            trustStoreLocation = newTrustStoreLocation;
            trustStorePassword = newTrustStorePassword;
        }

        private static KeyManager[] createKeyManagers() throws IOException, GeneralSecurityException {
            if (keyStoreLocation.isEmpty()) {
                return null;
            }
            KeyManagerFactory keyMgrFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyMgrFactory.init(LdapSslSocketFactory.createKeyStore(keyStoreLocation, keyStorePassword), LdapSslSocketFactory.getPasswordCharArray(keyStorePassword));
            return keyMgrFactory.getKeyManagers();
        }

        private static TrustManager[] createTrustManagers() throws IOException, GeneralSecurityException {
            if (trustStoreLocation.isEmpty()) {
                return null;
            }
            TrustManagerFactory trustMgrFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustMgrFactory.init(LdapSslSocketFactory.createKeyStore(trustStoreLocation, trustStorePassword));
            return trustMgrFactory.getTrustManagers();
        }

        private static KeyStore createKeyStore(String location, String password) throws IOException, GeneralSecurityException {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            try (FileInputStream keyStoreInput = new FileInputStream(location);){
                keyStore.load(keyStoreInput, LdapSslSocketFactory.getPasswordCharArray(password));
            }
            return keyStore;
        }

        private static char[] getPasswordCharArray(String password) {
            if (password == null || password.isEmpty()) {
                return null;
            }
            return password.toCharArray();
        }

        @Override
        public Socket createSocket() throws IOException {
            return this.socketFactory.createSocket();
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException {
            return this.socketFactory.createSocket(host, port);
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
            return this.socketFactory.createSocket(host, port, localHost, localPort);
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            return this.socketFactory.createSocket(host, port);
        }

        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            return this.socketFactory.createSocket(address, port, localAddress, localPort);
        }
    }
}

