/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.lib;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.MutableGauge;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class MutableGaugeDouble
extends MutableGauge {
    private Double value = new Double(0.0);

    MutableGaugeDouble(MetricsInfo info, double doubleValue) {
        super(info);
        this.value = doubleValue;
    }

    public synchronized double value() {
        return this.value;
    }

    @Override
    public synchronized void incr() {
        this.value = this.value + 1.0;
    }

    public synchronized void incr(double delta) {
        this.value = this.value + delta;
        this.setChanged();
    }

    @Override
    public synchronized void decr() {
        this.value = this.value - 1.0;
    }

    public synchronized void decr(double delta) {
        this.value = this.value - delta;
        this.setChanged();
    }

    public synchronized void set(double value) {
        this.value = value;
        this.setChanged();
    }

    @Override
    public synchronized void snapshot(MetricsRecordBuilder builder, boolean all) {
        if (all || this.changed()) {
            builder.addGauge(this.info(), this.value());
            this.clearChanged();
        }
    }
}

