/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics.util;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.util.MetricsBase;
import org.apache.hadoop.metrics.util.MetricsRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
public class MetricsTimeVaryingLong
extends MetricsBase {
    private static final Logger LOG = LoggerFactory.getLogger((String)"org.apache.hadoop.metrics.util");
    private long currentValue = 0L;
    private long previousIntervalValue = 0L;

    public MetricsTimeVaryingLong(String nam, MetricsRegistry registry, String description) {
        super(nam, description);
        registry.add(nam, this);
    }

    public MetricsTimeVaryingLong(String nam, MetricsRegistry registry) {
        this(nam, registry, "NoDescription");
    }

    public synchronized void inc(long incr) {
        this.currentValue += incr;
    }

    public synchronized void inc() {
        ++this.currentValue;
    }

    private synchronized void intervalHeartBeat() {
        this.previousIntervalValue = this.currentValue;
        this.currentValue = 0L;
    }

    @Override
    public synchronized void pushMetric(MetricsRecord mr) {
        this.intervalHeartBeat();
        try {
            mr.incrMetric(this.getName(), this.getPreviousIntervalValue());
        }
        catch (Exception e) {
            LOG.info("pushMetric failed for " + this.getName() + "\n", (Throwable)e);
        }
    }

    public synchronized long getPreviousIntervalValue() {
        return this.previousIntervalValue;
    }

    public synchronized long getCurrentIntervalValue() {
        return this.currentValue;
    }
}

