/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics.spi;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.metrics.ContextFactory;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.metrics.Updater;
import org.apache.hadoop.metrics.spi.AbstractMetricsContext;
import org.apache.hadoop.metrics.spi.OutputRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class CompositeContext
extends AbstractMetricsContext {
    private static final Logger LOG = LoggerFactory.getLogger(CompositeContext.class);
    private static final String ARITY_LABEL = "arity";
    private static final String SUB_FMT = "%s.sub%d";
    private final ArrayList<MetricsContext> subctxt = new ArrayList();

    @InterfaceAudience.Private
    public CompositeContext() {
    }

    @Override
    @InterfaceAudience.Private
    public void init(String contextName, ContextFactory factory) {
        int nKids;
        super.init(contextName, factory);
        try {
            String sKids = this.getAttribute(ARITY_LABEL);
            nKids = Integer.parseInt(sKids);
        }
        catch (Exception e) {
            LOG.error("Unable to initialize composite metric " + contextName + ": could not init arity", (Throwable)e);
            return;
        }
        for (int i = 0; i < nKids; ++i) {
            MetricsContext ctxt = MetricsUtil.getContext(String.format(SUB_FMT, contextName, i), contextName);
            if (null == ctxt) continue;
            this.subctxt.add(ctxt);
        }
    }

    @Override
    @InterfaceAudience.Private
    public MetricsRecord newRecord(String recordName) {
        return (MetricsRecord)Proxy.newProxyInstance(MetricsRecord.class.getClassLoader(), new Class[]{MetricsRecord.class}, (InvocationHandler)new MetricsRecordDelegator(recordName, this.subctxt));
    }

    @Override
    @InterfaceAudience.Private
    protected void emitRecord(String contextName, String recordName, OutputRecord outRec) throws IOException {
        for (MetricsContext ctxt : this.subctxt) {
            try {
                ((AbstractMetricsContext)ctxt).emitRecord(contextName, recordName, outRec);
                if (contextName != null && recordName != null && outRec != null) continue;
                throw new IOException(contextName + ":" + recordName + ":" + outRec);
            }
            catch (IOException e) {
                LOG.warn("emitRecord failed: " + ctxt.getContextName(), (Throwable)e);
            }
        }
    }

    @Override
    @InterfaceAudience.Private
    protected void flush() throws IOException {
        for (MetricsContext ctxt : this.subctxt) {
            try {
                ((AbstractMetricsContext)ctxt).flush();
            }
            catch (IOException e) {
                LOG.warn("flush failed: " + ctxt.getContextName(), (Throwable)e);
            }
        }
    }

    @Override
    @InterfaceAudience.Private
    public void startMonitoring() throws IOException {
        for (MetricsContext ctxt : this.subctxt) {
            try {
                ctxt.startMonitoring();
            }
            catch (IOException e) {
                LOG.warn("startMonitoring failed: " + ctxt.getContextName(), (Throwable)e);
            }
        }
    }

    @Override
    @InterfaceAudience.Private
    public void stopMonitoring() {
        for (MetricsContext ctxt : this.subctxt) {
            ctxt.stopMonitoring();
        }
    }

    @Override
    @InterfaceAudience.Private
    public boolean isMonitoring() {
        boolean ret = true;
        for (MetricsContext ctxt : this.subctxt) {
            ret &= ctxt.isMonitoring();
        }
        return ret;
    }

    @Override
    @InterfaceAudience.Private
    public void close() {
        for (MetricsContext ctxt : this.subctxt) {
            ctxt.close();
        }
    }

    @Override
    @InterfaceAudience.Private
    public void registerUpdater(Updater updater) {
        for (MetricsContext ctxt : this.subctxt) {
            ctxt.registerUpdater(updater);
        }
    }

    @Override
    @InterfaceAudience.Private
    public void unregisterUpdater(Updater updater) {
        for (MetricsContext ctxt : this.subctxt) {
            ctxt.unregisterUpdater(updater);
        }
    }

    private static class MetricsRecordDelegator
    implements InvocationHandler {
        private static final Method m_getRecordName = MetricsRecordDelegator.initMethod();
        private final String recordName;
        private final ArrayList<MetricsRecord> subrecs;

        private static Method initMethod() {
            try {
                return MetricsRecord.class.getMethod("getRecordName", new Class[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Internal error", e);
            }
        }

        MetricsRecordDelegator(String recordName, ArrayList<MetricsContext> ctxts) {
            this.recordName = recordName;
            this.subrecs = new ArrayList(ctxts.size());
            for (MetricsContext ctxt : ctxts) {
                this.subrecs.add(ctxt.createRecord(recordName));
            }
        }

        @Override
        public Object invoke(Object p, Method m, Object[] args) throws Throwable {
            if (m_getRecordName.equals(m)) {
                return this.recordName;
            }
            assert (Void.TYPE.equals(m.getReturnType()));
            for (MetricsRecord rec : this.subrecs) {
                m.invoke((Object)rec, args);
            }
            return null;
        }
    }
}

