/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FSLinkResolver;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnresolvedLinkException;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class FileSystemLinkResolver<T> {
    public abstract T doCall(Path var1) throws IOException, UnresolvedLinkException;

    public abstract T next(FileSystem var1, Path var2) throws IOException;

    public T resolve(FileSystem filesys, Path path) throws IOException {
        int count = 0;
        T in = null;
        Path p = path;
        FileSystem fs = filesys;
        boolean isLink = true;
        while (isLink) {
            try {
                in = this.doCall(p);
                isLink = false;
            }
            catch (UnresolvedLinkException e) {
                if (!filesys.resolveSymlinks) {
                    throw new IOException("Path " + path + " contains a symlink and symlink resolution is disabled (fs.client.resolve.remote.symlinks).", e);
                }
                if (!FileSystem.areSymlinksEnabled()) {
                    throw new IOException("Symlink resolution is disabled in this version of Hadoop.");
                }
                if (count++ > 32) {
                    throw new IOException("Possible cyclic loop while following symbolic link " + path);
                }
                p = FSLinkResolver.qualifySymlinkTarget(fs.getUri(), p, filesys.resolveLink(p));
                if ((fs = FileSystem.getFSofPath(p, filesys.getConf())).equals(filesys)) continue;
                return this.next(fs, p);
            }
        }
        return in;
    }
}

