/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.ByteArrayInputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.EnumMap;
import org.apache.hadoop.hdfs.server.namenode.EditLogFileInputStream;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputStream;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOpCodes;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.server.namenode.TestEditLog;
import org.apache.hadoop.hdfs.util.Holder;
import org.apache.hadoop.hdfs.web.URLConnectionFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestEditLogFileInputStream {
    private static final byte[] FAKE_LOG_DATA = TestEditLog.HADOOP20_SOME_EDITS;

    @Test
    public void testReadURL() throws Exception {
        HttpURLConnection conn = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
        ((HttpURLConnection)Mockito.doReturn((Object)new ByteArrayInputStream(FAKE_LOG_DATA)).when((Object)conn)).getInputStream();
        ((HttpURLConnection)Mockito.doReturn((Object)200).when((Object)conn)).getResponseCode();
        ((HttpURLConnection)Mockito.doReturn((Object)Integer.toString(FAKE_LOG_DATA.length)).when((Object)conn)).getHeaderField("Content-Length");
        URLConnectionFactory factory = (URLConnectionFactory)Mockito.mock(URLConnectionFactory.class);
        ((URLConnectionFactory)Mockito.doReturn((Object)conn).when((Object)factory)).openConnection((URL)Mockito.any(), Matchers.anyBoolean());
        URL url = new URL("http://localhost/fakeLog");
        EditLogInputStream elis = EditLogFileInputStream.fromUrl((URLConnectionFactory)factory, (URL)url, (long)-12345L, (long)-12345L, (boolean)false);
        EnumMap<FSEditLogOpCodes, Holder<Integer>> counts = FSImageTestUtil.countEditLogOpTypes(elis);
        Assert.assertThat((Object)((Integer)counts.get((Object)FSEditLogOpCodes.OP_ADD).held), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((Integer)counts.get((Object)FSEditLogOpCodes.OP_SET_GENSTAMP_V1).held), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((Integer)counts.get((Object)FSEditLogOpCodes.OP_CLOSE).held), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertEquals((long)FAKE_LOG_DATA.length, (long)elis.length());
        elis.close();
    }
}

