/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.CorruptReplicasMap;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCorruptReplicaInfo {
    private static final Logger LOG = LoggerFactory.getLogger(TestCorruptReplicaInfo.class);
    private final Map<Long, Block> block_map = new HashMap<Long, Block>();

    private Block getBlock(Long block_id) {
        if (!this.block_map.containsKey(block_id)) {
            this.block_map.put(block_id, new Block(block_id.longValue(), 0L, 0L));
        }
        return this.block_map.get(block_id);
    }

    private Block getBlock(int block_id) {
        return this.getBlock(Long.valueOf(block_id));
    }

    @Test
    public void testCorruptReplicaInfo() throws IOException, InterruptedException {
        CorruptReplicasMap crm = new CorruptReplicasMap();
        Assert.assertEquals((String)"Number of corrupt blocks must initially be 0", (long)0L, (long)crm.size());
        Assert.assertNull((String)"Param n cannot be less than 0", (Object)crm.getCorruptReplicaBlockIds(-1, null));
        Assert.assertNull((String)"Param n cannot be greater than 100", (Object)crm.getCorruptReplicaBlockIds(101, null));
        long[] l = crm.getCorruptReplicaBlockIds(0, null);
        Assert.assertNotNull((String)"n = 0 must return non-null", (Object)l);
        Assert.assertEquals((String)"n = 0 must return an empty list", (long)0L, (long)l.length);
        int NUM_BLOCK_IDS = 140;
        LinkedList<Long> block_ids = new LinkedList<Long>();
        for (int i = 0; i < NUM_BLOCK_IDS; ++i) {
            block_ids.add(Long.valueOf(i));
        }
        DatanodeDescriptor dn1 = DFSTestUtil.getLocalDatanodeDescriptor();
        DatanodeDescriptor dn2 = DFSTestUtil.getLocalDatanodeDescriptor();
        TestCorruptReplicaInfo.addToCorruptReplicasMap(crm, this.getBlock(0), dn1);
        Assert.assertEquals((String)"Number of corrupt blocks not returning correctly", (long)1L, (long)crm.size());
        TestCorruptReplicaInfo.addToCorruptReplicasMap(crm, this.getBlock(1), dn1);
        Assert.assertEquals((String)"Number of corrupt blocks not returning correctly", (long)2L, (long)crm.size());
        TestCorruptReplicaInfo.addToCorruptReplicasMap(crm, this.getBlock(1), dn2);
        Assert.assertEquals((String)"Number of corrupt blocks not returning correctly", (long)2L, (long)crm.size());
        crm.removeFromCorruptReplicasMap(this.getBlock(1));
        Assert.assertEquals((String)"Number of corrupt blocks not returning correctly", (long)1L, (long)crm.size());
        crm.removeFromCorruptReplicasMap(this.getBlock(0));
        Assert.assertEquals((String)"Number of corrupt blocks not returning correctly", (long)0L, (long)crm.size());
        for (Long block_id : block_ids) {
            TestCorruptReplicaInfo.addToCorruptReplicasMap(crm, this.getBlock(block_id), dn1);
        }
        Assert.assertEquals((String)"Number of corrupt blocks not returning correctly", (long)NUM_BLOCK_IDS, (long)crm.size());
        Assert.assertTrue((String)"First five block ids not returned correctly ", (boolean)Arrays.equals(new long[]{0L, 1L, 2L, 3L, 4L}, crm.getCorruptReplicaBlockIds(5, null)));
        LOG.info(Arrays.toString(crm.getCorruptReplicaBlockIds(10, Long.valueOf(7L))));
        LOG.info(block_ids.subList(7, 18).toString());
        Assert.assertTrue((String)"10 blocks after 7 not returned correctly ", (boolean)Arrays.equals(new long[]{8L, 9L, 10L, 11L, 12L, 13L, 14L, 15L, 16L, 17L}, crm.getCorruptReplicaBlockIds(10, Long.valueOf(7L))));
    }

    private static void addToCorruptReplicasMap(CorruptReplicasMap crm, Block blk, DatanodeDescriptor dn) {
        crm.addToCorruptReplicasMap(blk, dn, "TEST", CorruptReplicasMap.Reason.NONE);
    }
}

