/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.security;

import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSecretManager;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SaslInputStream;
import org.apache.hadoop.security.SaslRpcClient;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestClientProtocolWithDelegationToken {
    private static final String ADDRESS = "0.0.0.0";
    public static final Logger LOG = LoggerFactory.getLogger(TestClientProtocolWithDelegationToken.class);
    private static final Configuration conf = new Configuration();

    @Test
    public void testDelegationTokenRpc() throws Exception {
        ClientProtocol mockNN = (ClientProtocol)Mockito.mock(ClientProtocol.class);
        FSNamesystem mockNameSys = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        DelegationTokenSecretManager sm = new DelegationTokenSecretManager(86400000L, 86400000L, 604800000L, 3600000L, mockNameSys);
        sm.startThreads();
        RPC.Server server = new RPC.Builder(conf).setProtocol(ClientProtocol.class).setInstance((Object)mockNN).setBindAddress(ADDRESS).setPort(0).setNumHandlers(5).setVerbose(true).setSecretManager((SecretManager)sm).build();
        server.start();
        UserGroupInformation current = UserGroupInformation.getCurrentUser();
        final InetSocketAddress addr = NetUtils.getConnectAddress((Server)server);
        String user = current.getUserName();
        Text owner = new Text(user);
        DelegationTokenIdentifier dtId = new DelegationTokenIdentifier(owner, owner, null);
        Token token = new Token((TokenIdentifier)dtId, (SecretManager)sm);
        SecurityUtil.setTokenService((Token)token, (InetSocketAddress)addr);
        LOG.info("Service for token is " + token.getService());
        current.addToken(token);
        current.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>((Server)server){
            final /* synthetic */ Server val$server;
            {
                this.val$server = server;
            }

            @Override
            public Object run() throws Exception {
                ClientProtocol proxy = null;
                try {
                    proxy = (ClientProtocol)RPC.getProxy(ClientProtocol.class, (long)69L, (InetSocketAddress)addr, (Configuration)conf);
                    proxy.getServerDefaults();
                }
                finally {
                    this.val$server.stop();
                    if (proxy != null) {
                        RPC.stopProxy((Object)proxy);
                    }
                }
                return null;
            }
        });
    }

    static {
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        GenericTestUtils.setLogLevel((Logger)Client.LOG, (Level)Level.TRACE);
        GenericTestUtils.setLogLevel((Logger)Server.LOG, (Level)Level.TRACE);
        GenericTestUtils.setLogLevel((Logger)SaslRpcClient.LOG, (Level)Level.TRACE);
        GenericTestUtils.setLogLevel((Logger)SaslRpcServer.LOG, (Level)Level.TRACE);
        GenericTestUtils.setLogLevel((Logger)SaslInputStream.LOG, (Level)Level.TRACE);
    }
}

