/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSClientAdapter;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.datatransfer.TrustedChannelResolver;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.DataTransferSaslUtil;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.SaslDataTransferServer;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenSecretManager;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

@RunWith(value=Parameterized.class)
public class TestEncryptedTransfer {
    private static final Logger LOG = LoggerFactory.getLogger(TestEncryptedTransfer.class);
    private static final String PLAIN_TEXT = "this is very secret plain text";
    private static final Path TEST_PATH = new Path("/non-encrypted-file");
    String resolverClazz;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        params.add(new Object[]{null});
        params.add(new Object[]{"org.apache.hadoop.hdfs.TestEncryptedTransfer$TestTrustedChannelResolver"});
        return params;
    }

    private void setEncryptionConfigKeys(Configuration conf) {
        conf.setBoolean("dfs.encrypt.data.transfer", true);
        conf.setBoolean("dfs.block.access.token.enable", true);
        if (this.resolverClazz != null) {
            conf.set("dfs.trustedchannel.resolver.class", this.resolverClazz);
        }
    }

    private static FileSystem getFileSystem(Configuration conf) throws IOException {
        Configuration localConf = new Configuration(conf);
        localConf.setBoolean("dfs.encrypt.data.transfer", false);
        localConf.unset("dfs.encrypt.data.transfer.algorithm");
        return FileSystem.get((Configuration)localConf);
    }

    public TestEncryptedTransfer(String resolverClazz) {
        GenericTestUtils.setLogLevel((Logger)LoggerFactory.getLogger(SaslDataTransferServer.class), (Level)Level.DEBUG);
        GenericTestUtils.setLogLevel((Logger)LoggerFactory.getLogger(DataTransferSaslUtil.class), (Level)Level.DEBUG);
        this.resolverClazz = resolverClazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEncryptedRead() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            cluster = new MiniDFSCluster.Builder(conf).build();
            FileSystem fs = TestEncryptedTransfer.getFileSystem(conf);
            TestEncryptedTransfer.writeTestDataToFile(fs);
            Assert.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(fs, TEST_PATH));
            FileChecksum checksum = fs.getFileChecksum(TEST_PATH);
            fs.close();
            cluster.shutdown();
            this.setEncryptionConfigKeys(conf);
            cluster = new MiniDFSCluster.Builder(conf).manageDataDfsDirs(false).manageNameDfsDirs(false).format(false).startupOption(HdfsServerConstants.StartupOption.REGULAR).build();
            fs = TestEncryptedTransfer.getFileSystem(conf);
            GenericTestUtils.LogCapturer logs = GenericTestUtils.LogCapturer.captureLogs((Logger)LoggerFactory.getLogger(SaslDataTransferServer.class));
            GenericTestUtils.LogCapturer logs1 = GenericTestUtils.LogCapturer.captureLogs((Logger)LoggerFactory.getLogger(DataTransferSaslUtil.class));
            try {
                Assert.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(fs, TEST_PATH));
                Assert.assertEquals((Object)checksum, (Object)fs.getFileChecksum(TEST_PATH));
            }
            finally {
                logs.stopCapturing();
                logs1.stopCapturing();
            }
            fs.close();
            if (this.resolverClazz == null) {
                GenericTestUtils.assertDoesNotMatch((String)logs.getOutput(), (String)"Server using cipher suite");
                GenericTestUtils.assertDoesNotMatch((String)logs1.getOutput(), (String)"Creating IOStreamPair of CryptoInputStream and CryptoOutputStream.");
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEncryptedReadWithRC4() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            cluster = new MiniDFSCluster.Builder(conf).build();
            FileSystem fs = TestEncryptedTransfer.getFileSystem(conf);
            TestEncryptedTransfer.writeTestDataToFile(fs);
            Assert.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(fs, TEST_PATH));
            FileChecksum checksum = fs.getFileChecksum(TEST_PATH);
            fs.close();
            cluster.shutdown();
            this.setEncryptionConfigKeys(conf);
            conf.set("dfs.encrypt.data.transfer.algorithm", "rc4");
            cluster = new MiniDFSCluster.Builder(conf).manageDataDfsDirs(false).manageNameDfsDirs(false).format(false).startupOption(HdfsServerConstants.StartupOption.REGULAR).build();
            fs = TestEncryptedTransfer.getFileSystem(conf);
            GenericTestUtils.LogCapturer logs = GenericTestUtils.LogCapturer.captureLogs((Logger)LoggerFactory.getLogger(SaslDataTransferServer.class));
            GenericTestUtils.LogCapturer logs1 = GenericTestUtils.LogCapturer.captureLogs((Logger)LoggerFactory.getLogger(DataTransferSaslUtil.class));
            try {
                Assert.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(fs, TEST_PATH));
                Assert.assertEquals((Object)checksum, (Object)fs.getFileChecksum(TEST_PATH));
            }
            finally {
                logs.stopCapturing();
                logs1.stopCapturing();
            }
            fs.close();
            if (this.resolverClazz == null) {
                GenericTestUtils.assertDoesNotMatch((String)logs.getOutput(), (String)"Server using cipher suite");
                GenericTestUtils.assertDoesNotMatch((String)logs1.getOutput(), (String)"Creating IOStreamPair of CryptoInputStream and CryptoOutputStream.");
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEncryptedReadWithAES() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            conf.set("dfs.encrypt.data.transfer.cipher.suites", "AES/CTR/NoPadding");
            cluster = new MiniDFSCluster.Builder(conf).build();
            FileSystem fs = TestEncryptedTransfer.getFileSystem(conf);
            TestEncryptedTransfer.writeTestDataToFile(fs);
            Assert.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(fs, TEST_PATH));
            FileChecksum checksum = fs.getFileChecksum(TEST_PATH);
            fs.close();
            cluster.shutdown();
            this.setEncryptionConfigKeys(conf);
            cluster = new MiniDFSCluster.Builder(conf).manageDataDfsDirs(false).manageNameDfsDirs(false).format(false).startupOption(HdfsServerConstants.StartupOption.REGULAR).build();
            fs = TestEncryptedTransfer.getFileSystem(conf);
            GenericTestUtils.LogCapturer logs = GenericTestUtils.LogCapturer.captureLogs((Logger)LoggerFactory.getLogger(SaslDataTransferServer.class));
            GenericTestUtils.LogCapturer logs1 = GenericTestUtils.LogCapturer.captureLogs((Logger)LoggerFactory.getLogger(DataTransferSaslUtil.class));
            try {
                Assert.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(fs, TEST_PATH));
                Assert.assertEquals((Object)checksum, (Object)fs.getFileChecksum(TEST_PATH));
            }
            finally {
                logs.stopCapturing();
                logs1.stopCapturing();
            }
            fs.close();
            if (this.resolverClazz == null) {
                GenericTestUtils.assertMatches((String)logs.getOutput(), (String)"Server using cipher suite");
                GenericTestUtils.assertMatches((String)logs1.getOutput(), (String)"Creating IOStreamPair of CryptoInputStream and CryptoOutputStream.");
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEncryptedReadAfterNameNodeRestart() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            cluster = new MiniDFSCluster.Builder(conf).build();
            FileSystem fs = TestEncryptedTransfer.getFileSystem(conf);
            TestEncryptedTransfer.writeTestDataToFile(fs);
            Assert.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(fs, TEST_PATH));
            FileChecksum checksum = fs.getFileChecksum(TEST_PATH);
            fs.close();
            cluster.shutdown();
            this.setEncryptionConfigKeys(conf);
            cluster = new MiniDFSCluster.Builder(conf).manageDataDfsDirs(false).manageNameDfsDirs(false).format(false).startupOption(HdfsServerConstants.StartupOption.REGULAR).build();
            fs = TestEncryptedTransfer.getFileSystem(conf);
            Assert.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(fs, TEST_PATH));
            Assert.assertEquals((Object)checksum, (Object)fs.getFileChecksum(TEST_PATH));
            fs.close();
            cluster.restartNameNode(new String[0]);
            fs = TestEncryptedTransfer.getFileSystem(conf);
            Assert.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(fs, TEST_PATH));
            Assert.assertEquals((Object)checksum, (Object)fs.getFileChecksum(TEST_PATH));
            fs.close();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientThatDoesNotSupportEncryption() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            conf.setInt("dfs.client.retry.window.base", 10);
            cluster = new MiniDFSCluster.Builder(conf).build();
            FileSystem fs = TestEncryptedTransfer.getFileSystem(conf);
            TestEncryptedTransfer.writeTestDataToFile(fs);
            Assert.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(fs, TEST_PATH));
            fs.close();
            cluster.shutdown();
            this.setEncryptionConfigKeys(conf);
            cluster = new MiniDFSCluster.Builder(conf).manageDataDfsDirs(false).manageNameDfsDirs(false).format(false).startupOption(HdfsServerConstants.StartupOption.REGULAR).build();
            fs = TestEncryptedTransfer.getFileSystem(conf);
            DFSClient client = DFSClientAdapter.getDFSClient((DistributedFileSystem)fs);
            DFSClient spyClient = (DFSClient)Mockito.spy((Object)client);
            ((DFSClient)Mockito.doReturn((Object)false).when((Object)spyClient)).shouldEncryptData();
            DFSClientAdapter.setDFSClient((DistributedFileSystem)fs, spyClient);
            GenericTestUtils.LogCapturer logs = GenericTestUtils.LogCapturer.captureLogs((Logger)LoggerFactory.getLogger(DataNode.class));
            try {
                Assert.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(fs, TEST_PATH));
                if (this.resolverClazz != null && !this.resolverClazz.endsWith("TestTrustedChannelResolver")) {
                    Assert.fail((String)"Should not have been able to read without encryption enabled.");
                }
            }
            catch (IOException ioe) {
                GenericTestUtils.assertExceptionContains((String)"Could not obtain block:", (Throwable)ioe);
            }
            finally {
                logs.stopCapturing();
            }
            fs.close();
            if (this.resolverClazz == null) {
                GenericTestUtils.assertMatches((String)logs.getOutput(), (String)"Failed to read expected encryption handshake from client at");
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLongLivedReadClientAfterRestart() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            cluster = new MiniDFSCluster.Builder(conf).build();
            FileSystem fs = TestEncryptedTransfer.getFileSystem(conf);
            TestEncryptedTransfer.writeTestDataToFile(fs);
            Assert.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(fs, TEST_PATH));
            FileChecksum checksum = fs.getFileChecksum(TEST_PATH);
            fs.close();
            cluster.shutdown();
            this.setEncryptionConfigKeys(conf);
            cluster = new MiniDFSCluster.Builder(conf).manageDataDfsDirs(false).manageNameDfsDirs(false).format(false).startupOption(HdfsServerConstants.StartupOption.REGULAR).build();
            fs = TestEncryptedTransfer.getFileSystem(conf);
            Assert.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(fs, TEST_PATH));
            Assert.assertEquals((Object)checksum, (Object)fs.getFileChecksum(TEST_PATH));
            cluster.restartNameNode(new String[0]);
            Assert.assertTrue((boolean)cluster.restartDataNode(0));
            Assert.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(fs, TEST_PATH));
            Assert.assertEquals((Object)checksum, (Object)fs.getFileChecksum(TEST_PATH));
            fs.close();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLongLivedWriteClientAfterRestart() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            this.setEncryptionConfigKeys(conf);
            cluster = new MiniDFSCluster.Builder(conf).build();
            FileSystem fs = TestEncryptedTransfer.getFileSystem(conf);
            TestEncryptedTransfer.writeTestDataToFile(fs);
            Assert.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(fs, TEST_PATH));
            cluster.restartNameNode(new String[0]);
            Assert.assertTrue((boolean)cluster.restartDataNodes());
            cluster.waitActive();
            TestEncryptedTransfer.writeTestDataToFile(fs);
            Assert.assertEquals((Object)"this is very secret plain textthis is very secret plain text", (Object)DFSTestUtil.readFile(fs, TEST_PATH));
            fs.close();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLongLivedClient() throws IOException, InterruptedException {
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            cluster = new MiniDFSCluster.Builder(conf).build();
            FileSystem fs = TestEncryptedTransfer.getFileSystem(conf);
            TestEncryptedTransfer.writeTestDataToFile(fs);
            Assert.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(fs, TEST_PATH));
            FileChecksum checksum = fs.getFileChecksum(TEST_PATH);
            fs.close();
            cluster.shutdown();
            this.setEncryptionConfigKeys(conf);
            cluster = new MiniDFSCluster.Builder(conf).manageDataDfsDirs(false).manageNameDfsDirs(false).format(false).startupOption(HdfsServerConstants.StartupOption.REGULAR).build();
            BlockTokenSecretManager btsm = cluster.getNamesystem().getBlockManager().getBlockTokenSecretManager();
            btsm.setKeyUpdateIntervalForTesting(2000L);
            btsm.setTokenLifetime(2000L);
            btsm.clearAllKeysForTesting();
            fs = TestEncryptedTransfer.getFileSystem(conf);
            Assert.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(fs, TEST_PATH));
            Assert.assertEquals((Object)checksum, (Object)fs.getFileChecksum(TEST_PATH));
            LOG.info("Sleeping so that encryption keys expire...");
            Thread.sleep(15000L);
            LOG.info("Done sleeping.");
            Assert.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(fs, TEST_PATH));
            Assert.assertEquals((Object)checksum, (Object)fs.getFileChecksum(TEST_PATH));
            fs.close();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testEncryptedWriteWithOneDn() throws IOException {
        this.testEncryptedWrite(1);
    }

    @Test
    public void testEncryptedWriteWithTwoDns() throws IOException {
        this.testEncryptedWrite(2);
    }

    @Test
    public void testEncryptedWriteWithMultipleDns() throws IOException {
        this.testEncryptedWrite(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testEncryptedWrite(int numDns) throws IOException {
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            this.setEncryptionConfigKeys(conf);
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(numDns).build();
            FileSystem fs = TestEncryptedTransfer.getFileSystem(conf);
            GenericTestUtils.LogCapturer logs = GenericTestUtils.LogCapturer.captureLogs((Logger)LoggerFactory.getLogger(SaslDataTransferServer.class));
            GenericTestUtils.LogCapturer logs1 = GenericTestUtils.LogCapturer.captureLogs((Logger)LoggerFactory.getLogger(DataTransferSaslUtil.class));
            try {
                TestEncryptedTransfer.writeTestDataToFile(fs);
            }
            finally {
                logs.stopCapturing();
                logs1.stopCapturing();
            }
            Assert.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(fs, TEST_PATH));
            fs.close();
            if (this.resolverClazz == null) {
                GenericTestUtils.assertDoesNotMatch((String)logs.getOutput(), (String)"Server using cipher suite");
                GenericTestUtils.assertDoesNotMatch((String)logs1.getOutput(), (String)"Creating IOStreamPair of CryptoInputStream and CryptoOutputStream.");
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEncryptedAppend() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            this.setEncryptionConfigKeys(conf);
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
            FileSystem fs = TestEncryptedTransfer.getFileSystem(conf);
            TestEncryptedTransfer.writeTestDataToFile(fs);
            Assert.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(fs, TEST_PATH));
            TestEncryptedTransfer.writeTestDataToFile(fs);
            Assert.assertEquals((Object)"this is very secret plain textthis is very secret plain text", (Object)DFSTestUtil.readFile(fs, TEST_PATH));
            fs.close();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEncryptedAppendRequiringBlockTransfer() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            this.setEncryptionConfigKeys(conf);
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(4).build();
            FileSystem fs = TestEncryptedTransfer.getFileSystem(conf);
            TestEncryptedTransfer.writeTestDataToFile(fs);
            Assert.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(fs, TEST_PATH));
            FSDataInputStream in = fs.open(TEST_PATH);
            List<LocatedBlock> locatedBlocks = DFSTestUtil.getAllBlocks(in);
            in.close();
            Assert.assertEquals((long)1L, (long)locatedBlocks.size());
            Assert.assertEquals((long)3L, (long)locatedBlocks.get(0).getLocations().length);
            DataNode dn = cluster.getDataNode(locatedBlocks.get(0).getLocations()[0].getIpcPort());
            dn.shutdown();
            TestEncryptedTransfer.writeTestDataToFile(fs);
            Assert.assertEquals((Object)"this is very secret plain textthis is very secret plain text", (Object)DFSTestUtil.readFile(fs, TEST_PATH));
            fs.close();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private static void writeTestDataToFile(FileSystem fs) throws IOException {
        FSDataOutputStream out = null;
        out = !fs.exists(TEST_PATH) ? fs.create(TEST_PATH) : fs.append(TEST_PATH);
        out.write(PLAIN_TEXT.getBytes());
        out.close();
    }

    static class TestTrustedChannelResolver
    extends TrustedChannelResolver {
        TestTrustedChannelResolver() {
        }

        public boolean isTrusted() {
            return true;
        }

        public boolean isTrusted(InetAddress peerAddress) {
            return true;
        }
    }
}

