/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.protocol.InterDatanodeProtocol;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class TestDatanodeDeath {
    static final int blockSize = 8192;
    static final int numBlocks = 2;
    static final int fileSize = 16385;
    static final int numDatanodes = 15;
    static final short replication = 3;
    final int numberOfFiles = 3;
    final int numThreads = 5;
    Workload[] workload;

    public TestDatanodeDeath() {
        DFSTestUtil.setNameNodeLogLevel(Level.TRACE);
        GenericTestUtils.setLogLevel((Logger)DataNode.LOG, (Level)Level.TRACE);
        GenericTestUtils.setLogLevel((Logger)DFSClient.LOG, (Level)Level.TRACE);
        GenericTestUtils.setLogLevel((Logger)InterDatanodeProtocol.LOG, (Level)Level.TRACE);
        this.numberOfFiles = 3;
        this.numThreads = 5;
        this.workload = null;
    }

    private static FSDataOutputStream createFile(FileSystem fileSys, Path name, short repl) throws IOException {
        FSDataOutputStream stm = fileSys.create(name, true, fileSys.getConf().getInt("io.file.buffer.size", 4096), repl, 8192L);
        return stm;
    }

    private static void writeFile(FSDataOutputStream stm, long seed) throws IOException {
        byte[] buffer = AppendTestUtil.randomBytes(seed, 16385);
        int mid = 8192;
        stm.write(buffer, 0, mid);
        stm.write(buffer, mid, 16385 - mid);
    }

    private static void checkFile(FileSystem fileSys, Path name, int repl, int numblocks, int filesize, long seed) throws IOException {
        boolean done = false;
        int attempt = 0;
        long len = fileSys.getFileStatus(name).getLen();
        Assert.assertTrue((String)(name + " should be of size " + filesize + " but found to be of size " + len), (len == (long)filesize ? 1 : 0) != 0);
        block2: while (!done) {
            ++attempt;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            done = true;
            BlockLocation[] locations = fileSys.getFileBlockLocations(fileSys.getFileStatus(name), 0L, (long)filesize);
            if (locations.length < numblocks) {
                if (attempt > 100) {
                    System.out.println("File " + name + " has only " + locations.length + " blocks,  but is expected to have " + numblocks + " blocks.");
                }
                done = false;
                continue;
            }
            for (int idx = 0; idx < locations.length; ++idx) {
                if (locations[idx].getHosts().length >= repl) continue;
                if (attempt > 100) {
                    System.out.println("File " + name + " has " + locations.length + " blocks:  The " + idx + " block has only " + locations[idx].getHosts().length + " replicas but is expected to have " + repl + " replicas.");
                }
                done = false;
                continue block2;
            }
        }
        FSDataInputStream stm = fileSys.open(name);
        byte[] expected = AppendTestUtil.randomBytes(seed, 16385);
        byte[] actual = new byte[filesize];
        stm.readFully(0L, actual);
        TestDatanodeDeath.checkData(actual, 0, expected, "Read 1");
    }

    private static void checkData(byte[] actual, int from, byte[] expected, String message) {
        for (int idx = 0; idx < actual.length; ++idx) {
            Assert.assertEquals((String)(message + " byte " + (from + idx) + " differs. expected " + expected[from + idx] + " actual " + actual[idx]), (long)actual[idx], (long)expected[from + idx]);
            actual[idx] = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void complexTest() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 2000);
        conf.setInt("dfs.heartbeat.interval", 2);
        conf.setInt("dfs.namenode.replication.pending.timeout-sec", 2);
        conf.setInt("dfs.client.socket-timeout", 5000);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(15).build();
        cluster.waitActive();
        DistributedFileSystem fs = cluster.getFileSystem();
        Modify modThread = null;
        try {
            int i;
            this.workload = new Workload[5];
            for (i = 0; i < 5; ++i) {
                this.workload[i] = new Workload(AppendTestUtil.nextLong(), (FileSystem)fs, i, 3, 3, 0L);
                this.workload[i].start();
            }
            modThread = new Modify((Configuration)conf, cluster);
            modThread.start();
            for (i = 0; i < 5; ++i) {
                try {
                    System.out.println("Waiting for thread " + i + " to complete...");
                    this.workload[i].join();
                    if (i < 2) continue;
                    modThread.close();
                    continue;
                }
                catch (InterruptedException e) {
                    --i;
                }
            }
        }
        finally {
            if (modThread != null) {
                modThread.close();
                try {
                    modThread.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            fs.close();
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void simpleTest(int datanodeToKill) throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 2000);
        conf.setInt("dfs.heartbeat.interval", 1);
        conf.setInt("dfs.namenode.replication.pending.timeout-sec", 2);
        conf.setInt("dfs.client.socket-timeout", 5000);
        int myMaxNodes = 5;
        System.out.println("SimpleTest starting with DataNode to Kill " + datanodeToKill);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(myMaxNodes).build();
        cluster.waitActive();
        DistributedFileSystem fs = cluster.getFileSystem();
        short repl = 3;
        Path filename = new Path("simpletest.dat");
        try {
            System.out.println("SimpleTest creating file " + filename);
            FSDataOutputStream stm = TestDatanodeDeath.createFile((FileSystem)fs, filename, repl);
            DFSOutputStream dfstream = (DFSOutputStream)stm.getWrappedStream();
            dfstream.setChunksPerPacket(5);
            dfstream.setArtificialSlowdown(3000L);
            long myseed = AppendTestUtil.nextLong();
            byte[] buffer = AppendTestUtil.randomBytes(myseed, 16385);
            int mid = 4096;
            stm.write(buffer, 0, mid);
            DatanodeInfo[] targets = dfstream.getPipeline();
            int count = 5;
            while (count-- > 0 && targets == null) {
                try {
                    System.out.println("SimpleTest: Waiting for pipeline to be created.");
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                targets = dfstream.getPipeline();
            }
            if (targets == null) {
                int victim = AppendTestUtil.nextInt(myMaxNodes);
                System.out.println("SimpleTest stopping datanode random " + victim);
                cluster.stopDataNode(victim);
            } else {
                int victim = datanodeToKill;
                System.out.println("SimpleTest stopping datanode " + targets[victim]);
                cluster.stopDataNode(targets[victim].getXferAddr());
            }
            System.out.println("SimpleTest stopping datanode complete");
            stm.write(buffer, mid, 16385 - mid);
            stm.close();
            TestDatanodeDeath.checkFile((FileSystem)fs, filename, repl, 2, 16385, myseed);
        }
        catch (Throwable e) {
            System.out.println("Simple Workload exception " + e);
            e.printStackTrace();
            Assert.assertTrue((String)e.toString(), (boolean)false);
        }
        finally {
            fs.close();
            cluster.shutdown();
        }
    }

    @Test
    public void testSimple0() throws IOException {
        this.simpleTest(0);
    }

    @Test
    public void testSimple1() throws IOException {
        this.simpleTest(1);
    }

    @Test
    public void testSimple2() throws IOException {
        this.simpleTest(2);
    }

    @Test
    public void testComplex() throws IOException {
        this.complexTest();
    }

    class Modify
    extends Thread {
        volatile boolean running = true;
        final MiniDFSCluster cluster;
        final Configuration conf;

        Modify(Configuration conf, MiniDFSCluster cluster) {
            this.cluster = cluster;
            this.conf = conf;
        }

        @Override
        public void run() {
            while (this.running) {
                int i;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    continue;
                }
                boolean loop = false;
                for (i = 0; i < 5; ++i) {
                    if (TestDatanodeDeath.this.workload[i].getStamp() != 0L) continue;
                    loop = true;
                    break;
                }
                if (loop) continue;
                for (i = 0; i < 2; ++i) {
                    int victim = AppendTestUtil.nextInt(15);
                    try {
                        System.out.println("Stopping datanode " + victim);
                        this.cluster.restartDataNode(victim);
                        continue;
                    }
                    catch (IOException e) {
                        System.out.println("TestDatanodeDeath Modify exception " + e);
                        Assert.assertTrue((String)("TestDatanodeDeath Modify exception " + e), (boolean)false);
                        this.running = false;
                    }
                }
                for (i = 0; i < 5; ++i) {
                    TestDatanodeDeath.this.workload[i].resetStamp();
                }
            }
        }

        void close() {
            this.running = false;
            this.interrupt();
        }
    }

    static class Workload
    extends Thread {
        private final short replication;
        private final int numberOfFiles;
        private final int id;
        private final FileSystem fs;
        private long stamp;
        private final long myseed;

        Workload(long myseed, FileSystem fs, int threadIndex, int numberOfFiles, short replication, long stamp) {
            this.myseed = myseed;
            this.id = threadIndex;
            this.fs = fs;
            this.numberOfFiles = numberOfFiles;
            this.replication = replication;
            this.stamp = stamp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            System.out.println("Workload starting ");
            for (int i = 0; i < this.numberOfFiles; ++i) {
                Path filename = new Path(this.id + "." + i);
                try {
                    System.out.println("Workload processing file " + filename);
                    FSDataOutputStream stm = TestDatanodeDeath.createFile(this.fs, filename, this.replication);
                    DFSOutputStream dfstream = (DFSOutputStream)stm.getWrappedStream();
                    dfstream.setArtificialSlowdown(1000L);
                    TestDatanodeDeath.writeFile(stm, this.myseed);
                    stm.close();
                    TestDatanodeDeath.checkFile(this.fs, filename, this.replication, 2, 16385, this.myseed);
                }
                catch (Throwable e) {
                    System.out.println("Workload exception " + e);
                    Assert.assertTrue((String)e.toString(), (boolean)false);
                }
                Workload workload = this;
                synchronized (workload) {
                    ++this.stamp;
                    continue;
                }
            }
        }

        public synchronized void resetStamp() {
            this.stamp = 0L;
        }

        public synchronized long getStamp() {
            return this.stamp;
        }
    }
}

