/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestBalancerBandwidth {
    private static final Configuration conf = new Configuration();
    private static final int NUM_OF_DATANODES = 2;
    private static final int DEFAULT_BANDWIDTH = 0x100000;
    public static final Logger LOG = LoggerFactory.getLogger(TestBalancerBandwidth.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBalancerBandwidth() throws Exception {
        conf.setLong("dfs.datanode.balance.bandwidthPerSec", 0x100000L);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).build();
        try {
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            ArrayList<DataNode> datanodes = cluster.getDataNodes();
            Assert.assertEquals((long)0x100000L, (long)datanodes.get(0).getBalancerBandwidth());
            Assert.assertEquals((long)0x100000L, (long)datanodes.get(1).getBalancerBandwidth());
            long newBandwidth = 0xC00000L;
            fs.setBalancerBandwidth(newBandwidth);
            try {
                Thread.sleep(5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Assert.assertEquals((long)newBandwidth, (long)datanodes.get(0).getBalancerBandwidth());
            Assert.assertEquals((long)newBandwidth, (long)datanodes.get(1).getBalancerBandwidth());
            fs.setBalancerBandwidth(0L);
            try {
                Thread.sleep(5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Assert.assertEquals((long)newBandwidth, (long)datanodes.get(0).getBalancerBandwidth());
            Assert.assertEquals((long)newBandwidth, (long)datanodes.get(1).getBalancerBandwidth());
        }
        finally {
            cluster.shutdown();
        }
    }

    public static void main(String[] args) throws Exception {
        new TestBalancerBandwidth().testBalancerBandwidth();
    }
}

