/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.cli;

import org.apache.hadoop.cli.CLITestHelper;
import org.apache.hadoop.cli.util.CLICommand;
import org.apache.hadoop.cli.util.CLICommandCacheAdmin;
import org.apache.hadoop.cli.util.CLICommandTypes;
import org.apache.hadoop.cli.util.CLITestCmd;
import org.apache.hadoop.cli.util.CacheAdminCmdExecutor;
import org.apache.hadoop.cli.util.CommandExecutor;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HDFSPolicyProvider;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.tools.CacheAdmin;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class TestCacheAdminCLI
extends CLITestHelper {
    public static final Logger LOG = LoggerFactory.getLogger(TestCacheAdminCLI.class);
    protected MiniDFSCluster dfsCluster = null;
    protected FileSystem fs = null;
    protected String namenode = null;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.conf.setClass("hadoop.security.authorization.policyprovider", HDFSPolicyProvider.class, PolicyProvider.class);
        this.conf.setInt("dfs.replication", 1);
        this.dfsCluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(3).build();
        this.dfsCluster.waitClusterUp();
        this.namenode = this.conf.get("fs.defaultFS", "file:///");
        this.username = System.getProperty("user.name");
        this.fs = this.dfsCluster.getFileSystem();
        Assert.assertTrue((String)("Not a HDFS: " + this.fs.getUri()), (boolean)(this.fs instanceof DistributedFileSystem));
    }

    @After
    public void tearDown() throws Exception {
        if (this.fs != null) {
            this.fs.close();
        }
        if (this.dfsCluster != null) {
            this.dfsCluster.shutdown();
        }
        Thread.sleep(2000L);
        super.tearDown();
    }

    protected String getTestFile() {
        return "testCacheAdminConf.xml";
    }

    protected CLITestHelper.TestConfigFileParser getConfigParser() {
        return new TestConfigFileParserCacheAdmin();
    }

    protected CommandExecutor.Result execute(CLICommand cmd) throws Exception {
        return cmd.getExecutor("").executeCommand(cmd.getCmd());
    }

    @Test
    public void testAll() {
        super.testAll();
    }

    private class CLITestCmdCacheAdmin
    extends CLITestCmd {
        public CLITestCmdCacheAdmin(String str, CLICommandTypes type) {
            super(str, type);
        }

        public CommandExecutor getExecutor(String tag) throws IllegalArgumentException {
            if (this.getType() instanceof CLICommandCacheAdmin) {
                return new CacheAdminCmdExecutor(tag, new CacheAdmin(TestCacheAdminCLI.this.conf));
            }
            return super.getExecutor(tag);
        }
    }

    private class TestConfigFileParserCacheAdmin
    extends CLITestHelper.TestConfigFileParser {
        private TestConfigFileParserCacheAdmin() {
            super((CLITestHelper)TestCacheAdminCLI.this);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("cache-admin-command")) {
                if (this.testCommands != null) {
                    this.testCommands.add(new CLITestCmdCacheAdmin(this.charString, new CLICommandCacheAdmin()));
                } else if (this.cleanupCommands != null) {
                    this.cleanupCommands.add(new CLITestCmdCacheAdmin(this.charString, new CLICommandCacheAdmin()));
                }
            } else {
                super.endElement(uri, localName, qName);
            }
        }
    }
}

