/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.webapp;

import com.google.inject.Inject;
import java.util.Date;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.ResourceView;
import org.apache.hadoop.yarn.server.nodemanager.webapp.NMView;
import org.apache.hadoop.yarn.server.nodemanager.webapp.dao.NodeInfo;
import org.apache.hadoop.yarn.webapp.SubView;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.HtmlPage;
import org.apache.hadoop.yarn.webapp.view.InfoBlock;
import org.apache.hadoop.yarn.webapp.view.JQueryUI;

public class NodePage
extends NMView {
    private static final long BYTES_IN_MB = 0x100000L;

    @Override
    protected void commonPreHead(Hamlet.HTML<HtmlPage.__> html) {
        super.commonPreHead(html);
        this.set(JQueryUI.initID((String)"ui.accordion", (String)"nav"), "{autoHeight:false, active:1}");
    }

    protected Class<? extends SubView> content() {
        return NodeBlock.class;
    }

    public static class NodeBlock
    extends HtmlBlock {
        private final Context context;
        private final ResourceView resourceView;

        @Inject
        public NodeBlock(Context context, ResourceView resourceView) {
            this.context = context;
            this.resourceView = resourceView;
        }

        protected void render(HtmlBlock.Block html) {
            NodeInfo info = new NodeInfo(this.context, this.resourceView);
            this.info("NodeManager information").__("Total Vmem allocated for Containers", (Object)StringUtils.byteDesc((long)(info.getTotalVmemAllocated() * 0x100000L))).__("Vmem enforcement enabled", (Object)info.isVmemCheckEnabled()).__("Total Pmem allocated for Container", (Object)StringUtils.byteDesc((long)(info.getTotalPmemAllocated() * 0x100000L))).__("Pmem enforcement enabled", (Object)info.isPmemCheckEnabled()).__("Total VCores allocated for Containers", (Object)String.valueOf(info.getTotalVCoresAllocated())).__("NodeHealthyStatus", (Object)info.getHealthStatus()).__("LastNodeHealthTime", (Object)new Date(info.getLastNodeUpdateTime())).__("NodeHealthReport", (Object)info.getHealthReport()).__("Node Manager Version:", (Object)(info.getNMBuildVersion() + " on " + info.getNMVersionBuiltOn())).__("Hadoop Version:", (Object)(info.getHadoopBuildVersion() + " on " + info.getHadoopVersionBuiltOn()));
            html.__(InfoBlock.class);
        }
    }
}

