/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.security;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.security.ExternalTokenLocalizer;
import org.apache.hadoop.yarn.util.YarnAppUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRTicketLocalizer
implements ExternalTokenLocalizer {
    private static final Logger LOG = LoggerFactory.getLogger(MapRTicketLocalizer.class);
    private ConcurrentHashMap<ApplicationId, AtomicBoolean> accessKeyMap = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(ContainerId containerId, String username, Configuration conf) {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        AtomicBoolean accessKey = this.getAccessKey(containerId.getApplicationAttemptId().getApplicationId());
        if (accessKey.get()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ticket already localized for " + containerId);
            }
            return;
        }
        AtomicBoolean atomicBoolean = accessKey;
        synchronized (atomicBoolean) {
            if (accessKey.get()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Ticket already localized for " + containerId);
                }
                return;
            }
            try {
                this.localizeUserTicket(containerId, username, conf);
                accessKey.set(true);
            }
            catch (IOException e) {
                throw new YarnRuntimeException((Throwable)e);
            }
        }
    }

    private AtomicBoolean getAccessKey(ApplicationId appId) {
        AtomicBoolean accessKey = new AtomicBoolean(false);
        AtomicBoolean existingAccessKey = this.accessKeyMap.putIfAbsent(appId, accessKey);
        if (existingAccessKey != null) {
            accessKey = existingAccessKey;
        }
        return accessKey;
    }

    @Override
    public Path getTokenPath(String appIdStr, Configuration conf) {
        return UserGroupInformation.isSecurityEnabled() ? YarnAppUtil.getNMPrivateTicketPath((String)appIdStr, (Configuration)conf) : null;
    }

    @Override
    public String getTokenEnvVar() {
        return "MAPR_TICKETFILE_LOCATION";
    }

    private void localizeUserTicket(ContainerId containerId, String username, Configuration conf) throws IOException {
        String appIdStr = containerId.getApplicationAttemptId().getApplicationId().toString();
        Path localTicketPath = YarnAppUtil.getNMPrivateTicketPath((String)appIdStr, (Configuration)conf);
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path ticketPath = YarnAppUtil.getRMSystemMapRTicketPath((String)appIdStr, (FileSystem)fs, (Configuration)conf);
        fs.copyToLocalFile(ticketPath, localTicketPath);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Localized user ticket file from " + ticketPath.toUri().getPath() + " to " + localTicketPath.toUri().getPath());
        }
    }

    @Override
    public void cleanup(ApplicationId appId) {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        this.accessKeyMap.remove(appId);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Cleanup complete for " + appId);
        }
    }
}

