/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.executor;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class ContainerSignalContext {
    private final Container container;
    private final String user;
    private final String pid;
    private final ContainerExecutor.Signal signal;
    private String containerOption;

    private ContainerSignalContext(Builder builder) {
        this.container = builder.container;
        this.user = builder.user;
        this.pid = builder.pid;
        this.signal = builder.signal;
        this.containerOption = builder.containerOption;
    }

    public Container getContainer() {
        return this.container;
    }

    public String getUser() {
        return this.user;
    }

    public String getPid() {
        return this.pid;
    }

    public ContainerExecutor.Signal getSignal() {
        return this.signal;
    }

    public String getContainerOption() {
        return this.containerOption;
    }

    public static final class Builder {
        private Container container;
        private String user;
        private String pid;
        private ContainerExecutor.Signal signal;
        private String containerOption;

        public Builder setContainer(Container container) {
            this.container = container;
            return this;
        }

        public Builder setUser(String user) {
            this.user = user;
            return this;
        }

        public Builder setPid(String pid) {
            this.pid = pid;
            return this;
        }

        public Builder setSignal(ContainerExecutor.Signal signal) {
            this.signal = signal;
            return this;
        }

        public Builder setContainerOption(String containerOption) {
            this.containerOption = containerOption;
            return this;
        }

        public ContainerSignalContext build() {
            return new ContainerSignalContext(this);
        }
    }
}

