/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.nodelocallogaggregation;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.nodelocallogaggregation.NodeLocalApplicationLogMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeLocalMetadataWriter {
    private static final Logger LOG = LoggerFactory.getLogger(NodeLocalMetadataWriter.class);
    private final String prefixPath;
    private final String logMetaDir;
    private final String containersList;
    private final Configuration conf;
    private FileSystem fs;
    private boolean prefixPathExists;

    public NodeLocalMetadataWriter(Configuration conf) {
        this.conf = conf;
        this.prefixPath = conf.get("yarn.nodemanager.remote-app-log-dir", "/tmp/logs");
        this.logMetaDir = conf.get("yarn.node-local-log-aggregation.metadata-path", "logsMeta");
        this.containersList = conf.get("yarn.node-local-log-aggregation.metadata-filename", "containers.seq");
        this.prefixPathExists = false;
    }

    public void write(ApplicationId applicationId, NodeId nodeId, List<ContainerId> containers, String appOwner) throws IOException {
        if (!this.prefixPathExists) {
            try {
                this.fs = FileSystem.get((Configuration)this.conf);
                if (!this.fs.exists(new Path(this.prefixPath))) {
                    this.fs.mkdirs(new Path(this.prefixPath));
                }
            }
            catch (IOException e) {
                LOG.warn("Can't create parent directory for metadata");
            }
            this.prefixPathExists = true;
        }
        NodeLocalApplicationLogMetadata info = new NodeLocalApplicationLogMetadata();
        info.setApplicationId(applicationId.toString());
        info.setNodeId(nodeId.getHost());
        info.setAppOwner(appOwner);
        info.setContainers(containers);
        this.writeInternal(info);
    }

    private void checkOrCreatePath(Path path) throws IOException {
        if (!this.fs.exists(path)) {
            this.fs.mkdirs(path);
        }
    }

    private void writeInternal(NodeLocalApplicationLogMetadata info) throws IOException {
        Path pathToMetadataDir = this.getPathForApp(info.getApplicationId(), info.getAppOwner());
        Path pathToMetadataNodeDir = new Path(pathToMetadataDir, info.getNodeId());
        this.checkOrCreatePath(pathToMetadataNodeDir);
        Path containerToNodeMetadataPath = new Path(pathToMetadataNodeDir, this.containersList);
        SequenceFile.Writer writer = SequenceFile.createWriter((Configuration)this.conf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)containerToNodeMetadataPath), SequenceFile.Writer.keyClass(Text.class), SequenceFile.Writer.valueClass(NullWritable.class)});
        this.writeContainerNodePairs(writer, info.getContainers());
        writer.close();
    }

    private void writeContainerNodePairs(SequenceFile.Writer writer, List<ContainerId> containers) throws IOException {
        for (ContainerId containerId : containers) {
            writer.append((Writable)new Text(containerId.toString()), (Writable)NullWritable.get());
        }
    }

    private Path getPathForApp(String applicationId, String appOwner) {
        return new Path(this.prefixPath, appOwner + "/" + this.logMetaDir + "/" + applicationId);
    }
}

