/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.LocalDirsHandlerService;
import org.apache.hadoop.yarn.server.nodemanager.WindowsSecureContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.ContainerManagerImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.Application;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerDiagnosticsUpdateEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerExitEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerState;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.security.ExternalTokenLocalizer;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.security.ExternalTokenLocalizerFactory;
import org.apache.hadoop.yarn.server.nodemanager.executor.ContainerSignalContext;
import org.apache.hadoop.yarn.server.nodemanager.executor.ContainerStartContext;
import org.apache.hadoop.yarn.server.nodemanager.util.ProcessIdFileReader;
import org.apache.hadoop.yarn.util.Apps;
import org.apache.hadoop.yarn.util.AuxiliaryServiceHelper;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.TaskLogUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerLaunch
implements Callable<Integer> {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerLaunch.class);
    public static final String CONTAINER_SCRIPT = Shell.appendScriptExtension((String)"launch_container");
    public static final String FINAL_CONTAINER_TOKENS_FILE = "container_tokens";
    private static final String PID_FILE_NAME_FMT = "%s.pid";
    private static final String EXIT_CODE_FILE_SUFFIX = ".exitcode";
    private static final String OOM_SCORE_ADJ_VALUE_VARIABLE = "OOM_SCORE_ADJ_VALUE";
    private static final String OOM_SCORE_ADJ_COMMAND = "echo $OOM_SCORE_ADJ_VALUE > /proc/self/oom_score_adj; ";
    protected final Dispatcher dispatcher;
    protected final ContainerExecutor exec;
    private final Application app;
    protected final Container container;
    private final Configuration conf;
    private final Context context;
    private final ContainerManagerImpl containerManager;
    protected AtomicBoolean shouldLaunchContainer = new AtomicBoolean(false);
    protected AtomicBoolean completed = new AtomicBoolean(false);
    private long sleepDelayBeforeSigKill = 250L;
    private long maxKillWaitTime = 2000L;
    private boolean killChildProcess = false;
    protected Path pidFilePath = null;
    private final LocalDirsHandlerService dirsHandler;
    private static final FsPermission APP_LOG_DIR_PERM = FsPermission.createImmutable((short)1512);
    private static final FsPermission APP_LOG_PERM = FsPermission.createImmutable((short)416);

    public ContainerLaunch(Context context, Configuration configuration, Dispatcher dispatcher, ContainerExecutor exec, Application app, Container container, LocalDirsHandlerService dirsHandler, ContainerManagerImpl containerManager) {
        this.context = context;
        this.conf = configuration;
        this.app = app;
        this.exec = exec;
        this.container = container;
        this.dispatcher = dispatcher;
        this.dirsHandler = dirsHandler;
        this.containerManager = containerManager;
        this.sleepDelayBeforeSigKill = this.conf.getLong("yarn.nodemanager.sleep-delay-before-sigkill.ms", 250L);
        this.maxKillWaitTime = this.conf.getLong("yarn.nodemanager.process-kill-wait.ms", 2000L);
        this.killChildProcess = this.conf.getBoolean("yarn.nodemanager.kill-container-child-process", false);
    }

    @VisibleForTesting
    public static String expandEnvironment(String var, Path containerLogDir) {
        var = var.replace("<LOG_DIR>", containerLogDir.toString());
        var = var.replace("<CPS>", File.pathSeparator);
        if (Shell.WINDOWS) {
            var = var.replaceAll("(\\{\\{)|(\\}\\})", "%");
        } else {
            var = var.replace("{{", "$");
            var = var.replace("}}", "");
        }
        return var;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer call() {
        Path containerLogDir;
        ContainerLaunchContext launchContext = this.container.getLaunchContext();
        Map<Path, List<String>> localResources = null;
        ContainerId containerID = this.container.getContainerId();
        String containerIdStr = ConverterUtils.toString((ContainerId)containerID);
        List command = launchContext.getCommands();
        int ret = -1;
        if (this.container.getContainerState() == ContainerState.KILLING) {
            this.dispatcher.getEventHandler().handle((Event)new ContainerExitEvent(containerID, ContainerEventType.CONTAINER_KILLED_ON_REQUEST, Shell.WINDOWS ? ContainerExecutor.ExitCode.FORCE_KILLED.getExitCode() : ContainerExecutor.ExitCode.TERMINATED.getExitCode(), "Container terminated before launch."));
            return 0;
        }
        try {
            localResources = this.container.getLocalizedResources();
            if (localResources == null) {
                throw RPCUtil.getRemoteException((String)("Unable to get local resources when Container " + containerID + " is at " + this.container.getContainerState()));
            }
            String user = this.container.getUser();
            String group = UserGroupInformation.createRemoteUser((String)user).getPrimaryGroupName();
            ArrayList<String> newCmds = new ArrayList<String>(command.size());
            String appIdStr = this.app.getAppId().toString();
            String relativeContainerLogDir = ContainerLaunch.getRelativeContainerLogDir(appIdStr, containerIdStr);
            containerLogDir = null;
            Map environment = launchContext.getEnvironment();
            containerLogDir = TaskLogUtil.isDfsLoggingEnabled((Map)environment) ? this.createLogDir(appIdStr, relativeContainerLogDir, user, group) : this.dirsHandler.getLogPathForWrite(relativeContainerLogDir, false);
            for (String string : command) {
                newCmds.add(ContainerLaunch.expandEnvironment(string, containerLogDir));
            }
            if (!Shell.WINDOWS && this.conf.getBoolean("yarn.nodemanager.oom_score_adj.enabled", false)) {
                environment.put(OOM_SCORE_ADJ_VALUE_VARIABLE, this.conf.get("yarn.nodemanager.oom_score_adj.value", String.valueOf(-17)));
                newCmds.add(0, OOM_SCORE_ADJ_COMMAND);
            }
            launchContext.setCommands(newCmds);
            for (Map.Entry entry : environment.entrySet()) {
                String value = (String)entry.getValue();
                value = ContainerLaunch.expandEnvironment(value, containerLogDir);
                entry.setValue(value);
            }
            FileContext lfs = FileContext.getLocalFSFileContext();
            Path path = this.dirsHandler.getLocalPathForWrite(this.getContainerPrivateDir(appIdStr, containerIdStr) + "/" + CONTAINER_SCRIPT);
            Path nmPrivateTokensPath = this.dirsHandler.getLocalPathForWrite(this.getContainerPrivateDir(appIdStr, containerIdStr) + "/" + String.format("%s.tokens", containerIdStr));
            Path nmPrivateClasspathJarDir = this.dirsHandler.getLocalPathForWrite(this.getContainerPrivateDir(appIdStr, containerIdStr));
            FSDataOutputStream containerScriptOutStream = null;
            FSDataOutputStream tokensOutStream = null;
            Path containerWorkDir = this.dirsHandler.getLocalPathForWrite("usercache/" + user + "/appcache/" + appIdStr + "/" + containerIdStr, -1L, false);
            String pidFileSubpath = this.getPidFileSubpath(appIdStr, containerIdStr);
            this.pidFilePath = this.dirsHandler.getLocalPathForWrite(pidFileSubpath);
            List<String> localDirs = this.dirsHandler.getLocalDirs();
            List<String> logDirs = this.dirsHandler.getLogDirs();
            ArrayList<String> containerLogDirs = new ArrayList<String>();
            for (String logDir : logDirs) {
                containerLogDirs.add(logDir + "/" + relativeContainerLogDir);
            }
            if (!this.dirsHandler.areDisksHealthy()) {
                ret = -101;
                throw new IOException("Most of the disks failed. " + this.dirsHandler.getDisksHealthReport(false));
            }
            ArrayList<String> containerLocalDirs = new ArrayList<String>(localDirs.size());
            try {
                ArrayList<Path> appDirs = new ArrayList<Path>(localDirs.size());
                for (String localDir : localDirs) {
                    Path usersdir = new Path(localDir, "usercache");
                    Path userdir = new Path(usersdir, user);
                    Path appsdir = new Path(userdir, "appcache");
                    appDirs.add(new Path(appsdir, appIdStr));
                    String containerLocalDir = localDir + "/usercache/" + user + "/appcache/" + appIdStr + "/";
                    containerLocalDirs.add(containerLocalDir);
                }
                containerScriptOutStream = lfs.create(path, EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE), new Options.CreateOpts[0]);
                environment.put("HADOOP_TOKEN_FILE_LOCATION", new Path(containerWorkDir, FINAL_CONTAINER_TOKENS_FILE).toUri().getPath());
                Apps.setEnvFromInputString((Map)environment, (String)YarnConfiguration.HADOOP_NATIVE_LIB_ENV, (String)File.pathSeparator);
                String libJvmPath = this.conf.get("yarn.libjvm.path", YarnConfiguration.LIBJVM_SO_PATH_DEFAULT);
                Apps.addToEnvironment((Map)environment, (String)ApplicationConstants.Environment.LD_LIBRARY_PATH.name(), (String)libJvmPath, (String)File.pathSeparator);
                this.sanitizeEnv(environment, containerWorkDir, appDirs, containerLogDirs, localResources, nmPrivateClasspathJarDir);
                this.exec.writeLaunchEnv((OutputStream)containerScriptOutStream, environment, localResources, launchContext.getCommands());
                tokensOutStream = lfs.create(nmPrivateTokensPath, EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE), new Options.CreateOpts[0]);
                Credentials creds = this.container.getCredentials();
                creds.writeTokenStorageToStream((DataOutputStream)tokensOutStream);
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{containerScriptOutStream, tokensOutStream});
                throw throwable;
            }
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{containerScriptOutStream, tokensOutStream});
            this.dispatcher.getEventHandler().handle((Event)new ContainerEvent(containerID, ContainerEventType.CONTAINER_LAUNCHED));
            this.context.getNMStateStore().storeContainerLaunched(containerID);
            if (!this.shouldLaunchContainer.compareAndSet(false, true)) {
                LOG.info("Container " + containerIdStr + " not launched as cleanup already called");
                ret = ContainerExecutor.ExitCode.TERMINATED.getExitCode();
            } else {
                this.exec.activateContainer(containerID, this.pidFilePath);
                ExternalTokenLocalizer extTokenLocalizer = ExternalTokenLocalizerFactory.get();
                if (extTokenLocalizer != null) {
                    extTokenLocalizer.run(containerID, user, this.conf);
                }
                Path extTokenPath = null;
                String extTokenEnvVar = null;
                if (extTokenLocalizer != null) {
                    extTokenPath = extTokenLocalizer.getTokenPath(appIdStr, this.conf);
                    extTokenEnvVar = extTokenLocalizer.getTokenEnvVar();
                }
                ret = this.exec.launchContainer(new ContainerStartContext.Builder().setContainer(this.container).setLocalizedResources(localResources).setNmPrivateContainerScriptPath(path).setNmPrivateTokensPath(nmPrivateTokensPath).setExtTokenPath(extTokenPath).setExtTokenEnvVar(extTokenEnvVar).setUser(user).setAppId(appIdStr).setContainerWorkDir(containerWorkDir).setLocalDirs(localDirs).setLogDirs(logDirs).setContainerLocalDirs(containerLocalDirs).setContainerLogDirs(containerLogDirs).build());
            }
        }
        catch (Throwable e) {
            LOG.warn("Failed to launch container.", e);
            this.dispatcher.getEventHandler().handle((Event)new ContainerExitEvent(containerID, ContainerEventType.CONTAINER_EXITED_WITH_FAILURE, ret, e.getMessage()));
            Integer n = ret;
            return n;
        }
        finally {
            this.completed.set(true);
            this.exec.deactivateContainer(containerID);
            try {
                this.context.getNMStateStore().storeContainerCompleted(containerID, ret);
            }
            catch (IOException e) {
                LOG.error("Unable to set exit code for container " + containerID);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Container " + containerIdStr + " completed with exit code " + ret);
        }
        StringBuilder diagnosticInfo = new StringBuilder("Container exited with a non-zero exit code ");
        diagnosticInfo.append(ret);
        diagnosticInfo.append(". ");
        if (ret == ContainerExecutor.ExitCode.FORCE_KILLED.getExitCode() || ret == ContainerExecutor.ExitCode.TERMINATED.getExitCode()) {
            this.dispatcher.getEventHandler().handle((Event)new ContainerExitEvent(containerID, ContainerEventType.CONTAINER_KILLED_ON_REQUEST, ret, diagnosticInfo.toString()));
            return ret;
        }
        if (ret != 0) {
            this.handleContainerExitWithFailure(containerID, ret, containerLogDir, diagnosticInfo);
            return ret;
        }
        LOG.info("Container " + containerIdStr + " succeeded ");
        this.dispatcher.getEventHandler().handle((Event)new ContainerEvent(containerID, ContainerEventType.CONTAINER_EXITED_WITH_SUCCESS));
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleContainerExitWithFailure(ContainerId containerID, int ret, Path containerLogDir, StringBuilder diagnosticInfo) {
        FSDataInputStream errorFileIS;
        block6: {
            LOG.warn(diagnosticInfo.toString());
            String errorFileNamePattern = this.conf.get("yarn.nodemanager.container.stderr.pattern", "{*stderr*,*STDERR*}");
            errorFileIS = null;
            try {
                Map env = this.container.getLaunchContext().getEnvironment();
                FileSystem fileSystem = TaskLogUtil.isDfsLoggingEnabled((Map)env) ? FileSystem.get((Configuration)this.conf) : FileSystem.getLocal((Configuration)this.conf).getRaw();
                FileStatus[] errorFileStatuses = fileSystem.globStatus(new Path(containerLogDir, errorFileNamePattern));
                if (errorFileStatuses == null || errorFileStatuses.length == 0) break block6;
                long tailSizeInBytes = this.conf.getLong("yarn.nodemanager.container.stderr.tail.bytes", 4096L);
                Path errorFile = errorFileStatuses[0].getPath();
                long fileSize = errorFileStatuses[0].getLen();
                if (errorFileStatuses.length > 1) {
                    String[] errorFileNames = new String[errorFileStatuses.length];
                    long latestModifiedTime = errorFileStatuses[0].getModificationTime();
                    errorFileNames[0] = errorFileStatuses[0].getPath().getName();
                    for (int i = 1; i < errorFileStatuses.length; ++i) {
                        errorFileNames[i] = errorFileStatuses[i].getPath().getName();
                        if (errorFileStatuses[i].getModificationTime() <= latestModifiedTime) continue;
                        latestModifiedTime = errorFileStatuses[i].getModificationTime();
                        errorFile = errorFileStatuses[i].getPath();
                        fileSize = errorFileStatuses[i].getLen();
                    }
                    diagnosticInfo.append("Error files: ").append(StringUtils.join((CharSequence)", ", (String[])errorFileNames)).append(".\n");
                }
                long startPosition = fileSize < tailSizeInBytes ? 0L : fileSize - tailSizeInBytes;
                int bufferSize = (int)(fileSize < tailSizeInBytes ? fileSize : tailSizeInBytes);
                byte[] tailBuffer = new byte[bufferSize];
                errorFileIS = fileSystem.open(errorFile);
                errorFileIS.readFully(startPosition, tailBuffer);
                diagnosticInfo.append("Last ").append(tailSizeInBytes).append(" bytes of ").append(errorFile.getName()).append(" :\n").append(new String(tailBuffer, StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                try {
                    LOG.error("Failed to get tail of the container's error log file", (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{errorFileIS});
                    throw throwable;
                }
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{errorFileIS});
            }
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{errorFileIS});
        this.dispatcher.getEventHandler().handle((Event)new ContainerExitEvent(containerID, ContainerEventType.CONTAINER_EXITED_WITH_FAILURE, ret, diagnosticInfo.toString()));
    }

    protected String getPidFileSubpath(String appIdStr, String containerIdStr) {
        return this.getContainerPrivateDir(appIdStr, containerIdStr) + "/" + String.format(PID_FILE_NAME_FMT, containerIdStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupContainer() throws IOException {
        boolean alreadyLaunched;
        ContainerId containerId = this.container.getContainerId();
        String containerIdStr = ConverterUtils.toString((ContainerId)containerId);
        LOG.info("Cleaning up container " + containerIdStr);
        try {
            this.context.getNMStateStore().storeContainerKilled(containerId);
        }
        catch (IOException e) {
            LOG.error("Unable to mark container " + containerId + " killed in store", (Throwable)e);
        }
        boolean bl = alreadyLaunched = !this.shouldLaunchContainer.compareAndSet(false, true);
        if (!alreadyLaunched) {
            LOG.info("Container " + containerIdStr + " not launched. No cleanup needed to be done");
            return;
        }
        LOG.debug("Marking container " + containerIdStr + " as inactive");
        this.exec.deactivateContainer(containerId);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Getting pid for container " + containerIdStr + " to kill from pid file " + (this.pidFilePath != null ? this.pidFilePath.toString() : "null"));
        }
        try {
            String processId = null;
            if (this.pidFilePath != null) {
                processId = this.getContainerPid(this.pidFilePath);
            }
            if (processId != null) {
                String user = this.container.getUser();
                LOG.debug("Sending signal to pid " + processId + " as user " + user + " for container " + containerIdStr);
                ContainerExecutor.Signal signal = this.sleepDelayBeforeSigKill > 0L ? ContainerExecutor.Signal.TERM : ContainerExecutor.Signal.KILL;
                String[] childPids = this.getChildPids(processId);
                boolean result = this.exec.signalContainer(new ContainerSignalContext.Builder().setContainer(this.container).setUser(user).setPid(processId).setSignal(signal).setContainerOption("0").build());
                LOG.debug("Sent signal " + signal + " to pid " + processId + " as user " + user + " for container " + containerIdStr + ", result=" + (result ? "success" : "failed"));
                if (this.sleepDelayBeforeSigKill > 0L) {
                    new ContainerExecutor.DelayedProcessKiller(this.container, user, processId, this.sleepDelayBeforeSigKill, ContainerExecutor.Signal.KILL, this.exec, childPids, this.killChildProcess).start();
                }
            }
        }
        catch (Exception e) {
            String message = "Exception when trying to cleanup container " + containerIdStr + ": " + StringUtils.stringifyException((Throwable)e);
            LOG.warn(message);
            this.dispatcher.getEventHandler().handle((Event)new ContainerDiagnosticsUpdateEvent(containerId, message));
        }
        finally {
            if (this.pidFilePath != null) {
                FileContext lfs = FileContext.getLocalFSFileContext();
                lfs.delete(this.pidFilePath, false);
                lfs.delete(this.pidFilePath.suffix(EXIT_CODE_FILE_SUFFIX), false);
            }
        }
    }

    private String[] getChildPids(String processId) {
        try {
            String ret = Shell.execCommand((String[])new String[]{"/bin/sh", "-c", "pgrep -P " + processId});
            return ret.split("\n");
        }
        catch (IOException e) {
            return null;
        }
    }

    private String getContainerPid(Path pidFilePath) throws Exception {
        String containerIdStr = ConverterUtils.toString((ContainerId)this.container.getContainerId());
        String processId = null;
        LOG.debug("Accessing pid for container " + containerIdStr + " from pid file " + pidFilePath);
        int sleepCounter = 0;
        int sleepInterval = 100;
        while (true) {
            if ((processId = ProcessIdFileReader.getProcessId(pidFilePath)) != null) {
                LOG.debug("Got pid " + processId + " for container " + containerIdStr);
                break;
            }
            if ((long)(sleepCounter * 100) > this.maxKillWaitTime) {
                LOG.info("Could not get pid for " + containerIdStr + ". Waited for " + this.maxKillWaitTime + " ms.");
                break;
            }
            ++sleepCounter;
            Thread.sleep(100L);
        }
        return processId;
    }

    public static String getRelativeContainerLogDir(String appIdStr, String containerIdStr) {
        return appIdStr + "/" + containerIdStr;
    }

    private String getContainerPrivateDir(String appIdStr, String containerIdStr) {
        return this.getAppPrivateDir(appIdStr) + "/" + containerIdStr + "/";
    }

    private String getAppPrivateDir(String appIdStr) {
        return "nmPrivate/" + appIdStr;
    }

    Context getContext() {
        return this.context;
    }

    private static void putEnvIfNotNull(Map<String, String> environment, String variable, String value) {
        if (value != null) {
            environment.put(variable, value);
        }
    }

    private static void putEnvIfAbsent(Map<String, String> environment, String variable) {
        if (environment.get(variable) == null) {
            ContainerLaunch.putEnvIfNotNull(environment, variable, System.getenv(variable));
        }
    }

    public void sanitizeEnv(Map<String, String> environment, Path pwd, List<Path> appDirs, List<String> containerLogDirs, Map<Path, List<String>> resources, Path nmPrivateClasspathJarDir) throws IOException {
        String inputClassPath;
        environment.put(ApplicationConstants.Environment.CONTAINER_ID.name(), this.container.getContainerId().toString());
        environment.put(ApplicationConstants.Environment.NM_PORT.name(), String.valueOf(this.context.getNodeId().getPort()));
        environment.put(ApplicationConstants.Environment.NM_HOST.name(), this.context.getNodeId().getHost());
        environment.put(ApplicationConstants.Environment.NM_HTTP_PORT.name(), String.valueOf(this.context.getHttpPort()));
        environment.put(ApplicationConstants.Environment.LOCAL_DIRS.name(), StringUtils.join((CharSequence)",", appDirs));
        environment.put(ApplicationConstants.Environment.LOG_DIRS.name(), StringUtils.join((CharSequence)",", containerLogDirs));
        environment.put(ApplicationConstants.Environment.USER.name(), this.container.getUser());
        environment.put(ApplicationConstants.Environment.LOGNAME.name(), this.container.getUser());
        environment.put(ApplicationConstants.Environment.HOME.name(), this.conf.get("yarn.nodemanager.user-home-dir", "/home/"));
        environment.put(ApplicationConstants.Environment.PWD.name(), pwd.toString());
        ContainerLaunch.putEnvIfNotNull(environment, ApplicationConstants.Environment.HADOOP_CONF_DIR.name(), System.getenv(ApplicationConstants.Environment.HADOOP_CONF_DIR.name()));
        if (!Shell.WINDOWS) {
            environment.put("JVM_PID", "$$");
        }
        String[] whitelist = this.conf.get("yarn.nodemanager.env-whitelist", YarnConfiguration.DEFAULT_NM_ENV_WHITELIST).split(",");
        for (String whitelistEnvVariable : whitelist) {
            ContainerLaunch.putEnvIfAbsent(environment, whitelistEnvVariable.trim());
        }
        Apps.setEnvFromInputString(environment, (String)this.conf.get("yarn.nodemanager.admin-env", "MALLOC_ARENA_MAX=$MALLOC_ARENA_MAX"), (String)File.pathSeparator);
        if (Shell.WINDOWS && (inputClassPath = environment.get(ApplicationConstants.Environment.CLASSPATH.name())) != null && !inputClassPath.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder(inputClassPath);
            for (Map.Entry<Path, List<String>> entry : resources.entrySet()) {
                boolean targetIsDirectory = new File(entry.getKey().toUri().getPath()).isDirectory();
                for (String linkName : entry.getValue()) {
                    stringBuilder.append(File.pathSeparator).append(pwd.toString()).append("/").append(linkName);
                    if (!targetIsDirectory) continue;
                    stringBuilder.append("/");
                }
            }
            HashMap<String, String> mergedEnv = new HashMap<String, String>(System.getenv());
            mergedEnv.putAll(environment);
            Path jarDir = this.exec instanceof WindowsSecureContainerExecutor ? nmPrivateClasspathJarDir : pwd;
            String[] jarCp = FileUtil.createJarWithClassPath((String)stringBuilder.toString(), (Path)jarDir, (Path)pwd, mergedEnv);
            Path localizedClassPathJar = this.exec.localizeClasspathJar(new Path(jarCp[0]), pwd, this.container.getUser());
            String replacementClassPath = localizedClassPathJar.toString() + jarCp[1];
            environment.put(ApplicationConstants.Environment.CLASSPATH.name(), replacementClassPath);
        }
        for (Map.Entry entry : this.containerManager.getAuxServiceMetaData(this.container.getContainerId()).entrySet()) {
            AuxiliaryServiceHelper.setServiceDataIntoEnv((String)((String)entry.getKey()), (ByteBuffer)((ByteBuffer)entry.getValue()), environment);
        }
    }

    public static String getExitCodeFile(String pidFile) {
        return pidFile + EXIT_CODE_FILE_SUFFIX;
    }

    private Path createLogDir(String appIdStr, String relativeContainerLogDir, String user, String group) throws IOException {
        Path appLogDir;
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        if (!fs.exists(appLogDir = TaskLogUtil.getDFSLoggingHandler().getLogDirForWrite(appIdStr))) {
            FileSystem.mkdirs((FileSystem)fs, (Path)appLogDir, (FsPermission)APP_LOG_DIR_PERM);
            fs.setOwner(appLogDir, user, group);
        }
        Path containerLogDir = TaskLogUtil.getDFSLoggingHandler().getLogDirForWrite(relativeContainerLogDir);
        FileSystem.mkdirs((FileSystem)fs, (Path)containerLogDir, (FsPermission)APP_LOG_DIR_PERM);
        fs.setOwner(containerLogDir, user, group);
        this.createEmptyLogFile(new Path(containerLogDir, "stdout"), user, group, fs);
        this.createEmptyLogFile(new Path(containerLogDir, "stderr"), user, group, fs);
        this.createEmptyLogFile(new Path(containerLogDir, "syslog"), user, group, fs);
        return containerLogDir;
    }

    private void createEmptyLogFile(Path path, String user, String group, FileSystem fs) throws IOException {
        fs.createNewFile(path);
        fs.setOwner(path, user, group);
        fs.setPermission(path, APP_LOG_PERM);
    }

    private static final class WindowsShellScriptBuilder
    extends ShellScriptBuilder {
        private void errorCheck() {
            this.line("@if %errorlevel% neq 0 exit /b %errorlevel%");
        }

        private void lineWithLenCheck(String ... commands) throws IOException {
            Shell.checkWindowsCommandLineLength((String[])commands);
            this.line(commands);
        }

        public WindowsShellScriptBuilder() {
            this.line("@setlocal");
            this.line(new String[0]);
        }

        @Override
        public void command(List<String> command) throws IOException {
            this.lineWithLenCheck("@call ", StringUtils.join((CharSequence)" ", command));
            this.errorCheck();
        }

        @Override
        public void whitelistedEnv(String key, String value) throws IOException {
            this.lineWithLenCheck("@set ", key, "=", value);
            this.errorCheck();
        }

        @Override
        public void env(String key, String value) throws IOException {
            this.lineWithLenCheck("@set ", key, "=", value);
            this.errorCheck();
        }

        @Override
        protected void link(Path src, Path dst) throws IOException {
            File srcFile = new File(src.toUri().getPath());
            String srcFileStr = srcFile.getPath();
            String dstFileStr = new File(dst.toString()).getPath();
            if (!Shell.isJava7OrAbove() && srcFile.isFile()) {
                this.lineWithLenCheck(String.format("@copy \"%s\" \"%s\"", srcFileStr, dstFileStr));
                this.errorCheck();
            } else {
                this.lineWithLenCheck(String.format("@%s symlink \"%s\" \"%s\"", Shell.WINUTILS, dstFileStr, srcFileStr));
                this.errorCheck();
            }
        }

        @Override
        protected void mkdir(Path path) throws IOException {
            this.lineWithLenCheck(String.format("@if not exist \"%s\" mkdir \"%s\"", path.toString(), path.toString()));
            this.errorCheck();
        }
    }

    private static final class UnixShellScriptBuilder
    extends ShellScriptBuilder {
        private void errorCheck() {
            this.line("hadoop_shell_errorcode=$?");
            this.line("if [ $hadoop_shell_errorcode -ne 0 ]");
            this.line("then");
            this.line("  exit $hadoop_shell_errorcode");
            this.line("fi");
        }

        public UnixShellScriptBuilder() {
            this.line("#!/bin/bash");
            this.line(new String[0]);
        }

        @Override
        public void command(List<String> command) {
            this.line("exec /bin/bash -c \"", StringUtils.join((CharSequence)" ", command), "\"");
            this.errorCheck();
        }

        @Override
        public void whitelistedEnv(String key, String value) {
            this.line("export ", key, "=${", key, ":-", "\"", value, "\"}");
        }

        @Override
        public void env(String key, String value) {
            this.line("export ", key, "=\"", value, "\"");
        }

        @Override
        protected void link(Path src, Path dst) throws IOException {
            this.line("ln -sf -- \"", src.toUri().getPath(), "\" \"", dst.toString(), "\"");
            this.errorCheck();
        }

        @Override
        protected void mkdir(Path path) {
            this.line("mkdir -p ", path.toString());
            this.errorCheck();
        }
    }

    public static abstract class ShellScriptBuilder {
        private static final String LINE_SEPARATOR = System.getProperty("line.separator");
        private final StringBuilder sb = new StringBuilder();

        public static ShellScriptBuilder create() {
            return Shell.WINDOWS ? new WindowsShellScriptBuilder() : new UnixShellScriptBuilder();
        }

        public abstract void command(List<String> var1) throws IOException;

        public abstract void whitelistedEnv(String var1, String var2) throws IOException;

        public abstract void env(String var1, String var2) throws IOException;

        public final void symlink(Path src, Path dst) throws IOException {
            if (!src.isAbsolute()) {
                throw new IOException("Source must be absolute");
            }
            if (dst.isAbsolute()) {
                throw new IOException("Destination must be relative");
            }
            if (dst.toUri().getPath().indexOf(47) != -1) {
                this.mkdir(dst.getParent());
            }
            this.link(src, dst);
        }

        public String toString() {
            return this.sb.toString();
        }

        public final void write(PrintStream out) throws IOException {
            out.append(this.sb);
        }

        protected final void line(String ... command) {
            for (String s : command) {
                this.sb.append(s);
            }
            this.sb.append(LINE_SEPARATOR);
        }

        protected abstract void link(Path var1, Path var2) throws IOException;

        protected abstract void mkdir(Path var1) throws IOException;
    }
}

