/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatcherTest
extends ClientBase {
    protected static final Logger LOG = LoggerFactory.getLogger(WatcherTest.class);
    private long timeOfLastWatcherInvocation;
    static final int COUNT = 100;
    final int TIMEOUT = 5000;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        System.setProperty("zookeeper.disableAutoWatchReset", "false");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWatcherCorrectness() throws IOException, InterruptedException, KeeperException {
        try (TestableZooKeeper zk = null;){
            String name;
            int i;
            MyWatcher watcher = new MyWatcher();
            zk = this.createClient(watcher, this.hostPort);
            AsyncCallback.StatCallback scb = new AsyncCallback.StatCallback(){

                public void processResult(int rc, String path, Object ctx, Stat stat) {
                }
            };
            AsyncCallback.VoidCallback vcb = new AsyncCallback.VoidCallback(){

                public void processResult(int rc, String path, Object ctx) {
                }
            };
            String[] names = new String[10];
            for (i = 0; i < names.length; ++i) {
                names[i] = name = zk.create("/tc-", "initialvalue".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
                Stat stat = new Stat();
                zk.getData(name, watcher, stat);
                zk.setData(name, "new".getBytes(), stat.getVersion(), scb, null);
                stat = zk.exists(name, watcher);
                zk.delete(name, stat.getVersion(), vcb, null);
            }
            for (i = 0; i < names.length; ++i) {
                name = names[i];
                WatchedEvent event = watcher.events.poll(10L, TimeUnit.SECONDS);
                Assert.assertEquals((Object)name, (Object)event.getPath());
                Assert.assertEquals((Object)Watcher.Event.EventType.NodeDataChanged, (Object)event.getType());
                Assert.assertEquals((Object)Watcher.Event.KeeperState.SyncConnected, (Object)event.getState());
                event = watcher.events.poll(10L, TimeUnit.SECONDS);
                Assert.assertEquals((Object)name, (Object)event.getPath());
                Assert.assertEquals((Object)Watcher.Event.EventType.NodeDeleted, (Object)event.getType());
                Assert.assertEquals((Object)Watcher.Event.KeeperState.SyncConnected, (Object)event.getState());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWatcherDisconnectOnClose() throws IOException, InterruptedException, KeeperException {
        try (TestableZooKeeper zk = null;){
            final LinkedBlockingQueue queue = new LinkedBlockingQueue();
            MyWatcher connWatcher = new MyWatcher();
            Watcher watcher = new Watcher(){

                public void process(WatchedEvent event) {
                    try {
                        queue.put(event);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            };
            zk = this.createClient(connWatcher, this.hostPort);
            AsyncCallback.StatCallback scb = new AsyncCallback.StatCallback(){

                public void processResult(int rc, String path, Object ctx, Stat stat) {
                }
            };
            zk.exists("/missing", watcher, scb, null);
            zk.close();
            WatchedEvent event = (WatchedEvent)queue.poll(10L, TimeUnit.SECONDS);
            Assert.assertNotNull((String)"No watch event was received after closing the Zookeeper client. A 'Closed' event should have occurred", (Object)event);
            Assert.assertEquals((String)"Closed events are not generated by the server, and so should have a type of 'None'", (Object)Watcher.Event.EventType.None, (Object)event.getType());
            Assert.assertEquals((String)"A 'Closed' event was expected as the Zookeeper client was closed without altering the node it was watching", (Object)Watcher.Event.KeeperState.Closed, (Object)event.getState());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWatcherCount() throws IOException, InterruptedException, KeeperException {
        TestableZooKeeper zk1 = null;
        TestableZooKeeper zk2 = null;
        try {
            MyWatcher w1 = new MyWatcher();
            zk1 = this.createClient(w1, this.hostPort);
            MyWatcher w2 = new MyWatcher();
            zk2 = this.createClient(w2, this.hostPort);
            Stat stat = new Stat();
            zk1.create("/watch-count-test", "value".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
            zk1.create("/watch-count-test-2", "value".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
            zk1.getData("/watch-count-test", w1, stat);
            zk1.getData("/watch-count-test-2", w1, stat);
            zk2.getData("/watch-count-test", w2, stat);
            Assert.assertEquals((long)ClientBase.getServer(this.serverFactory).getZKDatabase().getDataTree().getWatchCount(), (long)3L);
        }
        finally {
            if (zk1 != null) {
                zk1.close();
            }
            if (zk2 != null) {
                zk2.close();
            }
        }
    }

    @Test
    public void testWatchAutoResetWithPending() throws Exception {
        int i;
        MyWatcher[] watches = new MyWatcher[100];
        MyStatCallback[] cbs = new MyStatCallback[100];
        MyWatcher watcher = new MyWatcher();
        int[] count = new int[1];
        TestableZooKeeper zk = this.createClient(watcher, this.hostPort, 6000);
        TestableZooKeeper zk2 = this.createClient(watcher, this.hostPort, 5000);
        zk2.create("/test", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        for (i = 0; i < 50; ++i) {
            watches[i] = new MyWatcher();
            cbs[i] = new MyStatCallback();
            zk.exists("/test", watches[i], cbs[i], count);
        }
        zk.exists("/test", false);
        Assert.assertTrue((String)"Failed to pause the connection!", (boolean)zk.pauseCnxn(3000L));
        zk2.close();
        this.stopServer();
        watches[0].waitForDisconnected(60000L);
        for (i = 50; i < 100; ++i) {
            watches[i] = new MyWatcher();
            cbs[i] = new MyStatCallback();
            zk.exists("/test", watches[i], cbs[i], count);
        }
        this.startServer();
        watches[49].waitForConnected(60000L);
        Assert.assertEquals(null, (Object)zk.exists("/test", false));
        this.waitForAllWatchers();
        for (i = 0; i < 50; ++i) {
            Assert.assertEquals((String)("For " + i), (long)1L, (long)watches[i].events.size());
        }
        for (i = 50; i < 100; ++i) {
            if (cbs[i].rc == 0) {
                Assert.assertEquals((String)("For " + i), (long)1L, (long)watches[i].events.size());
                continue;
            }
            Assert.assertEquals((String)("For " + i), (long)0L, (long)watches[i].events.size());
        }
        Assert.assertEquals((long)100L, (long)count[0]);
        zk.close();
    }

    private void waitForAllWatchers() throws Exception {
        this.timeOfLastWatcherInvocation = System.currentTimeMillis();
        while (System.currentTimeMillis() - this.timeOfLastWatcherInvocation < 1000L) {
            Thread.sleep(1000L);
        }
    }

    @Test
    public void testWatcherAutoResetWithGlobal() throws Exception {
        TestableZooKeeper zk = null;
        MyWatcher watcher = new MyWatcher();
        zk = this.createClient(watcher, this.hostPort, 5000);
        this.testWatcherAutoReset((ZooKeeper)zk, watcher, watcher);
        zk.close();
    }

    @Test
    public void testWatcherAutoResetWithLocal() throws Exception {
        TestableZooKeeper zk = null;
        MyWatcher watcher = new MyWatcher();
        zk = this.createClient(watcher, this.hostPort, 5000);
        this.testWatcherAutoReset((ZooKeeper)zk, watcher, new MyWatcher());
        zk.close();
    }

    @Test
    public void testWatcherAutoResetDisabledWithGlobal() throws Exception {
        System.setProperty("zookeeper.disableAutoWatchReset", "true");
        this.testWatcherAutoResetWithGlobal();
    }

    @Test
    public void testWatcherAutoResetDisabledWithLocal() throws Exception {
        System.setProperty("zookeeper.disableAutoWatchReset", "true");
        this.testWatcherAutoResetWithLocal();
    }

    private void testWatcherAutoReset(ZooKeeper zk, MyWatcher globalWatcher, MyWatcher localWatcher) throws Exception {
        WatchedEvent e;
        boolean isGlobal = localWatcher == globalWatcher;
        zk.create("/watchtest", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/watchtest/child", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        if (isGlobal) {
            zk.getChildren("/watchtest", true);
            zk.getData("/watchtest/child", true, new Stat());
            zk.exists("/watchtest/child2", true);
        } else {
            zk.getChildren("/watchtest", (Watcher)localWatcher);
            zk.getData("/watchtest/child", (Watcher)localWatcher, new Stat());
            zk.exists("/watchtest/child2", (Watcher)localWatcher);
        }
        Assert.assertTrue((boolean)localWatcher.events.isEmpty());
        this.stopServer();
        globalWatcher.waitForDisconnected(3000L);
        localWatcher.waitForDisconnected(500L);
        this.startServer();
        globalWatcher.waitForConnected(3000L);
        boolean disableAutoWatchReset = zk.getClientConfig().getBoolean("zookeeper.disableAutoWatchReset");
        if (!isGlobal && !disableAutoWatchReset) {
            localWatcher.waitForConnected(500L);
        }
        Assert.assertTrue((boolean)localWatcher.events.isEmpty());
        zk.setData("/watchtest/child", new byte[1], -1);
        zk.create("/watchtest/child2", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        if (!disableAutoWatchReset) {
            e = localWatcher.events.poll(5000L, TimeUnit.MILLISECONDS);
            Assert.assertEquals((String)e.getPath(), (Object)Watcher.Event.EventType.NodeDataChanged, (Object)e.getType());
            Assert.assertEquals((Object)"/watchtest/child", (Object)e.getPath());
        }
        if (!disableAutoWatchReset) {
            e = localWatcher.events.poll(5000L, TimeUnit.MILLISECONDS);
            Assert.assertEquals((Object)Watcher.Event.EventType.NodeCreated, (Object)e.getType());
            Assert.assertEquals((Object)"/watchtest/child2", (Object)e.getPath());
        }
        if (!disableAutoWatchReset) {
            e = localWatcher.events.poll(5000L, TimeUnit.MILLISECONDS);
            Assert.assertEquals((Object)Watcher.Event.EventType.NodeChildrenChanged, (Object)e.getType());
            Assert.assertEquals((Object)"/watchtest", (Object)e.getPath());
        }
        Assert.assertTrue((boolean)localWatcher.events.isEmpty());
        this.stopServer();
        globalWatcher.waitForDisconnected(5000L);
        try {
            try {
                localWatcher.waitForDisconnected(500L);
                if (!isGlobal && !disableAutoWatchReset) {
                    Assert.fail((String)"Got an event when I shouldn't have");
                }
            }
            catch (TimeoutException toe) {
                if (disableAutoWatchReset) {
                    Assert.fail((String)"Didn't get an event when I should have");
                }
            }
        }
        catch (Exception e1) {
            LOG.error("bad", (Throwable)e1);
            throw new RuntimeException(e1);
        }
        this.startServer();
        globalWatcher.waitForConnected(5000L);
        if (isGlobal) {
            zk.getChildren("/watchtest", true);
            zk.getData("/watchtest/child", true, new Stat());
            zk.exists("/watchtest/child2", true);
        } else {
            zk.getChildren("/watchtest", (Watcher)localWatcher);
            zk.getData("/watchtest/child", (Watcher)localWatcher, new Stat());
            zk.exists("/watchtest/child2", (Watcher)localWatcher);
        }
        zk.delete("/watchtest/child2", -1);
        e = localWatcher.events.poll(5000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)Watcher.Event.EventType.NodeDeleted, (Object)e.getType());
        Assert.assertEquals((Object)"/watchtest/child2", (Object)e.getPath());
        e = localWatcher.events.poll(5000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)Watcher.Event.EventType.NodeChildrenChanged, (Object)e.getType());
        Assert.assertEquals((Object)"/watchtest", (Object)e.getPath());
        Assert.assertTrue((boolean)localWatcher.events.isEmpty());
        this.stopServer();
        globalWatcher.waitForDisconnected(5000L);
        localWatcher.waitForDisconnected(500L);
        this.startServer();
        globalWatcher.waitForConnected(5000L);
        if (!isGlobal && !disableAutoWatchReset) {
            localWatcher.waitForConnected(500L);
        }
        zk.delete("/watchtest/child", -1);
        zk.delete("/watchtest", -1);
        if (!disableAutoWatchReset) {
            e = localWatcher.events.poll(5000L, TimeUnit.MILLISECONDS);
            Assert.assertEquals((Object)Watcher.Event.EventType.NodeDeleted, (Object)e.getType());
            Assert.assertEquals((Object)"/watchtest/child", (Object)e.getPath());
        }
        Thread.sleep(1000L);
        Assert.assertTrue((boolean)localWatcher.events.isEmpty());
    }

    private class MyWatcher
    extends ClientBase.CountdownWatcher {
        LinkedBlockingQueue<WatchedEvent> events = new LinkedBlockingQueue();

        private MyWatcher() {
        }

        @Override
        public void process(WatchedEvent event) {
            super.process(event);
            if (event.getType() != Watcher.Event.EventType.None) {
                WatcherTest.this.timeOfLastWatcherInvocation = System.currentTimeMillis();
                try {
                    this.events.put(event);
                }
                catch (InterruptedException e) {
                    LOG.warn("ignoring interrupt during event.put");
                }
            }
        }
    }

    private static final class MyStatCallback
    implements AsyncCallback.StatCallback {
        int rc;

        private MyStatCallback() {
        }

        public void processResult(int rc, String path, Object ctx, Stat stat) {
            int[] nArray = (int[])ctx;
            nArray[0] = nArray[0] + 1;
            this.rc = rc;
        }
    }
}

