/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Assert;
import org.junit.Test;

public class SaslAuthFailDesignatedClientTest
extends ClientBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAuth() throws Exception {
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        TestableZooKeeper zk = new TestableZooKeeper(this.hostPort, CONNECTION_TIMEOUT, watcher);
        if (!watcher.clientConnected.await(CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)"Unable to connect to server");
        }
        try {
            zk.create("/path1", null, ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT);
            Assert.fail((String)"Should have gotten exception.");
        }
        catch (KeeperException e) {
            LOG.info("Got exception as expected: " + (Object)((Object)e));
        }
        finally {
            zk.close();
        }
    }

    static {
        System.setProperty("zookeeper.authProvider.1", "org.apache.zookeeper.server.auth.SASLAuthenticationProvider");
        System.setProperty("zookeeper.sasl.clientconfig", "MyZookeeperClient");
        try {
            File tmpDir = SaslAuthFailDesignatedClientTest.createTmpDir();
            File saslConfFile = new File(tmpDir, "jaas.conf");
            FileWriter fwriter = new FileWriter(saslConfFile);
            fwriter.write("Server {\n          org.apache.zookeeper.server.auth.DigestLoginModule required\n          user_myuser=\"mypassword\";\n};\nClient {\n       org.apache.zookeeper.server.auth.DigestLoginModule required\n       username=\"myuser\"\n       password=\"mypassword\";\n};MyZookeeperClient {\n       org.apache.zookeeper.server.auth.DigestLoginModule required\n       username=\"myuser\"\n       password=\"wrongpassword\";\n};\n");
            fwriter.close();
            System.setProperty("java.security.auth.login.config", saslConfFile.getAbsolutePath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

