/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.TimeoutException;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.admin.ZooKeeperAdmin;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.QuorumUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconfigMisconfigTest
extends ZKTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(ReconfigMisconfigTest.class);
    private QuorumUtil qu;
    private ZooKeeperAdmin zkAdmin;
    private static String errorMsg = "Reconfig should fail without configuring the super user's password on server side first.";

    @Before
    public void setup() throws InterruptedException {
        QuorumPeerConfig.setReconfigEnabled((boolean)true);
        this.qu = new QuorumUtil(1);
        this.qu.disableJMXTest = true;
        try {
            this.qu.startAll();
        }
        catch (IOException e) {
            Assert.fail((String)"Fail to start quorum servers.");
        }
        this.instantiateZKAdmin();
    }

    @After
    public void tearDown() throws Exception {
        try {
            if (this.qu != null) {
                this.qu.tearDown();
            }
            if (this.zkAdmin != null) {
                this.zkAdmin.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test(timeout=10000L)
    public void testReconfigFailWithoutSuperuserPasswordConfiguredOnServer() throws InterruptedException {
        try {
            this.reconfigPort();
            Assert.fail((String)errorMsg);
        }
        catch (KeeperException e) {
            Assert.assertTrue((e.code() == KeeperException.Code.NOAUTH ? 1 : 0) != 0);
        }
        try {
            this.zkAdmin.addAuthInfo("digest", "super:".getBytes());
            this.reconfigPort();
            Assert.fail((String)errorMsg);
        }
        catch (KeeperException e) {
            Assert.assertTrue((e.code() == KeeperException.Code.NOAUTH ? 1 : 0) != 0);
        }
    }

    private void instantiateZKAdmin() throws InterruptedException {
        String cnxString;
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        try {
            cnxString = "127.0.0.1:" + this.qu.getPeer((int)1).peer.getClientPort();
            this.zkAdmin = new ZooKeeperAdmin(cnxString, ClientBase.CONNECTION_TIMEOUT, (Watcher)watcher);
        }
        catch (IOException e) {
            Assert.fail((String)"Fail to create ZooKeeperAdmin handle.");
            return;
        }
        try {
            watcher.waitForConnected(ClientBase.CONNECTION_TIMEOUT);
        }
        catch (InterruptedException | TimeoutException e) {
            Assert.fail((String)("ZooKeeper admin client can not connect to " + cnxString));
        }
    }

    private boolean reconfigPort() throws KeeperException, InterruptedException {
        ArrayList<String> joiningServers = new ArrayList<String>();
        int leaderId = 1;
        while (this.qu.getPeer((int)leaderId).peer.leader == null) {
            ++leaderId;
        }
        int followerId = leaderId == 1 ? 2 : 1;
        joiningServers.add("server." + followerId + "=localhost:" + this.qu.getPeer((int)followerId).peer.getQuorumAddress().getPort() + ":" + this.qu.getPeer((int)followerId).peer.getElectionAddress().getPort() + ":participant;localhost:" + PortAssignment.unique());
        this.zkAdmin.reconfigure(joiningServers, null, null, -1L, new Stat());
        return true;
    }
}

