/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.OutputArchive;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.proto.CreateRequest;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.QuorumUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaderSessionTrackerTest
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(LeaderSessionTrackerTest.class);
    QuorumUtil qu;

    @Before
    public void setUp() throws Exception {
        this.qu = new QuorumUtil(1);
    }

    @After
    public void tearDown() throws Exception {
        this.qu.shutdownAll();
    }

    @Test
    public void testExpiredSessionWithLocalSession() throws Exception {
        this.testCreateEphemeral(true);
    }

    @Test
    public void testExpiredSessionWithoutLocalSession() throws Exception {
        this.testCreateEphemeral(false);
    }

    public void testCreateEphemeral(boolean localSessionEnabled) throws Exception {
        if (localSessionEnabled) {
            this.qu.enableLocalSession(true);
        }
        this.qu.startAll();
        QuorumPeer leader = this.qu.getLeaderQuorumPeer();
        ZooKeeper zk = ClientBase.createZKClient(this.qu.getConnectString(leader));
        CreateRequest createRequest = new CreateRequest("/impossible", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL.toFlag());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryOutputArchive boa = BinaryOutputArchive.getArchive((OutputStream)baos);
        createRequest.serialize((OutputArchive)boa, "request");
        ByteBuffer bb = ByteBuffer.wrap(baos.toByteArray());
        long sid = this.qu.getFollowerQuorumPeers().get(0).getActiveServer().getServerId();
        long fakeSessionId = (sid << 56) + 1L;
        LOG.info("Fake session Id: " + Long.toHexString(fakeSessionId));
        Request request = new Request(null, fakeSessionId, 0, 1, bb, new ArrayList());
        leader.getActiveServer().submitRequest(request);
        zk.create("/ok", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Stat stat = zk.exists("/impossible", null);
        Assert.assertEquals((String)"Node from fake session get created", null, (Object)stat);
    }

    @Test
    public void testCreatePersistent() throws Exception {
        this.qu.enableLocalSession(true);
        this.qu.startAll();
        QuorumPeer leader = this.qu.getLeaderQuorumPeer();
        ZooKeeper zk = ClientBase.createZKClient(this.qu.getConnectString(leader));
        CreateRequest createRequest = new CreateRequest("/success", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT.toFlag());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryOutputArchive boa = BinaryOutputArchive.getArchive((OutputStream)baos);
        createRequest.serialize((OutputArchive)boa, "request");
        ByteBuffer bb = ByteBuffer.wrap(baos.toByteArray());
        long sid = this.qu.getFollowerQuorumPeers().get(0).getActiveServer().getServerId();
        long locallSession = (sid << 56) + 1L;
        LOG.info("Local session Id: " + Long.toHexString(locallSession));
        Request request = new Request(null, locallSession, 0, 1, bb, new ArrayList());
        leader.getActiveServer().submitRequest(request);
        zk.create("/ok", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Stat stat = zk.exists("/success", null);
        Assert.assertTrue((String)"Request from local sesson failed", (stat != null ? 1 : 0) != 0);
    }
}

