/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum.auth;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import org.apache.zookeeper.server.quorum.auth.KerberosSecurityTestcase;
import org.apache.zookeeper.server.quorum.auth.KerberosTestUtils;
import org.apache.zookeeper.test.ClientBase;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class QuorumKerberosHostBasedAuthTest
extends KerberosSecurityTestcase {
    private static File keytabFile;
    private static String hostServerPrincipal;
    private static String hostLearnerPrincipal;
    private static String hostNamedLearnerPrincipal;

    private static void setupJaasConfigEntries(String hostServerPrincipal, String hostLearnerPrincipal, String hostNamedLearnerPrincipal) {
        String keytabFilePath = FilenameUtils.normalize((String)KerberosTestUtils.getKeytabFile(), (boolean)true);
        String jaasEntries = new String("QuorumServer {\n       com.sun.security.auth.module.Krb5LoginModule required\n       useKeyTab=true\n       keyTab=\"" + keytabFilePath + "\"\n       storeKey=true\n       useTicketCache=false\n       debug=false\n       principal=\"" + KerberosTestUtils.replaceHostPattern(hostServerPrincipal) + "\";\n};\nQuorumLearner {\n       com.sun.security.auth.module.Krb5LoginModule required\n       useKeyTab=true\n       keyTab=\"" + keytabFilePath + "\"\n       storeKey=true\n       useTicketCache=false\n       debug=false\n       principal=\"" + KerberosTestUtils.replaceHostPattern(hostLearnerPrincipal) + "\";\n};\nQuorumLearnerMyHost {\n       com.sun.security.auth.module.Krb5LoginModule required\n       useKeyTab=true\n       keyTab=\"" + keytabFilePath + "\"\n       storeKey=true\n       useTicketCache=false\n       debug=false\n       principal=\"" + hostNamedLearnerPrincipal + "\";\n};\n");
        QuorumKerberosHostBasedAuthTest.setupJaasConfig(jaasEntries);
    }

    @BeforeClass
    public static void setUp() throws Exception {
        keytabFile = new File(KerberosTestUtils.getKeytabFile());
        String learnerPrincipal = hostLearnerPrincipal.substring(0, hostLearnerPrincipal.lastIndexOf("@"));
        learnerPrincipal = KerberosTestUtils.replaceHostPattern(learnerPrincipal);
        String serverPrincipal = hostServerPrincipal.substring(0, hostServerPrincipal.lastIndexOf("@"));
        serverPrincipal = KerberosTestUtils.replaceHostPattern(serverPrincipal);
        String learnerPrincipal2 = hostNamedLearnerPrincipal.substring(0, hostNamedLearnerPrincipal.lastIndexOf("@"));
        QuorumKerberosHostBasedAuthTest.getKdc().createPrincipal(keytabFile, learnerPrincipal, learnerPrincipal2, serverPrincipal);
    }

    @After
    public void tearDown() throws Exception {
        for (QuorumPeerTestBase.MainThread mainThread : this.mt) {
            mainThread.shutdown();
            mainThread.deleteBaseDir();
        }
    }

    @AfterClass
    public static void cleanup() {
        if (keytabFile != null) {
            FileUtils.deleteQuietly((File)keytabFile);
        }
        QuorumKerberosHostBasedAuthTest.cleanupJaasConfig();
    }

    @Test(timeout=120000L)
    public void testValidCredentials() throws Exception {
        String serverPrincipal = hostServerPrincipal.substring(0, hostServerPrincipal.lastIndexOf("@"));
        HashMap<String, String> authConfigs = new HashMap<String, String>();
        authConfigs.put("quorum.auth.enableSasl", "true");
        authConfigs.put("quorum.auth.serverRequireSasl", "true");
        authConfigs.put("quorum.auth.learnerRequireSasl", "true");
        authConfigs.put("quorum.auth.kerberos.servicePrincipal", serverPrincipal);
        String connectStr = this.startQuorum(3, authConfigs, 3);
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        ZooKeeper zk = new ZooKeeper(connectStr, ClientBase.CONNECTION_TIMEOUT, (Watcher)watcher);
        watcher.waitForConnected(ClientBase.CONNECTION_TIMEOUT);
        for (int i = 0; i < 10; ++i) {
            zk.create("/" + i, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        zk.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testConnectBadServer() throws Exception {
        String serverPrincipal = hostServerPrincipal.substring(0, hostServerPrincipal.lastIndexOf("@"));
        HashMap<String, String> authConfigs = new HashMap<String, String>();
        authConfigs.put("quorum.auth.enableSasl", "true");
        authConfigs.put("quorum.auth.serverRequireSasl", "true");
        authConfigs.put("quorum.auth.learnerRequireSasl", "true");
        authConfigs.put("quorum.auth.kerberos.servicePrincipal", serverPrincipal);
        String connectStr = this.startQuorum(3, authConfigs, 3);
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        ZooKeeper zk = new ZooKeeper(connectStr, ClientBase.CONNECTION_TIMEOUT, (Watcher)watcher);
        watcher.waitForConnected(ClientBase.CONNECTION_TIMEOUT);
        for (int i = 0; i < 10; ++i) {
            zk.create("/" + i, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        zk.close();
        String quorumCfgSection = ((QuorumPeerTestBase.MainThread)this.mt.get(0)).getQuorumCfgSection();
        StringBuilder sb = new StringBuilder();
        sb.append(quorumCfgSection);
        int myid = this.mt.size() + 1;
        int clientPort = PortAssignment.unique();
        String server = String.format("server.%d=localhost:%d:%d:participant", myid, PortAssignment.unique(), PortAssignment.unique());
        sb.append(server + "\n");
        quorumCfgSection = sb.toString();
        authConfigs.put("quorum.auth.learner.saslLoginContext", "QuorumLearnerMyHost");
        QuorumPeerTestBase.MainThread badServer = new QuorumPeerTestBase.MainThread(myid, clientPort, quorumCfgSection, authConfigs);
        badServer.start();
        watcher = new ClientBase.CountdownWatcher();
        connectStr = "127.0.0.1:" + clientPort;
        zk = new ZooKeeper(connectStr, ClientBase.CONNECTION_TIMEOUT, (Watcher)watcher);
        try {
            watcher.waitForConnected(ClientBase.CONNECTION_TIMEOUT / 3);
            Assert.fail((String)"Must throw exception as the myHost is not an authorized one!");
        }
        catch (TimeoutException timeoutException) {
        }
        finally {
            zk.close();
            badServer.shutdown();
            badServer.deleteBaseDir();
        }
    }

    static {
        hostServerPrincipal = KerberosTestUtils.getHostServerPrincipal();
        hostLearnerPrincipal = KerberosTestUtils.getHostLearnerPrincipal();
        hostNamedLearnerPrincipal = KerberosTestUtils.getHostNamedLearnerPrincipal("myHost");
        QuorumKerberosHostBasedAuthTest.setupJaasConfigEntries(hostServerPrincipal, hostLearnerPrincipal, hostNamedLearnerPrincipal);
    }
}

