/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.util.ArrayList;
import java.util.HashSet;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.ReconfigTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ReconfigRecoveryTest
extends QuorumPeerTestBase {
    @Before
    public void setup() {
        QuorumPeerConfig.setReconfigEnabled((boolean)true);
    }

    @Test
    public void testNextConfigCompletion() throws Exception {
        ClientBase.setupTestEnv();
        int SERVER_COUNT = 3;
        int[] clientPorts = new int[3];
        StringBuilder sb = new StringBuilder();
        ArrayList<String> allServers = new ArrayList<String>();
        String currentQuorumCfgSection = null;
        for (int i = 0; i < 3; ++i) {
            clientPorts[i] = PortAssignment.unique();
            String server = "server." + i + "=localhost:" + PortAssignment.unique() + ":" + PortAssignment.unique() + ":participant;localhost:" + clientPorts[i];
            allServers.add(server);
            sb.append(server + "\n");
            if (i != 1) continue;
            currentQuorumCfgSection = sb.toString();
        }
        String nextQuorumCfgSection = sb.toString();
        QuorumPeerTestBase.MainThread[] mt = new QuorumPeerTestBase.MainThread[3];
        ZooKeeper[] zk = new ZooKeeper[3];
        for (int i = 0; i < 2; ++i) {
            mt[i] = new QuorumPeerTestBase.MainThread(i, clientPorts[i], currentQuorumCfgSection, true, "100000000");
            mt[i].writeTempDynamicConfigFile(nextQuorumCfgSection, "200000000");
            mt[i].start();
            zk[i] = new ZooKeeper("127.0.0.1:" + clientPorts[i], ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        }
        Assert.assertTrue((String)"waiting for server 0 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + clientPorts[0], ClientBase.CONNECTION_TIMEOUT));
        Assert.assertTrue((String)"waiting for server 1 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + clientPorts[1], ClientBase.CONNECTION_TIMEOUT));
        int leader = mt[0].main.quorumPeer.leader == null ? 1 : 0;
        sb = new StringBuilder();
        sb.append((String)allServers.get(leader) + "\n");
        sb.append((String)allServers.get(2) + "\n");
        String newServerInitialConfig = sb.toString();
        mt[2] = new QuorumPeerTestBase.MainThread(2, clientPorts[2], newServerInitialConfig);
        mt[2].start();
        zk[2] = new ZooKeeper("127.0.0.1:" + clientPorts[2], ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        Assert.assertTrue((String)"waiting for server 2 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + clientPorts[2], ClientBase.CONNECTION_TIMEOUT));
        ReconfigTest.testServerHasConfig(zk[0], allServers, null);
        ReconfigTest.testServerHasConfig(zk[1], allServers, null);
        ReconfigTest.testServerHasConfig(zk[2], allServers, null);
        ReconfigTest.testNormalOperation(zk[0], zk[2]);
        ReconfigTest.testNormalOperation(zk[2], zk[1]);
        for (int i = 0; i < 3; ++i) {
            mt[i].shutdown();
            zk[i].close();
        }
    }

    @Test
    public void testCurrentServersAreObserversInNextConfig() throws Exception {
        int i;
        String server;
        ClientBase.setupTestEnv();
        int SERVER_COUNT = 5;
        int[] clientPorts = new int[5];
        int[] oldClientPorts = new int[2];
        StringBuilder sb = new StringBuilder();
        ArrayList<String> allServersNext = new ArrayList<String>();
        for (int i2 = 0; i2 < 2; ++i2) {
            oldClientPorts[i2] = PortAssignment.unique();
            server = "server." + i2 + "=localhost:" + PortAssignment.unique() + ":" + PortAssignment.unique() + ":participant;localhost:" + oldClientPorts[i2];
            sb.append(server + "\n");
        }
        String currentQuorumCfg = sb.toString();
        sb = new StringBuilder();
        for (int i3 = 0; i3 < 5; ++i3) {
            clientPorts[i3] = PortAssignment.unique();
            String role = i3 < 2 ? "observer" : "participant";
            server = "server." + i3 + "=localhost:" + PortAssignment.unique() + ":" + PortAssignment.unique() + ":" + role + ";localhost:" + clientPorts[i3];
            allServersNext.add(server);
            sb.append(server + "\n");
        }
        String nextQuorumCfgSection = sb.toString();
        QuorumPeerTestBase.MainThread[] mt = new QuorumPeerTestBase.MainThread[5];
        ZooKeeper[] zk = new ZooKeeper[5];
        for (i = 0; i < 2; ++i) {
            mt[i] = new QuorumPeerTestBase.MainThread(i, oldClientPorts[i], currentQuorumCfg, true, "100000000");
            mt[i].start();
            zk[i] = new ZooKeeper("127.0.0.1:" + oldClientPorts[i], ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        }
        for (i = 0; i < 2; ++i) {
            Assert.assertTrue((String)("waiting for server " + i + " being up"), (boolean)ClientBase.waitForServerUp("127.0.0.1:" + oldClientPorts[i], ClientBase.CONNECTION_TIMEOUT * 2));
        }
        ReconfigTest.testNormalOperation(zk[0], zk[1]);
        for (i = 0; i < 2; ++i) {
            mt[i].shutdown();
            zk[i].close();
        }
        for (i = 0; i < 2; ++i) {
            Assert.assertTrue((String)("waiting for server " + i + " being up"), (boolean)ClientBase.waitForServerDown("127.0.0.1:" + oldClientPorts[i], ClientBase.CONNECTION_TIMEOUT * 2));
        }
        for (i = 0; i < 2; ++i) {
            mt[i].writeTempDynamicConfigFile(nextQuorumCfgSection, "200000000");
            mt[i].start();
            zk[i] = new ZooKeeper("127.0.0.1:" + clientPorts[i], ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        }
        for (i = 2; i < 5; ++i) {
            mt[i] = new QuorumPeerTestBase.MainThread(i, clientPorts[i], currentQuorumCfg + (String)allServersNext.get(i));
            mt[i].start();
            zk[i] = new ZooKeeper("127.0.0.1:" + clientPorts[i], ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        }
        for (i = 0; i < 5; ++i) {
            Assert.assertTrue((String)("waiting for server " + i + " being up"), (boolean)ClientBase.waitForServerUp("127.0.0.1:" + clientPorts[i], ClientBase.CONNECTION_TIMEOUT * 2));
            ReconfigTest.testServerHasConfig(zk[i], allServersNext, null);
        }
        ReconfigTest.testNormalOperation(zk[0], zk[2]);
        ReconfigTest.testNormalOperation(zk[4], zk[1]);
        for (i = 0; i < 5; ++i) {
            zk[i].close();
            mt[i].shutdown();
        }
    }

    @Test
    public void testNextConfigUnreachable() throws Exception {
        int i;
        ClientBase.setupTestEnv();
        int SERVER_COUNT = 5;
        int[] clientPorts = new int[5];
        StringBuilder sb = new StringBuilder();
        String currentQuorumCfgSection = null;
        for (int i2 = 0; i2 < 5; ++i2) {
            clientPorts[i2] = PortAssignment.unique();
            String server = "server." + i2 + "=localhost:" + PortAssignment.unique() + ":" + PortAssignment.unique() + ":participant;localhost:" + clientPorts[i2];
            sb.append(server + "\n");
            if (i2 != 1) continue;
            currentQuorumCfgSection = sb.toString();
        }
        String nextQuorumCfgSection = sb.toString();
        QuorumPeerTestBase.MainThread[] mt = new QuorumPeerTestBase.MainThread[5];
        ZooKeeper[] zk = new ZooKeeper[5];
        for (i = 0; i < 2; ++i) {
            mt[i] = new QuorumPeerTestBase.MainThread(i, clientPorts[i], currentQuorumCfgSection, true, "100000000");
            mt[i].writeTempDynamicConfigFile(nextQuorumCfgSection, "200000000");
            mt[i].start();
            zk[i] = new ZooKeeper("127.0.0.1:" + clientPorts[i], ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        }
        Thread.sleep(ClientBase.CONNECTION_TIMEOUT * 2);
        for (i = 0; i < 2; ++i) {
            Assert.assertFalse((String)("server " + i + " is up but shouldn't be"), (boolean)ClientBase.waitForServerUp("127.0.0.1:" + clientPorts[i], ClientBase.CONNECTION_TIMEOUT / 10));
        }
        for (i = 0; i < 2; ++i) {
            zk[i].close();
            mt[i].shutdown();
        }
    }

    @Test
    public void testNextConfigAlreadyActive() throws Exception {
        int i;
        int i2;
        ClientBase.setupTestEnv();
        int SERVER_COUNT = 5;
        int[] clientPorts = new int[5];
        StringBuilder sb = new StringBuilder();
        String currentQuorumCfgSection = null;
        ArrayList<String> allServers = new ArrayList<String>();
        for (int i3 = 0; i3 < 5; ++i3) {
            clientPorts[i3] = PortAssignment.unique();
            String server = "server." + i3 + "=localhost:" + PortAssignment.unique() + ":" + PortAssignment.unique() + ":participant;localhost:" + clientPorts[i3];
            allServers.add(server);
            sb.append(server + "\n");
            if (i3 != 1) continue;
            currentQuorumCfgSection = sb.toString();
        }
        String nextQuorumCfgSection = sb.toString();
        QuorumPeerTestBase.MainThread[] mt = new QuorumPeerTestBase.MainThread[5];
        ZooKeeper[] zk = new ZooKeeper[5];
        for (i2 = 2; i2 < 5; ++i2) {
            mt[i2] = new QuorumPeerTestBase.MainThread(i2, clientPorts[i2], nextQuorumCfgSection, true, "200000000");
            mt[i2].start();
            zk[i2] = new ZooKeeper("127.0.0.1:" + clientPorts[i2], ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        }
        for (i2 = 2; i2 < 5; ++i2) {
            Assert.assertTrue((String)("waiting for server " + i2 + " being up"), (boolean)ClientBase.waitForServerUp("127.0.0.1:" + clientPorts[i2], ClientBase.CONNECTION_TIMEOUT));
        }
        ReconfigTest.testNormalOperation(zk[2], zk[3]);
        long epoch = mt[2].main.quorumPeer.getAcceptedEpoch();
        for (i = 0; i < 2; ++i) {
            mt[i] = new QuorumPeerTestBase.MainThread(i, clientPorts[i], currentQuorumCfgSection, true, "100000000");
            mt[i].writeTempDynamicConfigFile(nextQuorumCfgSection, "200000000");
            mt[i].start();
            zk[i] = new ZooKeeper("127.0.0.1:" + clientPorts[i], ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        }
        for (i = 0; i < 2; ++i) {
            Assert.assertTrue((String)("waiting for server " + i + " being up"), (boolean)ClientBase.waitForServerUp("127.0.0.1:" + clientPorts[i], ClientBase.CONNECTION_TIMEOUT * 2));
        }
        Assert.assertEquals((long)epoch, (long)mt[0].main.quorumPeer.getAcceptedEpoch());
        Assert.assertEquals((long)epoch, (long)mt[1].main.quorumPeer.getAcceptedEpoch());
        Assert.assertEquals((long)epoch, (long)mt[2].main.quorumPeer.getAcceptedEpoch());
        ReconfigTest.testServerHasConfig(zk[0], allServers, null);
        ReconfigTest.testServerHasConfig(zk[1], allServers, null);
        ReconfigTest.testNormalOperation(zk[0], zk[2]);
        ReconfigTest.testNormalOperation(zk[4], zk[1]);
        for (i = 0; i < 5; ++i) {
            zk[i].close();
            mt[i].shutdown();
        }
    }

    @Test
    public void testObserverConvertedToParticipantDuringFLE() throws Exception {
        int i;
        ClientBase.setupTestEnv();
        int SERVER_COUNT = 4;
        int[][] ports = ReconfigRecoveryTest.generatePorts(4);
        HashSet<Integer> observers = new HashSet<Integer>();
        observers.add(2);
        StringBuilder sb = ReconfigRecoveryTest.generateConfig(3, ports, observers);
        String currentQuorumCfgSection = sb.toString();
        ArrayList<String> allServersNext = new ArrayList<String>();
        sb = new StringBuilder();
        for (int i2 = 2; i2 < 4; ++i2) {
            String server = "server." + i2 + "=localhost:" + ports[i2][0] + ":" + ports[i2][1] + ":participant;localhost:" + ports[i2][2];
            allServersNext.add(server);
            sb.append(server + "\n");
        }
        String nextQuorumCfgSection = sb.toString();
        QuorumPeerTestBase.MainThread[] mt = new QuorumPeerTestBase.MainThread[4];
        ZooKeeper[] zk = new ZooKeeper[4];
        mt[2] = new QuorumPeerTestBase.MainThread(2, ports[2][2], currentQuorumCfgSection, true, "100000000");
        mt[2].start();
        zk[2] = new ZooKeeper("127.0.0.1:" + ports[2][2], ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        mt[3] = new QuorumPeerTestBase.MainThread(3, ports[3][2], nextQuorumCfgSection, true, "200000000");
        mt[3].start();
        zk[3] = new ZooKeeper("127.0.0.1:" + ports[3][2], ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        for (i = 2; i < 4; ++i) {
            Assert.assertTrue((String)("waiting for server " + i + " being up"), (boolean)ClientBase.waitForServerUp("127.0.0.1:" + ports[i][2], ClientBase.CONNECTION_TIMEOUT * 2));
            ReconfigTest.testServerHasConfig(zk[i], allServersNext, null);
        }
        Assert.assertEquals((Object)(nextQuorumCfgSection + "version=200000000"), (Object)ReconfigTest.testServerHasConfig(zk[2], null, null));
        Assert.assertEquals((Object)(nextQuorumCfgSection + "version=200000000"), (Object)ReconfigTest.testServerHasConfig(zk[3], null, null));
        ReconfigTest.testNormalOperation(zk[2], zk[2]);
        ReconfigTest.testNormalOperation(zk[3], zk[2]);
        for (i = 2; i < 4; ++i) {
            zk[i].close();
            mt[i].shutdown();
        }
    }

    @Test
    public void testCurrentObserverIsParticipantInNewConfig() throws Exception {
        int i;
        int i2;
        ClientBase.setupTestEnv();
        int SERVER_COUNT = 4;
        int[][] ports = ReconfigRecoveryTest.generatePorts(4);
        HashSet<Integer> observers = new HashSet<Integer>();
        observers.add(2);
        StringBuilder sb = ReconfigRecoveryTest.generateConfig(3, ports, observers);
        String currentQuorumCfg = sb.toString();
        QuorumPeerTestBase.MainThread[] mt = new QuorumPeerTestBase.MainThread[4];
        ZooKeeper[] zk = new ZooKeeper[4];
        for (i2 = 0; i2 <= 2; ++i2) {
            mt[i2] = new QuorumPeerTestBase.MainThread(i2, ports[i2][2], currentQuorumCfg, true, "100000000");
            mt[i2].start();
            zk[i2] = new ZooKeeper("127.0.0.1:" + ports[i2][2], ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        }
        ReconfigTest.testNormalOperation(zk[0], zk[2]);
        for (i2 = 0; i2 <= 2; ++i2) {
            Assert.assertTrue((String)("waiting for server " + i2 + " being up"), (boolean)ClientBase.waitForServerUp("127.0.0.1:" + ports[i2][2], ClientBase.CONNECTION_TIMEOUT * 2));
        }
        for (i2 = 0; i2 <= 2; ++i2) {
            mt[i2].shutdown();
            zk[i2].close();
        }
        ArrayList<String> allServersNext = new ArrayList<String>();
        sb = new StringBuilder();
        for (i = 2; i < 4; ++i) {
            String server = "server." + i + "=localhost:" + ports[i][0] + ":" + ports[i][1] + ":participant;localhost:" + ports[i][2];
            allServersNext.add(server);
            sb.append(server + "\n");
        }
        String nextQuorumCfgSection = sb.toString();
        for (i = 0; i <= 2; ++i) {
            mt[i].writeTempDynamicConfigFile(nextQuorumCfgSection, "200000000");
            mt[i].start();
            zk[i] = new ZooKeeper("127.0.0.1:" + ports[i][2], ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        }
        mt[3] = new QuorumPeerTestBase.MainThread(3, ports[3][2], currentQuorumCfg + (String)allServersNext.get(1));
        mt[3].start();
        zk[3] = new ZooKeeper("127.0.0.1:" + ports[3][2], ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        for (i = 2; i < 4; ++i) {
            Assert.assertTrue((String)("waiting for server " + i + " being up"), (boolean)ClientBase.waitForServerUp("127.0.0.1:" + ports[i][2], ClientBase.CONNECTION_TIMEOUT * 3));
            ReconfigTest.testServerHasConfig(zk[i], allServersNext, null);
        }
        ReconfigTest.testNormalOperation(zk[0], zk[2]);
        ReconfigTest.testNormalOperation(zk[3], zk[1]);
        Assert.assertEquals((Object)(nextQuorumCfgSection + "version=200000000"), (Object)ReconfigTest.testServerHasConfig(zk[2], null, null));
        Assert.assertEquals((Object)(nextQuorumCfgSection + "version=200000000"), (Object)ReconfigTest.testServerHasConfig(zk[3], null, null));
        for (i = 0; i < 4; ++i) {
            zk[i].close();
            mt[i].shutdown();
        }
    }

    public static int[][] generatePorts(int numServers) {
        int[][] ports = new int[numServers][];
        for (int i = 0; i < numServers; ++i) {
            ports[i] = new int[3];
            for (int j = 0; j < 3; ++j) {
                ports[i][j] = PortAssignment.unique();
            }
        }
        return ports;
    }

    public static StringBuilder generateConfig(int numServers, int[][] ports, HashSet<Integer> observerIds) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numServers; ++i) {
            String server = "server." + i + "=localhost:" + ports[i][0] + ":" + ports[i][1] + ":" + (observerIds.contains(i) ? "observer" : "participant") + ";localhost:" + ports[i][2];
            sb.append(server + "\n");
        }
        return sb;
    }
}

