/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.common.PathUtils;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.QuorumPeerMain;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.QuorumBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuorumPeerTestBase
extends ZKTestCase
implements Watcher {
    protected static final Logger LOG = LoggerFactory.getLogger(QuorumPeerTestBase.class);
    public static final int TIMEOUT = 5000;

    public void process(WatchedEvent event) {
    }

    public static class MainThread
    implements Runnable {
        final File confFile;
        final File tmpDir;
        public static final int UNSET_STATIC_CLIENTPORT = -1;
        public static final int UNSET_MYID = -1;
        volatile TestQPMain main;
        File baseDir;
        private int myid;
        private int clientPort;
        private String quorumCfgSection;
        private Map<String, String> otherConfigs;
        Thread currentThread;

        public MainThread(int myid, int clientPort, String quorumCfgSection, Map<String, String> otherConfigs, int tickTime) throws IOException {
            this.baseDir = ClientBase.createTmpDir();
            this.myid = myid;
            this.clientPort = clientPort;
            this.quorumCfgSection = quorumCfgSection;
            this.otherConfigs = otherConfigs;
            LOG.info("id = " + myid + " tmpDir = " + this.baseDir + " clientPort = " + clientPort);
            this.confFile = new File(this.baseDir, "zoo.cfg");
            FileWriter fwriter = new FileWriter(this.confFile);
            fwriter.write("tickTime=" + tickTime + "\n");
            fwriter.write("initLimit=10\n");
            fwriter.write("syncLimit=5\n");
            this.tmpDir = new File(this.baseDir, "data");
            if (!this.tmpDir.mkdir()) {
                throw new IOException("Unable to mkdir " + this.tmpDir);
            }
            String dir = this.tmpDir.toString();
            String osname = System.getProperty("os.name");
            if (osname.toLowerCase().contains("windows")) {
                dir = dir.replace('\\', '/');
            }
            fwriter.write("dataDir=" + dir + "\n");
            fwriter.write("clientPort=" + clientPort + "\n");
            Set<Map.Entry<String, String>> entrySet = otherConfigs.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                fwriter.write(entry.getKey() + "=" + entry.getValue() + "\n");
            }
            fwriter.write(quorumCfgSection + "\n");
            fwriter.flush();
            fwriter.close();
            File myidFile = new File(this.tmpDir, "myid");
            fwriter = new FileWriter(myidFile);
            fwriter.write(Integer.toString(myid));
            fwriter.flush();
            fwriter.close();
        }

        public MainThread(int myid, String quorumCfgSection) throws IOException {
            this(myid, quorumCfgSection, true);
        }

        public MainThread(int myid, String quorumCfgSection, Integer secureClientPort, boolean writeDynamicConfigFile) throws IOException {
            this(myid, -1, 8080, secureClientPort, quorumCfgSection, null, writeDynamicConfigFile, null);
        }

        public MainThread(int myid, String quorumCfgSection, boolean writeDynamicConfigFile) throws IOException {
            this(myid, -1, quorumCfgSection, writeDynamicConfigFile);
        }

        public MainThread(int myid, int clientPort, String quorumCfgSection, boolean writeDynamicConfigFile) throws IOException {
            this(myid, clientPort, 8080, quorumCfgSection, null, writeDynamicConfigFile);
        }

        public MainThread(int myid, int clientPort, String quorumCfgSection, boolean writeDynamicConfigFile, String version) throws IOException {
            this(myid, clientPort, 8080, quorumCfgSection, null, writeDynamicConfigFile, version);
        }

        public MainThread(int myid, int clientPort, String quorumCfgSection, String configs) throws IOException {
            this(myid, clientPort, 8080, quorumCfgSection, configs, true);
        }

        public MainThread(int myid, int clientPort, int adminServerPort, String quorumCfgSection, String configs) throws IOException {
            this(myid, clientPort, adminServerPort, quorumCfgSection, configs, true);
        }

        public MainThread(int myid, int clientPort, int adminServerPort, String quorumCfgSection, String configs, boolean writeDynamicConfigFile) throws IOException {
            this(myid, clientPort, adminServerPort, quorumCfgSection, configs, writeDynamicConfigFile, null);
        }

        public MainThread(int myid, int clientPort, int adminServerPort, String quorumCfgSection, String configs, boolean writeDynamicConfigFile, String version) throws IOException {
            this(myid, clientPort, adminServerPort, null, quorumCfgSection, configs, writeDynamicConfigFile, version);
        }

        public MainThread(int myid, int clientPort, int adminServerPort, Integer secureClientPort, String quorumCfgSection, String configs, boolean writeDynamicConfigFile, String version) throws IOException {
            this.tmpDir = ClientBase.createTmpDir();
            LOG.info("id = " + myid + " tmpDir = " + this.tmpDir + " clientPort = " + clientPort + " adminServerPort = " + adminServerPort);
            File dataDir = new File(this.tmpDir, "data");
            if (!dataDir.mkdir()) {
                throw new IOException("Unable to mkdir " + dataDir);
            }
            this.confFile = new File(this.tmpDir, "zoo.cfg");
            FileWriter fwriter = new FileWriter(this.confFile);
            fwriter.write("tickTime=4000\n");
            fwriter.write("initLimit=10\n");
            fwriter.write("syncLimit=5\n");
            if (configs != null) {
                fwriter.write(configs);
            }
            String dir = PathUtils.normalizeFileSystemPath((String)dataDir.toString());
            fwriter.write("dataDir=" + dir + "\n");
            fwriter.write("admin.serverPort=" + adminServerPort + "\n");
            if (clientPort != -1) {
                fwriter.write("clientPort=" + clientPort + "\n");
            }
            if (secureClientPort != null) {
                fwriter.write("secureClientPort=" + secureClientPort + "\n");
            }
            if (writeDynamicConfigFile) {
                String dynamicConfigFilename = this.createDynamicFile(quorumCfgSection, version);
                fwriter.write("dynamicConfigFile=" + dynamicConfigFilename + "\n");
            } else {
                fwriter.write(quorumCfgSection);
            }
            fwriter.flush();
            fwriter.close();
            File myidFile = new File(dataDir, "myid");
            fwriter = new FileWriter(myidFile);
            fwriter.write(Integer.toString(myid));
            fwriter.flush();
            fwriter.close();
        }

        private String createDynamicFile(String quorumCfgSection, String version) throws IOException {
            String filename = "zoo.cfg.dynamic";
            if (version != null) {
                filename = filename + "." + version;
            }
            File dynamicConfigFile = new File(this.tmpDir, filename);
            String dynamicConfigFilename = PathUtils.normalizeFileSystemPath((String)dynamicConfigFile.toString());
            FileWriter fDynamicConfigWriter = new FileWriter(dynamicConfigFile);
            fDynamicConfigWriter.write(quorumCfgSection);
            fDynamicConfigWriter.flush();
            fDynamicConfigWriter.close();
            return dynamicConfigFilename;
        }

        public File[] getDynamicFiles() {
            return this.getFilesWithPrefix("zoo.cfg.dynamic");
        }

        public File[] getFilesWithPrefix(final String prefix) {
            return this.tmpDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(prefix);
                }
            });
        }

        public File getFileByName(String filename) {
            File f = new File(this.tmpDir.getPath(), filename);
            return f.isFile() ? f : null;
        }

        public void writeTempDynamicConfigFile(String nextQuorumCfgSection, String version) throws IOException {
            File nextDynamicConfigFile = new File(this.tmpDir, "zoo.cfg.dynamic.next");
            FileWriter fwriter = new FileWriter(nextDynamicConfigFile);
            fwriter.write(nextQuorumCfgSection + "\nversion=" + version);
            fwriter.flush();
            fwriter.close();
        }

        public MainThread(int myid, int clientPort, String quorumCfgSection) throws IOException {
            this(myid, clientPort, quorumCfgSection, new HashMap<String, String>());
        }

        public MainThread(int myid, int clientPort, String quorumCfgSection, Map<String, String> otherConfigs) throws IOException {
            this(myid, clientPort, quorumCfgSection, otherConfigs, 4000);
        }

        public synchronized void start() {
            this.main = this.getTestQPMain();
            this.currentThread = new Thread(this);
            this.currentThread.start();
        }

        public TestQPMain getTestQPMain() {
            return new TestQPMain();
        }

        @Override
        public void run() {
            String[] args = new String[]{this.confFile.toString()};
            try {
                this.main.initializeAndRun(args);
            }
            catch (Exception e) {
                LOG.error("unexpected exception in run", (Throwable)e);
            }
            finally {
                this.currentThread = null;
            }
        }

        public void shutdown() throws InterruptedException {
            Thread t = this.currentThread;
            if (t != null && t.isAlive()) {
                this.main.shutdown();
                t.join(500L);
            }
        }

        public void join(long timeout) throws InterruptedException {
            Thread t = this.currentThread;
            if (t != null) {
                t.join(timeout);
            }
        }

        public boolean isAlive() {
            Thread t = this.currentThread;
            return t != null && t.isAlive();
        }

        public void clean() {
            ClientBase.recursiveDelete(this.main.quorumPeer.getTxnFactory().getDataDir());
        }

        public boolean isQuorumPeerRunning() {
            return this.main.quorumPeer != null;
        }

        public String getPropFromStaticFile(String key) throws IOException {
            Properties props = new Properties();
            props.load(new FileReader(this.confFile));
            return props.getProperty(key, "");
        }

        public QuorumPeer getQuorumPeer() {
            return this.main.quorumPeer;
        }

        public void deleteBaseDir() {
            ClientBase.recursiveDelete(this.baseDir);
        }

        public int getMyid() {
            return this.myid;
        }

        public int getClientPort() {
            return this.clientPort;
        }

        public String getQuorumCfgSection() {
            return this.quorumCfgSection;
        }

        public Map<String, String> getOtherConfigs() {
            return this.otherConfigs;
        }

        public File getConfFile() {
            return this.confFile;
        }
    }

    public static class TestQPMain
    extends QuorumPeerMain {
        public void shutdown() {
            if (this.quorumPeer != null) {
                QuorumBase.shutdown(this.quorumPeer);
            }
        }
    }
}

