/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.HashMap;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.Vote;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Assert;
import org.junit.Test;

public class QuorumPeerTest {
    private int electionAlg = 3;
    private int tickTime = 2000;
    private int initLimit = 3;
    private int syncLimit = 3;

    @Test
    public void testQuorumPeerListendOnSpecifiedClientIP() throws IOException {
        long myId = 1L;
        File dataDir = ClientBase.createTmpDir();
        int clientPort = PortAssignment.unique();
        HashMap<Long, QuorumPeer.QuorumServer> peersView = new HashMap<Long, QuorumPeer.QuorumServer>();
        InetAddress clientIP = InetAddress.getLoopbackAddress();
        peersView.put(myId, new QuorumPeer.QuorumServer(myId, new InetSocketAddress(clientIP, PortAssignment.unique()), new InetSocketAddress(clientIP, PortAssignment.unique()), new InetSocketAddress(clientIP, clientPort), QuorumPeer.LearnerType.PARTICIPANT));
        QuorumPeer peer1 = new QuorumPeer(peersView, dataDir, dataDir, clientPort, this.electionAlg, myId, this.tickTime, this.initLimit, this.syncLimit);
        String hostString1 = peer1.cnxnFactory.getLocalAddress().getHostString();
        Assert.assertEquals((Object)clientIP.getHostAddress(), (Object)hostString1);
        peer1.shutdown();
        peersView.clear();
        clientPort = PortAssignment.unique();
        peersView.put(myId, new QuorumPeer.QuorumServer(myId, new InetSocketAddress(clientIP, PortAssignment.unique()), new InetSocketAddress(clientIP, PortAssignment.unique()), new InetSocketAddress(clientIP, clientPort), QuorumPeer.LearnerType.PARTICIPANT));
        QuorumPeer peer2 = new QuorumPeer(peersView, dataDir, dataDir, clientPort, this.electionAlg, myId, this.tickTime, this.initLimit, this.syncLimit);
        String hostString2 = peer2.cnxnFactory.getLocalAddress().getHostString();
        Assert.assertEquals((Object)clientIP.getHostAddress(), (Object)hostString2);
        peer2.shutdown();
    }

    @Test
    public void testLocalPeerIsLeader() throws Exception {
        long localPeerId = 7L;
        QuorumPeer peer = new QuorumPeer();
        peer.setId(localPeerId);
        Vote voteLocalPeerIsLeader = new Vote(localPeerId, 0L);
        peer.setCurrentVote(voteLocalPeerIsLeader);
        Assert.assertTrue((boolean)peer.isLeader(localPeerId));
    }

    @Test
    public void testLocalPeerIsNotLeader() throws Exception {
        long localPeerId = 7L;
        long otherPeerId = 17L;
        QuorumPeer peer = new QuorumPeer();
        peer.setId(localPeerId);
        Vote voteLocalPeerIsNotLeader = new Vote(otherPeerId, 0L);
        peer.setCurrentVote(voteLocalPeerIsNotLeader);
        Assert.assertFalse((boolean)peer.isLeader(localPeerId));
    }

    @Test
    public void testIsNotLeaderBecauseNoVote() throws Exception {
        long localPeerId = 7L;
        QuorumPeer peer = new QuorumPeer();
        peer.setId(localPeerId);
        peer.setCurrentVote(null);
        Assert.assertFalse((boolean)peer.isLeader(localPeerId));
    }
}

