/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.File;
import java.net.InetSocketAddress;
import java.util.HashMap;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.server.quorum.FastLeaderElection;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.Vote;
import org.apache.zookeeper.server.util.ZxidUtils;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FLEOutOfElectionTest {
    private FastLeaderElection fle;

    @Before
    public void setUp() throws Exception {
        File tmpdir = ClientBase.createTmpDir();
        HashMap<Long, QuorumPeer.QuorumServer> peers = new HashMap<Long, QuorumPeer.QuorumServer>();
        for (int i = 0; i < 5; ++i) {
            peers.put(Long.valueOf(i), new QuorumPeer.QuorumServer(Long.valueOf(i).longValue(), new InetSocketAddress("127.0.0.1", PortAssignment.unique())));
        }
        QuorumPeer peer = new QuorumPeer(peers, tmpdir, tmpdir, PortAssignment.unique(), 3, 3L, 1000, 2, 2);
        this.fle = new FastLeaderElection(peer, peer.createCnxnManager());
    }

    @Test
    public void testIgnoringZxidElectionEpoch() {
        HashMap<Long, Vote> votes = new HashMap<Long, Vote>();
        votes.put(0L, new Vote(1, 4L, ZxidUtils.makeZxid((long)1L, (long)1L), 1L, 2L, QuorumPeer.ServerState.FOLLOWING));
        votes.put(1L, new Vote(1, 4L, ZxidUtils.makeZxid((long)1L, (long)2L), 1L, 2L, QuorumPeer.ServerState.FOLLOWING));
        votes.put(3L, new Vote(1, 4L, ZxidUtils.makeZxid((long)2L, (long)1L), 2L, 2L, QuorumPeer.ServerState.FOLLOWING));
        votes.put(4L, new Vote(1, 4L, ZxidUtils.makeZxid((long)2L, (long)1L), 2L, 2L, QuorumPeer.ServerState.LEADING));
        Assert.assertTrue((boolean)this.fle.termPredicate(votes, new Vote(4L, ZxidUtils.makeZxid((long)2L, (long)1L), 2L, 2L, QuorumPeer.ServerState.FOLLOWING)));
    }

    @Test
    public void testElectionWIthDifferentVersion() {
        HashMap<Long, Vote> votes = new HashMap<Long, Vote>();
        votes.put(0L, new Vote(1, 4L, ZxidUtils.makeZxid((long)1L, (long)1L), 1L, 1L, QuorumPeer.ServerState.FOLLOWING));
        votes.put(1L, new Vote(1, 4L, ZxidUtils.makeZxid((long)1L, (long)1L), 1L, 1L, QuorumPeer.ServerState.FOLLOWING));
        votes.put(3L, new Vote(4L, ZxidUtils.makeZxid((long)2L, (long)1L), 2L, 2L, QuorumPeer.ServerState.FOLLOWING));
        votes.put(4L, new Vote(4L, ZxidUtils.makeZxid((long)2L, (long)1L), 2L, 2L, QuorumPeer.ServerState.LEADING));
        Assert.assertTrue((boolean)this.fle.termPredicate(votes, new Vote(4L, ZxidUtils.makeZxid((long)2L, (long)1L), 2L, 2L, QuorumPeer.ServerState.FOLLOWING)));
    }

    @Test
    public void testLookingNormal() {
        HashMap<Long, Vote> votes = new HashMap<Long, Vote>();
        votes.put(0L, new Vote(4L, ZxidUtils.makeZxid((long)2L, (long)1L), 1L, 1L, QuorumPeer.ServerState.LOOKING));
        votes.put(1L, new Vote(4L, ZxidUtils.makeZxid((long)2L, (long)1L), 1L, 1L, QuorumPeer.ServerState.LOOKING));
        votes.put(3L, new Vote(4L, ZxidUtils.makeZxid((long)2L, (long)1L), 1L, 1L, QuorumPeer.ServerState.LOOKING));
        votes.put(4L, new Vote(4L, ZxidUtils.makeZxid((long)2L, (long)1L), 1L, 1L, QuorumPeer.ServerState.LEADING));
        Assert.assertTrue((boolean)this.fle.termPredicate(votes, new Vote(4L, ZxidUtils.makeZxid((long)2L, (long)1L), 1L, 1L, QuorumPeer.ServerState.LOOKING)));
    }

    @Test
    public void testLookingDiffRounds() {
        HashMap<Long, Vote> votes = new HashMap<Long, Vote>();
        votes.put(0L, new Vote(4L, ZxidUtils.makeZxid((long)1L, (long)1L), 1L, 1L, QuorumPeer.ServerState.LOOKING));
        votes.put(1L, new Vote(4L, ZxidUtils.makeZxid((long)2L, (long)1L), 2L, 2L, QuorumPeer.ServerState.LOOKING));
        votes.put(3L, new Vote(4L, ZxidUtils.makeZxid((long)2L, (long)1L), 3L, 2L, QuorumPeer.ServerState.LOOKING));
        votes.put(4L, new Vote(4L, ZxidUtils.makeZxid((long)2L, (long)1L), 3L, 2L, QuorumPeer.ServerState.LEADING));
        Assert.assertFalse((boolean)this.fle.termPredicate(votes, new Vote(4L, ZxidUtils.makeZxid((long)2L, (long)1L), 2L, 2L, QuorumPeer.ServerState.LOOKING)));
    }

    @Test
    public void testOutofElection() {
        HashMap<Long, Vote> outofelection = new HashMap<Long, Vote>();
        outofelection.put(1L, new Vote(0, 5L, ZxidUtils.makeZxid((long)15L, (long)0L), 10L, 23L, QuorumPeer.ServerState.FOLLOWING));
        outofelection.put(2L, new Vote(0, 5L, ZxidUtils.makeZxid((long)15L, (long)0L), 10L, 23L, QuorumPeer.ServerState.FOLLOWING));
        outofelection.put(4L, new Vote(1, 5L, ZxidUtils.makeZxid((long)15L, (long)0L), 10L, 24L, QuorumPeer.ServerState.FOLLOWING));
        Vote vote = new Vote(1, 5L, ZxidUtils.makeZxid((long)15L, (long)0L), 10L, 24L, QuorumPeer.ServerState.LEADING);
        outofelection.put(5L, vote);
        FastLeaderElection.Notification n = new FastLeaderElection.Notification();
        n.version = vote.getVersion();
        n.leader = vote.getId();
        n.zxid = vote.getZxid();
        n.electionEpoch = vote.getElectionEpoch();
        n.state = vote.getState();
        n.peerEpoch = vote.getPeerEpoch();
        n.sid = 5L;
        this.fle.logicalclock.set(1L);
        Assert.assertTrue((String)"Quorum check failed", (boolean)this.fle.termPredicate(outofelection, new Vote(n.version, n.leader, n.zxid, n.electionEpoch, n.peerEpoch, n.state)));
        Assert.assertTrue((String)"Leader check failed", (boolean)this.fle.checkLeader(outofelection, n.leader, n.electionEpoch));
    }
}

