/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.server.NettyServerCnxn;
import org.apache.zookeeper.server.NettyServerCnxnFactory;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.quorum.BufferStats;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.TestByteBufAllocator;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyServerCnxnTest
extends ClientBase {
    private static final Logger LOG = LoggerFactory.getLogger(NettyServerCnxnTest.class);

    @Override
    public void setUp() throws Exception {
        System.setProperty("zookeeper.serverCnxnFactory", "org.apache.zookeeper.server.NettyServerCnxnFactory");
        NettyServerCnxnFactory.setTestAllocator((ByteBufAllocator)TestByteBufAllocator.getInstance());
        super.setUp();
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        NettyServerCnxnFactory.clearTestAllocator();
        TestByteBufAllocator.checkForLeaks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=40000L)
    public void testSendCloseSession() throws Exception {
        Assert.assertTrue((String)"Didn't instantiate ServerCnxnFactory with NettyServerCnxnFactory!", (boolean)(this.serverFactory instanceof NettyServerCnxnFactory));
        TestableZooKeeper zk = this.createClient();
        ZooKeeperServer zkServer = NettyServerCnxnTest.getServer(this.serverFactory);
        String path = "/a";
        try {
            zk.create("/a", "test".getBytes(StandardCharsets.UTF_8), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            Assert.assertNotNull((String)"Didn't create znode:/a", (Object)zk.exists("/a", true));
            Assert.assertEquals((long)1L, (long)zkServer.getZKDatabase().getDataTree().getWatchCount());
            Iterable connections = this.serverFactory.getConnections();
            Assert.assertEquals((String)"Mismatch in number of live connections!", (long)1L, (long)this.serverFactory.getNumAliveConnections());
            for (ServerCnxn serverCnxn : connections) {
                serverCnxn.sendCloseSession();
            }
            LOG.info("Waiting for the channel disconnected event");
            int timeout = 0;
            while (this.serverFactory.getNumAliveConnections() != 0) {
                Thread.sleep(1000L);
                if ((timeout += 1000) <= CONNECTION_TIMEOUT) continue;
                Assert.fail((String)"The number of live connections should be 0");
            }
            Assert.assertEquals((long)0L, (long)zkServer.getZKDatabase().getDataTree().getWatchCount());
        }
        finally {
            zk.close();
        }
    }

    @Test
    public void testClientResponseStatsUpdate() throws IOException, InterruptedException, KeeperException {
        try (TestableZooKeeper zk = this.createClient();){
            BufferStats clientResponseStats = this.serverFactory.getZooKeeperServer().serverStats().getClientResponseStats();
            Assert.assertThat((String)"Last client response size should be initialized with INIT_VALUE", (Object)clientResponseStats.getLastBufferSize(), (Matcher)Matchers.equalTo((Object)-1));
            zk.create("/a", "test".getBytes(StandardCharsets.UTF_8), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            Assert.assertThat((String)"Last client response size should be greater than 0 after client request was performed", (Object)clientResponseStats.getLastBufferSize(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
            byte[] contents = zk.getData("/a", null, null);
            Assert.assertArrayEquals((String)"unexpected data", (byte[])"test".getBytes(StandardCharsets.UTF_8), (byte[])contents);
        }
    }

    @Test
    public void testServerSideThrottling() throws IOException, InterruptedException, KeeperException {
        try (TestableZooKeeper zk = this.createClient();){
            BufferStats clientResponseStats = this.serverFactory.getZooKeeperServer().serverStats().getClientResponseStats();
            Assert.assertThat((String)"Last client response size should be initialized with INIT_VALUE", (Object)clientResponseStats.getLastBufferSize(), (Matcher)Matchers.equalTo((Object)-1));
            zk.create("/a", "test".getBytes(StandardCharsets.UTF_8), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            Assert.assertThat((String)"Last client response size should be greater than 0 after client request was performed", (Object)clientResponseStats.getLastBufferSize(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
            for (ServerCnxn cnxn : this.serverFactory.cnxns) {
                final NettyServerCnxn nettyCnxn = (NettyServerCnxn)cnxn;
                nettyCnxn.disableRecv();
                nettyCnxn.getChannel().eventLoop().schedule(new Runnable(){

                    @Override
                    public void run() {
                        nettyCnxn.getChannel().read();
                    }
                }, 1L, TimeUnit.SECONDS);
                nettyCnxn.getChannel().eventLoop().schedule(new Runnable(){

                    @Override
                    public void run() {
                        nettyCnxn.enableRecv();
                    }
                }, 2L, TimeUnit.SECONDS);
            }
            byte[] contents = zk.getData("/a", null, null);
            Assert.assertArrayEquals((String)"unexpected data", (byte[])"test".getBytes(StandardCharsets.UTF_8), (byte[])contents);
            for (ServerCnxn cnxn : this.serverFactory.cnxns) {
                final NettyServerCnxn nettyCnxn = (NettyServerCnxn)cnxn;
                nettyCnxn.disableRecv();
                nettyCnxn.getChannel().eventLoop().schedule(new Runnable(){

                    @Override
                    public void run() {
                        nettyCnxn.enableRecv();
                    }
                }, 2L, TimeUnit.SECONDS);
            }
            contents = zk.getData("/a", null, null);
            Assert.assertArrayEquals((String)"unexpected data", (byte[])"test".getBytes(StandardCharsets.UTF_8), (byte[])contents);
        }
    }
}

