/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.waf.model.waf.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.waf.model.RuleUpdate;
import com.amazonaws.services.waf.model.UpdateRuleRequest;
import com.amazonaws.services.waf.model.waf.transform.RuleUpdateJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;

public class UpdateRuleRequestMarshaller
implements Marshaller<Request<UpdateRuleRequest>, UpdateRuleRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public UpdateRuleRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<UpdateRuleRequest> marshall(UpdateRuleRequest updateRuleRequest) {
        if (updateRuleRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateRuleRequest> request = new DefaultRequest<UpdateRuleRequest>(updateRuleRequest, "AWSWAF");
        request.addHeader("X-Amz-Target", "AWSWAF_20150824.UpdateRule");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<RuleUpdate> updatesList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (updateRuleRequest.getRuleId() != null) {
                jsonGenerator.writeFieldName("RuleId").writeValue(updateRuleRequest.getRuleId());
            }
            if (updateRuleRequest.getChangeToken() != null) {
                jsonGenerator.writeFieldName("ChangeToken").writeValue(updateRuleRequest.getChangeToken());
            }
            if ((updatesList = updateRuleRequest.getUpdates()) != null) {
                jsonGenerator.writeFieldName("Updates");
                jsonGenerator.writeStartArray();
                for (RuleUpdate updatesListValue : updatesList) {
                    if (updatesListValue == null) continue;
                    RuleUpdateJsonMarshaller.getInstance().marshall(updatesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

