/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.storagegateway.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.storagegateway.model.ListFileSharesRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ListFileSharesRequestMarshaller
implements Marshaller<Request<ListFileSharesRequest>, ListFileSharesRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public ListFileSharesRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListFileSharesRequest> marshall(ListFileSharesRequest listFileSharesRequest) {
        if (listFileSharesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListFileSharesRequest> request = new DefaultRequest<ListFileSharesRequest>(listFileSharesRequest, "AWSStorageGateway");
        request.addHeader("X-Amz-Target", "StorageGateway_20130630.ListFileShares");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listFileSharesRequest.getGatewayARN() != null) {
                jsonGenerator.writeFieldName("GatewayARN").writeValue(listFileSharesRequest.getGatewayARN());
            }
            if (listFileSharesRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(listFileSharesRequest.getLimit());
            }
            if (listFileSharesRequest.getMarker() != null) {
                jsonGenerator.writeFieldName("Marker").writeValue(listFileSharesRequest.getMarker());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

