/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.services.pinpoint.model.GetCampaignVersionsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class GetCampaignVersionsRequestMarshaller
implements Marshaller<Request<GetCampaignVersionsRequest>, GetCampaignVersionsRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public GetCampaignVersionsRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetCampaignVersionsRequest> marshall(GetCampaignVersionsRequest getCampaignVersionsRequest) {
        if (getCampaignVersionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetCampaignVersionsRequest> request = new DefaultRequest<GetCampaignVersionsRequest>(getCampaignVersionsRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/v1/apps/{application-id}/campaigns/{campaign-id}/versions";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "application-id", getCampaignVersionsRequest.getApplicationId());
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "campaign-id", getCampaignVersionsRequest.getCampaignId());
        request.setResourcePath(uriResourcePath);
        if (getCampaignVersionsRequest.getPageSize() != null) {
            request.addParameter("page-size", StringUtils.fromString(getCampaignVersionsRequest.getPageSize()));
        }
        if (getCampaignVersionsRequest.getToken() != null) {
            request.addParameter("token", StringUtils.fromString(getCampaignVersionsRequest.getToken()));
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

