/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.services.pinpoint.model.GetCampaignVersionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import java.io.ByteArrayInputStream;

public class GetCampaignVersionRequestMarshaller
implements Marshaller<Request<GetCampaignVersionRequest>, GetCampaignVersionRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public GetCampaignVersionRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetCampaignVersionRequest> marshall(GetCampaignVersionRequest getCampaignVersionRequest) {
        if (getCampaignVersionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetCampaignVersionRequest> request = new DefaultRequest<GetCampaignVersionRequest>(getCampaignVersionRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/v1/apps/{application-id}/campaigns/{campaign-id}/versions/{version}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "application-id", getCampaignVersionRequest.getApplicationId());
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "campaign-id", getCampaignVersionRequest.getCampaignId());
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "version", getCampaignVersionRequest.getVersion());
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

