/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model;

import com.amazonaws.services.pinpoint.model.AttributeDimension;
import com.amazonaws.services.pinpoint.model.SegmentBehaviors;
import com.amazonaws.services.pinpoint.model.SegmentDemographics;
import com.amazonaws.services.pinpoint.model.SegmentLocation;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class SegmentDimensions
implements Serializable,
Cloneable {
    private Map<String, AttributeDimension> attributes;
    private SegmentBehaviors behavior;
    private SegmentDemographics demographic;
    private SegmentLocation location;

    public Map<String, AttributeDimension> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, AttributeDimension> attributes) {
        this.attributes = attributes;
    }

    public SegmentDimensions withAttributes(Map<String, AttributeDimension> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public SegmentDimensions addAttributesEntry(String key, AttributeDimension value) {
        if (null == this.attributes) {
            this.attributes = new HashMap<String, AttributeDimension>();
        }
        if (this.attributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.attributes.put(key, value);
        return this;
    }

    public SegmentDimensions clearAttributesEntries() {
        this.attributes = null;
        return this;
    }

    public void setBehavior(SegmentBehaviors behavior) {
        this.behavior = behavior;
    }

    public SegmentBehaviors getBehavior() {
        return this.behavior;
    }

    public SegmentDimensions withBehavior(SegmentBehaviors behavior) {
        this.setBehavior(behavior);
        return this;
    }

    public void setDemographic(SegmentDemographics demographic) {
        this.demographic = demographic;
    }

    public SegmentDemographics getDemographic() {
        return this.demographic;
    }

    public SegmentDimensions withDemographic(SegmentDemographics demographic) {
        this.setDemographic(demographic);
        return this;
    }

    public void setLocation(SegmentLocation location) {
        this.location = location;
    }

    public SegmentLocation getLocation() {
        return this.location;
    }

    public SegmentDimensions withLocation(SegmentLocation location) {
        this.setLocation(location);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAttributes() != null) {
            sb.append("Attributes: ").append(this.getAttributes()).append(",");
        }
        if (this.getBehavior() != null) {
            sb.append("Behavior: ").append(this.getBehavior()).append(",");
        }
        if (this.getDemographic() != null) {
            sb.append("Demographic: ").append(this.getDemographic()).append(",");
        }
        if (this.getLocation() != null) {
            sb.append("Location: ").append(this.getLocation());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SegmentDimensions)) {
            return false;
        }
        SegmentDimensions other = (SegmentDimensions)obj;
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        if (other.getAttributes() != null && !other.getAttributes().equals(this.getAttributes())) {
            return false;
        }
        if (other.getBehavior() == null ^ this.getBehavior() == null) {
            return false;
        }
        if (other.getBehavior() != null && !other.getBehavior().equals(this.getBehavior())) {
            return false;
        }
        if (other.getDemographic() == null ^ this.getDemographic() == null) {
            return false;
        }
        if (other.getDemographic() != null && !other.getDemographic().equals(this.getDemographic())) {
            return false;
        }
        if (other.getLocation() == null ^ this.getLocation() == null) {
            return false;
        }
        return other.getLocation() == null || other.getLocation().equals(this.getLocation());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getBehavior() == null ? 0 : this.getBehavior().hashCode());
        hashCode = 31 * hashCode + (this.getDemographic() == null ? 0 : this.getDemographic().hashCode());
        hashCode = 31 * hashCode + (this.getLocation() == null ? 0 : this.getLocation().hashCode());
        return hashCode;
    }

    public SegmentDimensions clone() {
        try {
            return (SegmentDimensions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

