/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.machinelearning.AmazonMachineLearningAsync;
import com.amazonaws.services.machinelearning.AmazonMachineLearningClient;
import com.amazonaws.services.machinelearning.model.AddTagsRequest;
import com.amazonaws.services.machinelearning.model.AddTagsResult;
import com.amazonaws.services.machinelearning.model.CreateBatchPredictionRequest;
import com.amazonaws.services.machinelearning.model.CreateBatchPredictionResult;
import com.amazonaws.services.machinelearning.model.CreateDataSourceFromRDSRequest;
import com.amazonaws.services.machinelearning.model.CreateDataSourceFromRDSResult;
import com.amazonaws.services.machinelearning.model.CreateDataSourceFromRedshiftRequest;
import com.amazonaws.services.machinelearning.model.CreateDataSourceFromRedshiftResult;
import com.amazonaws.services.machinelearning.model.CreateDataSourceFromS3Request;
import com.amazonaws.services.machinelearning.model.CreateDataSourceFromS3Result;
import com.amazonaws.services.machinelearning.model.CreateEvaluationRequest;
import com.amazonaws.services.machinelearning.model.CreateEvaluationResult;
import com.amazonaws.services.machinelearning.model.CreateMLModelRequest;
import com.amazonaws.services.machinelearning.model.CreateMLModelResult;
import com.amazonaws.services.machinelearning.model.CreateRealtimeEndpointRequest;
import com.amazonaws.services.machinelearning.model.CreateRealtimeEndpointResult;
import com.amazonaws.services.machinelearning.model.DeleteBatchPredictionRequest;
import com.amazonaws.services.machinelearning.model.DeleteBatchPredictionResult;
import com.amazonaws.services.machinelearning.model.DeleteDataSourceRequest;
import com.amazonaws.services.machinelearning.model.DeleteDataSourceResult;
import com.amazonaws.services.machinelearning.model.DeleteEvaluationRequest;
import com.amazonaws.services.machinelearning.model.DeleteEvaluationResult;
import com.amazonaws.services.machinelearning.model.DeleteMLModelRequest;
import com.amazonaws.services.machinelearning.model.DeleteMLModelResult;
import com.amazonaws.services.machinelearning.model.DeleteRealtimeEndpointRequest;
import com.amazonaws.services.machinelearning.model.DeleteRealtimeEndpointResult;
import com.amazonaws.services.machinelearning.model.DeleteTagsRequest;
import com.amazonaws.services.machinelearning.model.DeleteTagsResult;
import com.amazonaws.services.machinelearning.model.DescribeBatchPredictionsRequest;
import com.amazonaws.services.machinelearning.model.DescribeBatchPredictionsResult;
import com.amazonaws.services.machinelearning.model.DescribeDataSourcesRequest;
import com.amazonaws.services.machinelearning.model.DescribeDataSourcesResult;
import com.amazonaws.services.machinelearning.model.DescribeEvaluationsRequest;
import com.amazonaws.services.machinelearning.model.DescribeEvaluationsResult;
import com.amazonaws.services.machinelearning.model.DescribeMLModelsRequest;
import com.amazonaws.services.machinelearning.model.DescribeMLModelsResult;
import com.amazonaws.services.machinelearning.model.DescribeTagsRequest;
import com.amazonaws.services.machinelearning.model.DescribeTagsResult;
import com.amazonaws.services.machinelearning.model.GetBatchPredictionRequest;
import com.amazonaws.services.machinelearning.model.GetBatchPredictionResult;
import com.amazonaws.services.machinelearning.model.GetDataSourceRequest;
import com.amazonaws.services.machinelearning.model.GetDataSourceResult;
import com.amazonaws.services.machinelearning.model.GetEvaluationRequest;
import com.amazonaws.services.machinelearning.model.GetEvaluationResult;
import com.amazonaws.services.machinelearning.model.GetMLModelRequest;
import com.amazonaws.services.machinelearning.model.GetMLModelResult;
import com.amazonaws.services.machinelearning.model.PredictRequest;
import com.amazonaws.services.machinelearning.model.PredictResult;
import com.amazonaws.services.machinelearning.model.UpdateBatchPredictionRequest;
import com.amazonaws.services.machinelearning.model.UpdateBatchPredictionResult;
import com.amazonaws.services.machinelearning.model.UpdateDataSourceRequest;
import com.amazonaws.services.machinelearning.model.UpdateDataSourceResult;
import com.amazonaws.services.machinelearning.model.UpdateEvaluationRequest;
import com.amazonaws.services.machinelearning.model.UpdateEvaluationResult;
import com.amazonaws.services.machinelearning.model.UpdateMLModelRequest;
import com.amazonaws.services.machinelearning.model.UpdateMLModelResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonMachineLearningAsyncClient
extends AmazonMachineLearningClient
implements AmazonMachineLearningAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AmazonMachineLearningAsyncClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AmazonMachineLearningAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonMachineLearningAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonMachineLearningAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonMachineLearningAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AmazonMachineLearningAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonMachineLearningAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonMachineLearningAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonMachineLearningAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    AmazonMachineLearningAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AddTagsResult> addTagsAsync(AddTagsRequest request) {
        return this.addTagsAsync(request, null);
    }

    @Override
    public Future<AddTagsResult> addTagsAsync(final AddTagsRequest request, final AsyncHandler<AddTagsRequest, AddTagsResult> asyncHandler) {
        return this.executorService.submit(new Callable<AddTagsResult>(){

            @Override
            public AddTagsResult call() throws Exception {
                AddTagsResult result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.addTags(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateBatchPredictionResult> createBatchPredictionAsync(CreateBatchPredictionRequest request) {
        return this.createBatchPredictionAsync(request, null);
    }

    @Override
    public Future<CreateBatchPredictionResult> createBatchPredictionAsync(final CreateBatchPredictionRequest request, final AsyncHandler<CreateBatchPredictionRequest, CreateBatchPredictionResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateBatchPredictionResult>(){

            @Override
            public CreateBatchPredictionResult call() throws Exception {
                CreateBatchPredictionResult result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.createBatchPrediction(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateDataSourceFromRDSResult> createDataSourceFromRDSAsync(CreateDataSourceFromRDSRequest request) {
        return this.createDataSourceFromRDSAsync(request, null);
    }

    @Override
    public Future<CreateDataSourceFromRDSResult> createDataSourceFromRDSAsync(final CreateDataSourceFromRDSRequest request, final AsyncHandler<CreateDataSourceFromRDSRequest, CreateDataSourceFromRDSResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateDataSourceFromRDSResult>(){

            @Override
            public CreateDataSourceFromRDSResult call() throws Exception {
                CreateDataSourceFromRDSResult result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.createDataSourceFromRDS(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateDataSourceFromRedshiftResult> createDataSourceFromRedshiftAsync(CreateDataSourceFromRedshiftRequest request) {
        return this.createDataSourceFromRedshiftAsync(request, null);
    }

    @Override
    public Future<CreateDataSourceFromRedshiftResult> createDataSourceFromRedshiftAsync(final CreateDataSourceFromRedshiftRequest request, final AsyncHandler<CreateDataSourceFromRedshiftRequest, CreateDataSourceFromRedshiftResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateDataSourceFromRedshiftResult>(){

            @Override
            public CreateDataSourceFromRedshiftResult call() throws Exception {
                CreateDataSourceFromRedshiftResult result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.createDataSourceFromRedshift(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateDataSourceFromS3Result> createDataSourceFromS3Async(CreateDataSourceFromS3Request request) {
        return this.createDataSourceFromS3Async(request, null);
    }

    @Override
    public Future<CreateDataSourceFromS3Result> createDataSourceFromS3Async(final CreateDataSourceFromS3Request request, final AsyncHandler<CreateDataSourceFromS3Request, CreateDataSourceFromS3Result> asyncHandler) {
        return this.executorService.submit(new Callable<CreateDataSourceFromS3Result>(){

            @Override
            public CreateDataSourceFromS3Result call() throws Exception {
                CreateDataSourceFromS3Result result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.createDataSourceFromS3(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateEvaluationResult> createEvaluationAsync(CreateEvaluationRequest request) {
        return this.createEvaluationAsync(request, null);
    }

    @Override
    public Future<CreateEvaluationResult> createEvaluationAsync(final CreateEvaluationRequest request, final AsyncHandler<CreateEvaluationRequest, CreateEvaluationResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateEvaluationResult>(){

            @Override
            public CreateEvaluationResult call() throws Exception {
                CreateEvaluationResult result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.createEvaluation(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateMLModelResult> createMLModelAsync(CreateMLModelRequest request) {
        return this.createMLModelAsync(request, null);
    }

    @Override
    public Future<CreateMLModelResult> createMLModelAsync(final CreateMLModelRequest request, final AsyncHandler<CreateMLModelRequest, CreateMLModelResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateMLModelResult>(){

            @Override
            public CreateMLModelResult call() throws Exception {
                CreateMLModelResult result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.createMLModel(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateRealtimeEndpointResult> createRealtimeEndpointAsync(CreateRealtimeEndpointRequest request) {
        return this.createRealtimeEndpointAsync(request, null);
    }

    @Override
    public Future<CreateRealtimeEndpointResult> createRealtimeEndpointAsync(final CreateRealtimeEndpointRequest request, final AsyncHandler<CreateRealtimeEndpointRequest, CreateRealtimeEndpointResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateRealtimeEndpointResult>(){

            @Override
            public CreateRealtimeEndpointResult call() throws Exception {
                CreateRealtimeEndpointResult result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.createRealtimeEndpoint(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteBatchPredictionResult> deleteBatchPredictionAsync(DeleteBatchPredictionRequest request) {
        return this.deleteBatchPredictionAsync(request, null);
    }

    @Override
    public Future<DeleteBatchPredictionResult> deleteBatchPredictionAsync(final DeleteBatchPredictionRequest request, final AsyncHandler<DeleteBatchPredictionRequest, DeleteBatchPredictionResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteBatchPredictionResult>(){

            @Override
            public DeleteBatchPredictionResult call() throws Exception {
                DeleteBatchPredictionResult result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.deleteBatchPrediction(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDataSourceResult> deleteDataSourceAsync(DeleteDataSourceRequest request) {
        return this.deleteDataSourceAsync(request, null);
    }

    @Override
    public Future<DeleteDataSourceResult> deleteDataSourceAsync(final DeleteDataSourceRequest request, final AsyncHandler<DeleteDataSourceRequest, DeleteDataSourceResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteDataSourceResult>(){

            @Override
            public DeleteDataSourceResult call() throws Exception {
                DeleteDataSourceResult result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.deleteDataSource(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteEvaluationResult> deleteEvaluationAsync(DeleteEvaluationRequest request) {
        return this.deleteEvaluationAsync(request, null);
    }

    @Override
    public Future<DeleteEvaluationResult> deleteEvaluationAsync(final DeleteEvaluationRequest request, final AsyncHandler<DeleteEvaluationRequest, DeleteEvaluationResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteEvaluationResult>(){

            @Override
            public DeleteEvaluationResult call() throws Exception {
                DeleteEvaluationResult result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.deleteEvaluation(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteMLModelResult> deleteMLModelAsync(DeleteMLModelRequest request) {
        return this.deleteMLModelAsync(request, null);
    }

    @Override
    public Future<DeleteMLModelResult> deleteMLModelAsync(final DeleteMLModelRequest request, final AsyncHandler<DeleteMLModelRequest, DeleteMLModelResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteMLModelResult>(){

            @Override
            public DeleteMLModelResult call() throws Exception {
                DeleteMLModelResult result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.deleteMLModel(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteRealtimeEndpointResult> deleteRealtimeEndpointAsync(DeleteRealtimeEndpointRequest request) {
        return this.deleteRealtimeEndpointAsync(request, null);
    }

    @Override
    public Future<DeleteRealtimeEndpointResult> deleteRealtimeEndpointAsync(final DeleteRealtimeEndpointRequest request, final AsyncHandler<DeleteRealtimeEndpointRequest, DeleteRealtimeEndpointResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteRealtimeEndpointResult>(){

            @Override
            public DeleteRealtimeEndpointResult call() throws Exception {
                DeleteRealtimeEndpointResult result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.deleteRealtimeEndpoint(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteTagsResult> deleteTagsAsync(DeleteTagsRequest request) {
        return this.deleteTagsAsync(request, null);
    }

    @Override
    public Future<DeleteTagsResult> deleteTagsAsync(final DeleteTagsRequest request, final AsyncHandler<DeleteTagsRequest, DeleteTagsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteTagsResult>(){

            @Override
            public DeleteTagsResult call() throws Exception {
                DeleteTagsResult result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.deleteTags(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeBatchPredictionsResult> describeBatchPredictionsAsync(DescribeBatchPredictionsRequest request) {
        return this.describeBatchPredictionsAsync(request, null);
    }

    @Override
    public Future<DescribeBatchPredictionsResult> describeBatchPredictionsAsync(final DescribeBatchPredictionsRequest request, final AsyncHandler<DescribeBatchPredictionsRequest, DescribeBatchPredictionsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeBatchPredictionsResult>(){

            @Override
            public DescribeBatchPredictionsResult call() throws Exception {
                DescribeBatchPredictionsResult result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.describeBatchPredictions(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeBatchPredictionsResult> describeBatchPredictionsAsync() {
        return this.describeBatchPredictionsAsync(new DescribeBatchPredictionsRequest());
    }

    @Override
    public Future<DescribeBatchPredictionsResult> describeBatchPredictionsAsync(AsyncHandler<DescribeBatchPredictionsRequest, DescribeBatchPredictionsResult> asyncHandler) {
        return this.describeBatchPredictionsAsync(new DescribeBatchPredictionsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeDataSourcesResult> describeDataSourcesAsync(DescribeDataSourcesRequest request) {
        return this.describeDataSourcesAsync(request, null);
    }

    @Override
    public Future<DescribeDataSourcesResult> describeDataSourcesAsync(final DescribeDataSourcesRequest request, final AsyncHandler<DescribeDataSourcesRequest, DescribeDataSourcesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeDataSourcesResult>(){

            @Override
            public DescribeDataSourcesResult call() throws Exception {
                DescribeDataSourcesResult result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.describeDataSources(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDataSourcesResult> describeDataSourcesAsync() {
        return this.describeDataSourcesAsync(new DescribeDataSourcesRequest());
    }

    @Override
    public Future<DescribeDataSourcesResult> describeDataSourcesAsync(AsyncHandler<DescribeDataSourcesRequest, DescribeDataSourcesResult> asyncHandler) {
        return this.describeDataSourcesAsync(new DescribeDataSourcesRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeEvaluationsResult> describeEvaluationsAsync(DescribeEvaluationsRequest request) {
        return this.describeEvaluationsAsync(request, null);
    }

    @Override
    public Future<DescribeEvaluationsResult> describeEvaluationsAsync(final DescribeEvaluationsRequest request, final AsyncHandler<DescribeEvaluationsRequest, DescribeEvaluationsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeEvaluationsResult>(){

            @Override
            public DescribeEvaluationsResult call() throws Exception {
                DescribeEvaluationsResult result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.describeEvaluations(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEvaluationsResult> describeEvaluationsAsync() {
        return this.describeEvaluationsAsync(new DescribeEvaluationsRequest());
    }

    @Override
    public Future<DescribeEvaluationsResult> describeEvaluationsAsync(AsyncHandler<DescribeEvaluationsRequest, DescribeEvaluationsResult> asyncHandler) {
        return this.describeEvaluationsAsync(new DescribeEvaluationsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeMLModelsResult> describeMLModelsAsync(DescribeMLModelsRequest request) {
        return this.describeMLModelsAsync(request, null);
    }

    @Override
    public Future<DescribeMLModelsResult> describeMLModelsAsync(final DescribeMLModelsRequest request, final AsyncHandler<DescribeMLModelsRequest, DescribeMLModelsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeMLModelsResult>(){

            @Override
            public DescribeMLModelsResult call() throws Exception {
                DescribeMLModelsResult result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.describeMLModels(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeMLModelsResult> describeMLModelsAsync() {
        return this.describeMLModelsAsync(new DescribeMLModelsRequest());
    }

    @Override
    public Future<DescribeMLModelsResult> describeMLModelsAsync(AsyncHandler<DescribeMLModelsRequest, DescribeMLModelsResult> asyncHandler) {
        return this.describeMLModelsAsync(new DescribeMLModelsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeTagsResult> describeTagsAsync(DescribeTagsRequest request) {
        return this.describeTagsAsync(request, null);
    }

    @Override
    public Future<DescribeTagsResult> describeTagsAsync(final DescribeTagsRequest request, final AsyncHandler<DescribeTagsRequest, DescribeTagsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeTagsResult>(){

            @Override
            public DescribeTagsResult call() throws Exception {
                DescribeTagsResult result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.describeTags(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetBatchPredictionResult> getBatchPredictionAsync(GetBatchPredictionRequest request) {
        return this.getBatchPredictionAsync(request, null);
    }

    @Override
    public Future<GetBatchPredictionResult> getBatchPredictionAsync(final GetBatchPredictionRequest request, final AsyncHandler<GetBatchPredictionRequest, GetBatchPredictionResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetBatchPredictionResult>(){

            @Override
            public GetBatchPredictionResult call() throws Exception {
                GetBatchPredictionResult result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.getBatchPrediction(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDataSourceResult> getDataSourceAsync(GetDataSourceRequest request) {
        return this.getDataSourceAsync(request, null);
    }

    @Override
    public Future<GetDataSourceResult> getDataSourceAsync(final GetDataSourceRequest request, final AsyncHandler<GetDataSourceRequest, GetDataSourceResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetDataSourceResult>(){

            @Override
            public GetDataSourceResult call() throws Exception {
                GetDataSourceResult result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.getDataSource(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetEvaluationResult> getEvaluationAsync(GetEvaluationRequest request) {
        return this.getEvaluationAsync(request, null);
    }

    @Override
    public Future<GetEvaluationResult> getEvaluationAsync(final GetEvaluationRequest request, final AsyncHandler<GetEvaluationRequest, GetEvaluationResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetEvaluationResult>(){

            @Override
            public GetEvaluationResult call() throws Exception {
                GetEvaluationResult result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.getEvaluation(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetMLModelResult> getMLModelAsync(GetMLModelRequest request) {
        return this.getMLModelAsync(request, null);
    }

    @Override
    public Future<GetMLModelResult> getMLModelAsync(final GetMLModelRequest request, final AsyncHandler<GetMLModelRequest, GetMLModelResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetMLModelResult>(){

            @Override
            public GetMLModelResult call() throws Exception {
                GetMLModelResult result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.getMLModel(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PredictResult> predictAsync(PredictRequest request) {
        return this.predictAsync(request, null);
    }

    @Override
    public Future<PredictResult> predictAsync(final PredictRequest request, final AsyncHandler<PredictRequest, PredictResult> asyncHandler) {
        return this.executorService.submit(new Callable<PredictResult>(){

            @Override
            public PredictResult call() throws Exception {
                PredictResult result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.predict(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateBatchPredictionResult> updateBatchPredictionAsync(UpdateBatchPredictionRequest request) {
        return this.updateBatchPredictionAsync(request, null);
    }

    @Override
    public Future<UpdateBatchPredictionResult> updateBatchPredictionAsync(final UpdateBatchPredictionRequest request, final AsyncHandler<UpdateBatchPredictionRequest, UpdateBatchPredictionResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateBatchPredictionResult>(){

            @Override
            public UpdateBatchPredictionResult call() throws Exception {
                UpdateBatchPredictionResult result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.updateBatchPrediction(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateDataSourceResult> updateDataSourceAsync(UpdateDataSourceRequest request) {
        return this.updateDataSourceAsync(request, null);
    }

    @Override
    public Future<UpdateDataSourceResult> updateDataSourceAsync(final UpdateDataSourceRequest request, final AsyncHandler<UpdateDataSourceRequest, UpdateDataSourceResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateDataSourceResult>(){

            @Override
            public UpdateDataSourceResult call() throws Exception {
                UpdateDataSourceResult result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.updateDataSource(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateEvaluationResult> updateEvaluationAsync(UpdateEvaluationRequest request) {
        return this.updateEvaluationAsync(request, null);
    }

    @Override
    public Future<UpdateEvaluationResult> updateEvaluationAsync(final UpdateEvaluationRequest request, final AsyncHandler<UpdateEvaluationRequest, UpdateEvaluationResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateEvaluationResult>(){

            @Override
            public UpdateEvaluationResult call() throws Exception {
                UpdateEvaluationResult result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.updateEvaluation(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateMLModelResult> updateMLModelAsync(UpdateMLModelRequest request) {
        return this.updateMLModelAsync(request, null);
    }

    @Override
    public Future<UpdateMLModelResult> updateMLModelAsync(final UpdateMLModelRequest request, final AsyncHandler<UpdateMLModelRequest, UpdateMLModelResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateMLModelResult>(){

            @Override
            public UpdateMLModelResult call() throws Exception {
                UpdateMLModelResult result;
                try {
                    result = AmazonMachineLearningAsyncClient.this.updateMLModel(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

