/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.lightsail.model.Disk;
import com.amazonaws.services.lightsail.model.transform.ResourceLocationJsonMarshaller;

public class DiskJsonMarshaller {
    private static DiskJsonMarshaller instance;

    public void marshall(Disk disk, StructuredJsonGenerator jsonGenerator) {
        if (disk == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (disk.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(disk.getName());
            }
            if (disk.getArn() != null) {
                jsonGenerator.writeFieldName("arn").writeValue(disk.getArn());
            }
            if (disk.getSupportCode() != null) {
                jsonGenerator.writeFieldName("supportCode").writeValue(disk.getSupportCode());
            }
            if (disk.getCreatedAt() != null) {
                jsonGenerator.writeFieldName("createdAt").writeValue(disk.getCreatedAt());
            }
            if (disk.getLocation() != null) {
                jsonGenerator.writeFieldName("location");
                ResourceLocationJsonMarshaller.getInstance().marshall(disk.getLocation(), jsonGenerator);
            }
            if (disk.getResourceType() != null) {
                jsonGenerator.writeFieldName("resourceType").writeValue(disk.getResourceType());
            }
            if (disk.getSizeInGb() != null) {
                jsonGenerator.writeFieldName("sizeInGb").writeValue(disk.getSizeInGb());
            }
            if (disk.getGbInUse() != null) {
                jsonGenerator.writeFieldName("gbInUse").writeValue(disk.getGbInUse());
            }
            if (disk.getIsSystemDisk() != null) {
                jsonGenerator.writeFieldName("isSystemDisk").writeValue(disk.getIsSystemDisk());
            }
            if (disk.getIops() != null) {
                jsonGenerator.writeFieldName("iops").writeValue(disk.getIops());
            }
            if (disk.getPath() != null) {
                jsonGenerator.writeFieldName("path").writeValue(disk.getPath());
            }
            if (disk.getAttachedTo() != null) {
                jsonGenerator.writeFieldName("attachedTo").writeValue(disk.getAttachedTo());
            }
            if (disk.getIsAttached() != null) {
                jsonGenerator.writeFieldName("isAttached").writeValue(disk.getIsAttached());
            }
            if (disk.getAttachmentState() != null) {
                jsonGenerator.writeFieldName("attachmentState").writeValue(disk.getAttachmentState());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DiskJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DiskJsonMarshaller();
        }
        return instance;
    }
}

