/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.services.lambda.model.ListFunctionsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class ListFunctionsRequestMarshaller
implements Marshaller<Request<ListFunctionsRequest>, ListFunctionsRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public ListFunctionsRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListFunctionsRequest> marshall(ListFunctionsRequest listFunctionsRequest) {
        if (listFunctionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListFunctionsRequest> request = new DefaultRequest<ListFunctionsRequest>(listFunctionsRequest, "AWSLambda");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2015-03-31/functions/";
        request.setResourcePath(uriResourcePath);
        if (listFunctionsRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString(listFunctionsRequest.getMarker()));
        }
        if (listFunctionsRequest.getMaxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromInteger(listFunctionsRequest.getMaxItems()));
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

