/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kinesis.model.PutRecordRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class PutRecordRequestMarshaller
implements Marshaller<Request<PutRecordRequest>, PutRecordRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public PutRecordRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<PutRecordRequest> marshall(PutRecordRequest putRecordRequest) {
        if (putRecordRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutRecordRequest> request = new DefaultRequest<PutRecordRequest>(putRecordRequest, "AmazonKinesis");
        request.addHeader("X-Amz-Target", "Kinesis_20131202.PutRecord");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (putRecordRequest.getStreamName() != null) {
                jsonGenerator.writeFieldName("StreamName").writeValue(putRecordRequest.getStreamName());
            }
            if (putRecordRequest.getData() != null) {
                jsonGenerator.writeFieldName("Data").writeValue(putRecordRequest.getData());
            }
            if (putRecordRequest.getPartitionKey() != null) {
                jsonGenerator.writeFieldName("PartitionKey").writeValue(putRecordRequest.getPartitionKey());
            }
            if (putRecordRequest.getExplicitHashKey() != null) {
                jsonGenerator.writeFieldName("ExplicitHashKey").writeValue(putRecordRequest.getExplicitHashKey());
            }
            if (putRecordRequest.getSequenceNumberForOrdering() != null) {
                jsonGenerator.writeFieldName("SequenceNumberForOrdering").writeValue(putRecordRequest.getSequenceNumberForOrdering());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

