/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.services.iot.model.GetPolicyVersionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import java.io.ByteArrayInputStream;

public class GetPolicyVersionRequestMarshaller
implements Marshaller<Request<GetPolicyVersionRequest>, GetPolicyVersionRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public GetPolicyVersionRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetPolicyVersionRequest> marshall(GetPolicyVersionRequest getPolicyVersionRequest) {
        if (getPolicyVersionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetPolicyVersionRequest> request = new DefaultRequest<GetPolicyVersionRequest>(getPolicyVersionRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/policies/{policyName}/version/{policyVersionId}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "policyName", getPolicyVersionRequest.getPolicyName());
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "policyVersionId", getPolicyVersionRequest.getPolicyVersionId());
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

