/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.services.glacier.model.ListProvisionedCapacityRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import java.io.ByteArrayInputStream;

public class ListProvisionedCapacityRequestMarshaller
implements Marshaller<Request<ListProvisionedCapacityRequest>, ListProvisionedCapacityRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public ListProvisionedCapacityRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListProvisionedCapacityRequest> marshall(ListProvisionedCapacityRequest listProvisionedCapacityRequest) {
        if (listProvisionedCapacityRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListProvisionedCapacityRequest> request = new DefaultRequest<ListProvisionedCapacityRequest>(listProvisionedCapacityRequest, "AmazonGlacier");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/{accountId}/provisioned-capacity";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "accountId", listProvisionedCapacityRequest.getAccountId() == null ? "-" : listProvisionedCapacityRequest.getAccountId());
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

