/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.gamelift.model.ResolveAliasRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ResolveAliasRequestMarshaller
implements Marshaller<Request<ResolveAliasRequest>, ResolveAliasRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public ResolveAliasRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ResolveAliasRequest> marshall(ResolveAliasRequest resolveAliasRequest) {
        if (resolveAliasRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ResolveAliasRequest> request = new DefaultRequest<ResolveAliasRequest>(resolveAliasRequest, "AmazonGameLift");
        request.addHeader("X-Amz-Target", "GameLift.ResolveAlias");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (resolveAliasRequest.getAliasId() != null) {
                jsonGenerator.writeFieldName("AliasId").writeValue(resolveAliasRequest.getAliasId());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

