/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitosync.model.RegisterDeviceRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import java.io.ByteArrayInputStream;

public class RegisterDeviceRequestMarshaller
implements Marshaller<Request<RegisterDeviceRequest>, RegisterDeviceRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public RegisterDeviceRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<RegisterDeviceRequest> marshall(RegisterDeviceRequest registerDeviceRequest) {
        if (registerDeviceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RegisterDeviceRequest> request = new DefaultRequest<RegisterDeviceRequest>(registerDeviceRequest, "AmazonCognitoSync");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/identitypools/{IdentityPoolId}/identity/{IdentityId}/device";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "IdentityPoolId", registerDeviceRequest.getIdentityPoolId());
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "IdentityId", registerDeviceRequest.getIdentityId());
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (registerDeviceRequest.getPlatform() != null) {
                jsonGenerator.writeFieldName("Platform").writeValue(registerDeviceRequest.getPlatform());
            }
            if (registerDeviceRequest.getToken() != null) {
                jsonGenerator.writeFieldName("Token").writeValue(registerDeviceRequest.getToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

