/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.clouddirectory.model.ListFacetNamesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class ListFacetNamesRequestMarshaller
implements Marshaller<Request<ListFacetNamesRequest>, ListFacetNamesRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public ListFacetNamesRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListFacetNamesRequest> marshall(ListFacetNamesRequest listFacetNamesRequest) {
        if (listFacetNamesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListFacetNamesRequest> request = new DefaultRequest<ListFacetNamesRequest>(listFacetNamesRequest, "AmazonCloudDirectory");
        request.setHttpMethod(HttpMethodName.POST);
        if (listFacetNamesRequest.getSchemaArn() != null) {
            request.addHeader("x-amz-data-partition", StringUtils.fromString(listFacetNamesRequest.getSchemaArn()));
        }
        String uriResourcePath = "/amazonclouddirectory/2017-01-11/facet/list";
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listFacetNamesRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(listFacetNamesRequest.getNextToken());
            }
            if (listFacetNamesRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("MaxResults").writeValue(listFacetNamesRequest.getMaxResults());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

